/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.hyperioncraft.tileentity;

import com.djgiannuzz.hyperioncraft.handler.CheckpointsHandler;
import com.djgiannuzz.hyperioncraft.handler.ConfigHandler;
import com.djgiannuzz.hyperioncraft.handler.PacketHandler;
import com.djgiannuzz.hyperioncraft.packets.SetCheckpointActivePacket;
import com.djgiannuzz.hyperioncraft.packets.SetCheckpointStatePacket;
import com.djgiannuzz.hyperioncraft.utility.HUtility;
import com.djgiannuzz.hyperioncraft.utility.LogHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;

public class TileEntityCheckpoint
extends TileEntity {
    private short checkpointState = 0;
    private short lastCheckpointState = 0;
    private Vector<String> playerNames = new Vector();
    public float animationValue = 0.0f;
    public boolean isMoving = false;
    protected boolean isFirstTick = true;
    private static final int TICK_REVIVE_OPENCLOSE_DELAY = 60;
    private int reviveDelay = 60;
    private boolean isResurrecting = false;
    public boolean isActive = true;
    public boolean ignoreRedstone = false;

    public void func_145845_h() {
        if (this.isFirstTick) {
            this.onFirstTick();
            this.isFirstTick = false;
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && (!this.isMoving || this.getState() != 2)) {
            if (this.isResurrecting) {
                if (this.reviveDelay > 0) {
                    --this.reviveDelay;
                } else {
                    this.setState(1);
                    this.reviveDelay = 60;
                    this.isResurrecting = false;
                }
            } else if (this.isActive) {
                List playersAround = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - ((double)ConfigHandler.checkpointRange + 0.5)), (double)((double)this.field_145848_d - ((double)ConfigHandler.checkpointRange + 0.5)), (double)((double)this.field_145849_e - ((double)ConfigHandler.checkpointRange + 0.5)), (double)((double)this.field_145851_c + ((double)ConfigHandler.checkpointRange + 0.5)), (double)((double)this.field_145848_d + ((double)ConfigHandler.checkpointRange + 0.5)), (double)((double)this.field_145849_e + ((double)ConfigHandler.checkpointRange + 0.5))));
                for (Object obj : playersAround) {
                    int x;
                    EntityPlayer player = (EntityPlayer)obj;
                    if (player.field_71075_bZ.field_75098_d) continue;
                    int n = this.func_145832_p() == 3 ? -2 : (x = this.func_145832_p() == 1 ? 2 : 0);
                    int z = this.func_145832_p() == 2 ? 2 : (this.func_145832_p() == 0 ? -2 : 0);
                    ChunkCoordinates spawnPoint = new ChunkCoordinates(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z);
                    if (CheckpointsHandler.isPlayerCheckpoint(this.getChunkCoord(), player.getDisplayName())) continue;
                    if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                        LogHelper.info("Setting Spawm for: " + player.getDisplayName());
                    }
                    player.func_71063_a(spawnPoint, true);
                    this.addPlayerName(player.getDisplayName());
                    this.setState(1);
                }
            }
            if (this.playerNames == null || this.playerNames.isEmpty()) {
                this.setState(0);
            } else {
                this.setState(1);
            }
        }
        if (!this.isActive && this.getState() == 2) {
            this.setState(1);
        }
        if (this.isMoving) {
            this.animationValue += 0.06f;
            if (this.animationValue >= 1.0f) {
                this.isMoving = false;
                this.animationValue = 0.0f;
            }
        } else {
            this.animationValue = 0.0f;
        }
    }

    protected void onFirstTick() {
        if (!this.ignoreRedstone) {
            if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.setActive(true);
            } else if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                this.setActive(false);
            }
        }
    }

    protected ChunkCoordinates getChunkCoord() {
        return new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setPlayerNames(Vector<String> names) {
        this.playerNames = names;
    }

    protected void addPlayerName(String username) {
        this.playerNames.add(username);
        CheckpointsHandler.addCheckpointName(this.field_145850_b, this.getChunkCoord(), username);
    }

    public short getState() {
        return this.checkpointState;
    }

    public short getLastState() {
        return this.lastCheckpointState;
    }

    public void setState(int state) {
        this.setState((short)state);
    }

    public void setState(short state) {
        if (!this.isMoving) {
            if (state >= 0 && state <= 2) {
                if (state != this.checkpointState) {
                    if (state == 0 && this.checkpointState == 1 || state == 1 && this.checkpointState == 2 || state == 1 && this.checkpointState == 0 || state == 2 && this.checkpointState == 1) {
                        this.lastCheckpointState = this.checkpointState;
                        this.checkpointState = state;
                        if (!this.isFirstTick) {
                            this.isMoving = true;
                        }
                        if (this.getState() == 1 && this.lastCheckpointState == 2) {
                            this.isResurrecting = true;
                        }
                        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                            PacketHandler.network.sendToAllAround((IMessage)new SetCheckpointStatePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getState()), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0));
                        }
                        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q(), 0, 0);
                    } else {
                        LogHelper.error("Tring to set checkpointState to [" + state + "] when the state is [" + this.checkpointState + "].");
                    }
                }
            } else {
                LogHelper.error("Invalid Checkpoint State (" + state + ")");
            }
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("state", this.checkpointState);
        par1NBTTagCompound.func_74777_a("lastState", this.lastCheckpointState);
        par1NBTTagCompound.func_74768_a("playerNamesSize", this.playerNames.size());
        for (int i = 0; i < this.playerNames.size(); ++i) {
            par1NBTTagCompound.func_74778_a("" + i, this.playerNames.elementAt(i));
        }
        par1NBTTagCompound.func_74757_a("ignoreRedstone", this.ignoreRedstone);
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.checkpointState = par1NBTTagCompound.func_74765_d("state");
        this.lastCheckpointState = par1NBTTagCompound.func_74765_d("lastState");
        for (int i = 0; i < par1NBTTagCompound.func_74762_e("playerNamesSize"); ++i) {
            this.playerNames.addElement(par1NBTTagCompound.func_74779_i("" + i));
        }
        this.ignoreRedstone = par1NBTTagCompound.func_74767_n("ignoreRedstone");
        if (this.ignoreRedstone) {
            this.isActive = false;
        }
        CheckpointsHandler.addCheckpointNames(this.getChunkCoord(), this.playerNames);
    }

    public boolean activate(EntityPlayer playerEnt) {
        if (playerEnt.field_71075_bZ.field_75098_d) {
            HUtility.addUnlocalizedChatMessage(playerEnt, "chat.hyperioncraft:boundtothis.name");
            if (this.playerNames.isEmpty()) {
                HUtility.addUnlocalizedChatMessage(playerEnt, "chat.hyperioncraft:noone.name");
            } else {
                for (String s : this.playerNames) {
                    HUtility.addChatMessage(playerEnt, s);
                }
            }
            return true;
        }
        return false;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145843_s() {
        CheckpointsHandler.removeCheckpoint(this.field_145850_b, this.getChunkCoord());
        super.func_145843_s();
    }

    public void setActive(boolean b) {
        this.isActive = b;
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            PacketHandler.network.sendToAllAround((IMessage)new SetCheckpointActivePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.isActive), new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0));
        }
    }
}

