/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.hyperioncraft.packets;

import com.djgiannuzz.hyperioncraft.handler.PacketHandler;
import com.djgiannuzz.hyperioncraft.packets.PlayerRotationPacket;
import com.djgiannuzz.hyperioncraft.tileentity.TileEntityFastTravel;
import com.djgiannuzz.hyperioncraft.utility.HTeleporter;
import com.djgiannuzz.hyperioncraft.utility.HUtility;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.DimensionManager;

public class FastTravelTeleportPlayer
implements IMessage {
    private int dimensionID;
    private int x;
    private int y;
    private int z;

    public FastTravelTeleportPlayer() {
    }

    public FastTravelTeleportPlayer(int dimensionID, int x, int y, int z) {
        this.dimensionID = dimensionID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimensionID = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.x = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.y = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.z = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.dimensionID, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.x, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.y, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.z, (int)5);
    }

    public static class Handler
    implements IMessageHandler<FastTravelTeleportPlayer, IMessage> {
        public IMessage onMessage(FastTravelTeleportPlayer message, MessageContext ctx) {
            TileEntity tile = DimensionManager.getWorld((int)message.dimensionID).func_147438_o(message.x, message.y, message.z);
            if (tile instanceof TileEntityFastTravel) {
                TileEntityFastTravel fastTravel = (TileEntityFastTravel)tile;
                double plusX = (double)(fastTravel.func_145832_p() == 3 ? -2 : (fastTravel.func_145832_p() == 1 ? 2 : 0)) + 0.5;
                double plusY = 1.0;
                double plusZ = (double)(fastTravel.func_145832_p() == 2 ? 2 : (fastTravel.func_145832_p() == 0 ? -2 : 0)) + 0.5;
                double x = (double)message.x + plusX;
                double y = (double)message.y + plusY;
                double z = (double)message.z + plusZ;
                float rotation = HUtility.getPlayerRotationFromMeta(fastTravel.func_145832_p());
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (player.field_71093_bK != message.dimensionID) {
                    ChunkCoordinates overworldSpawn = DimensionManager.getWorld((int)0).func_72861_E();
                    HTeleporter.teleport((EntityPlayer)player, 0, overworldSpawn.field_71574_a, 300.0, overworldSpawn.field_71573_c);
                } else {
                    player.func_70080_a(x, y, z, rotation, 0.0f);
                }
                HTeleporter.teleport((EntityPlayer)player, message.dimensionID, x, y, z);
                PacketHandler.network.sendTo((IMessage)new PlayerRotationPacket(rotation), player);
            }
            return null;
        }
    }
}

