/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.hyperioncraft.packets;

import com.djgiannuzz.hyperioncraft.handler.PacketHandler;
import com.djgiannuzz.hyperioncraft.packets.ClientFastTravelAddPacket;
import com.djgiannuzz.hyperioncraft.utility.ServerFastTravelHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;

public class FastTravelAddPacket
implements IMessage {
    private int dimensionID;
    private int x;
    private int y;
    private int z;
    private String name;
    private boolean isPrivate;
    private String username;

    public FastTravelAddPacket() {
    }

    public FastTravelAddPacket(int dimensionID, int x, int y, int z, String name) {
        this.dimensionID = dimensionID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.name = name;
        this.isPrivate = false;
    }

    public FastTravelAddPacket(int dimensionID, int x, int y, int z, String name, String username) {
        this.dimensionID = dimensionID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.name = name;
        this.isPrivate = true;
        this.username = username;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimensionID = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.x = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.y = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.z = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        boolean bl = this.isPrivate = ByteBufUtils.readVarShort((ByteBuf)buf) != 0;
        if (this.isPrivate) {
            this.username = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.dimensionID, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.x, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.y, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.z, (int)5);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)(this.isPrivate ? 1 : 0));
        if (this.isPrivate) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.username);
        }
    }

    public static class Handler
    implements IMessageHandler<FastTravelAddPacket, IMessage> {
        public IMessage onMessage(FastTravelAddPacket message, MessageContext ctx) {
            if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                if (message.isPrivate) {
                    ServerFastTravelHandler.addPrivatePoint(message.username, message.dimensionID, message.x, message.y, message.z, message.name);
                    PacketHandler.network.sendTo((IMessage)new ClientFastTravelAddPacket(message.dimensionID, message.x, message.y, message.z, message.name, message.username), ctx.getServerHandler().field_147369_b);
                } else {
                    ServerFastTravelHandler.addGlobalPoint(message.dimensionID, message.x, message.y, message.z, message.name);
                    PacketHandler.network.sendToAll((IMessage)new ClientFastTravelAddPacket(message.dimensionID, message.x, message.y, message.z, message.name));
                }
            }
            return null;
        }
    }
}

