/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.hyperioncraft.packets;

import com.djgiannuzz.hyperioncraft.tileentity.TileEntityFastTravel;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;

public class ClientLockFastTravelPacket
implements IMessage {
    private int dimensionID;
    private int x;
    private int y;
    private int z;
    private boolean isLocked;

    public ClientLockFastTravelPacket() {
    }

    public ClientLockFastTravelPacket(int dimensionID, int x, int y, int z, boolean isLocked) {
        this.dimensionID = dimensionID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.isLocked = isLocked;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimensionID = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.x = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.y = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.z = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.isLocked = ByteBufUtils.readVarShort((ByteBuf)buf) != 0;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.dimensionID, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.x, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.y, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.z, (int)5);
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)(this.isLocked ? 1 : 0));
    }

    public static class Handler
    implements IMessageHandler<ClientLockFastTravelPacket, IMessage> {
        public IMessage onMessage(ClientLockFastTravelPacket message, MessageContext ctx) {
            TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_147438_o(message.x, message.y, message.z);
            if (tile != null && tile instanceof TileEntityFastTravel) {
                TileEntityFastTravel fastTravel = (TileEntityFastTravel)tile;
                fastTravel.isLocked = message.isLocked;
            }
            return null;
        }
    }
}

