/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.hyperioncraft.packets;

import com.djgiannuzz.hyperioncraft.gui.GuiFastTravel;
import com.djgiannuzz.hyperioncraft.utility.ClientFastTravelHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class ClientFastTravelRemovePacket
implements IMessage {
    private int dimensionID;
    private int x;
    private int y;
    private int z;
    private boolean isPrivate;
    private String username;

    public ClientFastTravelRemovePacket() {
    }

    public ClientFastTravelRemovePacket(int dimensionID, int x, int y, int z) {
        this.dimensionID = dimensionID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.isPrivate = false;
    }

    public ClientFastTravelRemovePacket(int dimensionID, int x, int y, int z, String username) {
        this.dimensionID = dimensionID;
        this.x = x;
        this.y = y;
        this.z = z;
        this.isPrivate = true;
        this.username = username;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimensionID = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.x = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.y = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.z = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        boolean bl = this.isPrivate = ByteBufUtils.readVarShort((ByteBuf)buf) != 0;
        if (this.isPrivate) {
            this.username = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.dimensionID, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.x, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.y, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.z, (int)5);
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)(this.isPrivate ? 1 : 0));
        if (this.isPrivate) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.username);
        }
    }

    public static class Handler
    implements IMessageHandler<ClientFastTravelRemovePacket, IMessage> {
        public IMessage onMessage(ClientFastTravelRemovePacket message, MessageContext ctx) {
            if (message.isPrivate) {
                ClientFastTravelHandler.removePrivatePoint(message.username, message.dimensionID, message.x, message.y, message.z);
            } else {
                ClientFastTravelHandler.removeGlobalPoint(message.dimensionID, message.x, message.y, message.z);
            }
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen instanceof GuiFastTravel) {
                GuiFastTravel gui = (GuiFastTravel)screen;
                gui.updateTeleportButtons(gui.getCurrentScrollInt());
            }
            return null;
        }
    }
}

