/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.hyperioncraft.handler;

import com.djgiannuzz.hyperioncraft.blocks.BlockFastTravel;
import com.djgiannuzz.hyperioncraft.blocks.BlockGagFastTravel;
import com.djgiannuzz.hyperioncraft.handler.CheckpointsHandler;
import com.djgiannuzz.hyperioncraft.handler.ConfigHandler;
import com.djgiannuzz.hyperioncraft.handler.PacketHandler;
import com.djgiannuzz.hyperioncraft.packets.ClientLoadPointsPacket;
import com.djgiannuzz.hyperioncraft.packets.PlayerRotationPacket;
import com.djgiannuzz.hyperioncraft.reference.Quotes;
import com.djgiannuzz.hyperioncraft.tileentity.TileEntityCheckpoint;
import com.djgiannuzz.hyperioncraft.tileentity.TileEntityFastTravel;
import com.djgiannuzz.hyperioncraft.tileentity.TileEntityGag;
import com.djgiannuzz.hyperioncraft.utility.ClientFastTravelHandler;
import com.djgiannuzz.hyperioncraft.utility.HUtility;
import com.djgiannuzz.hyperioncraft.utility.LogHelper;
import com.djgiannuzz.hyperioncraft.utility.ServerFastTravelHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;

public class HyperionEventHandler {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void playerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        TileEntity tile;
        ChunkCoordinates coord;
        if (ConfigHandler.enableRespawnMessage && (coord = CheckpointsHandler.getplayerCheckpoint(event.player.getDisplayName())) != null && (tile = event.player.field_70170_p.func_147438_o(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c)) != null && tile instanceof TileEntityCheckpoint) {
            float rotation;
            TileEntityCheckpoint checkpoint = (TileEntityCheckpoint)tile;
            int random = (int)(Math.random() * (double)Quotes.CHECKPOINT_QUOTES.length);
            HUtility.addChatMessage(event.player, "<New-U Station> " + Quotes.CHECKPOINT_QUOTES[random]);
            checkpoint.setState(2);
            event.player.field_70170_p.func_72908_a((double)checkpoint.field_145851_c + 0.5, (double)checkpoint.field_145848_d + 0.5, (double)checkpoint.field_145849_e + 0.5, "hyperioncraft:" + (random + 1), 1.0f, 1.0f);
            event.player.field_70177_z = rotation = HUtility.getPlayerRotationFromMeta(checkpoint.func_145832_p());
            event.player.field_70759_as = rotation;
            PacketHandler.network.sendTo((IMessage)new PlayerRotationPacket(rotation), (EntityPlayerMP)event.player);
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            PacketHandler.network.sendTo((IMessage)new ClientLoadPointsPacket(ServerFastTravelHandler.getGlobalPoints(), ServerFastTravelHandler.getPrivatePoints(event.player.getDisplayName())), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onWorldUnLoad(WorldEvent.Unload event) {
        LogHelper.info("Unloading Checkpoints");
        CheckpointsHandler.checkpointNames.clear();
        LogHelper.info("Unloading FastTravelStations");
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            ServerFastTravelHandler.unload();
        } else if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            ClientFastTravelHandler.unload();
        }
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        if (!event.getPlayer().field_71075_bZ.field_75098_d) {
            TileEntityFastTravel tileFast = null;
            if (event.block instanceof BlockFastTravel) {
                tileFast = (TileEntityFastTravel)event.world.func_147438_o(event.x, event.y, event.z);
            } else if (event.block instanceof BlockGagFastTravel) {
                TileEntityGag tileGag = (TileEntityGag)event.world.func_147438_o(event.x, event.y, event.z);
                TileEntity tile = event.world.func_147438_o(tileGag.primary_x, tileGag.primary_y, tileGag.primary_z);
                if (tile instanceof TileEntityFastTravel) {
                    tileFast = (TileEntityFastTravel)tile;
                }
            }
            if (tileFast != null && !tileFast.ownerUsername.equals(event.getPlayer().getDisplayName())) {
                HUtility.addUnlocalizedChatMessage(event.getPlayer(), "chat.hyperioncraft:cantbreak.name");
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            PacketHandler.network.sendTo((IMessage)new ClientLoadPointsPacket(ServerFastTravelHandler.getGlobalPoints(), ServerFastTravelHandler.getPrivatePoints(event.player.getDisplayName())), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        for (String name : CheckpointsHandler.playersToResetSpawnOnLogin.keySet()) {
            if (!event.player.getDisplayName().equals(name)) continue;
            LogHelper.debug("ResettingSpawn for " + event.player.getDisplayName());
            int dimensionID = CheckpointsHandler.playersToResetSpawnOnLogin.get(name);
            event.player.setSpawnChunk(DimensionManager.getWorld((int)dimensionID).func_72861_E(), true, dimensionID);
            CheckpointsHandler.playersToResetSpawnOnLogin.remove(name);
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            PacketHandler.network.sendTo((IMessage)new ClientLoadPointsPacket(ServerFastTravelHandler.getGlobalPoints(), ServerFastTravelHandler.getPrivatePoints(event.player.getDisplayName())), (EntityPlayerMP)event.player);
        }
    }
}

