/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.hyperioncraft.handler;

import com.djgiannuzz.hyperioncraft.handler.PacketHandler;
import com.djgiannuzz.hyperioncraft.packets.RemovePlayerFromCheckpointPacket;
import com.djgiannuzz.hyperioncraft.tileentity.TileEntityCheckpoint;
import com.djgiannuzz.hyperioncraft.utility.LogHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.HashMap;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class CheckpointsHandler {
    public static HashMap<ChunkCoordinates, Vector<String>> checkpointNames = new HashMap();
    public static HashMap<String, Integer> playersToResetSpawnOnLogin = new HashMap();

    public static boolean addCheckpoint(ChunkCoordinates coord) {
        return checkpointNames.put(coord, new Vector()) != null;
    }

    public static Vector<String> getCheckpointNames(ChunkCoordinates coord) {
        return checkpointNames.get(coord);
    }

    public static void addCheckpointNames(ChunkCoordinates coord, Vector<String> names) {
        checkpointNames.put(coord, names);
    }

    public static void addCheckpointName(World world, ChunkCoordinates coord, String username) {
        if (!checkpointNames.containsKey(coord)) {
            CheckpointsHandler.addCheckpoint(coord);
        }
        for (ChunkCoordinates coords : checkpointNames.keySet()) {
            CheckpointsHandler.removeCheckpointName(world, coords, username);
        }
        checkpointNames.get(coord).add(username);
    }

    public static ChunkCoordinates getplayerCheckpoint(String username) {
        for (ChunkCoordinates coords : checkpointNames.keySet()) {
            if (!checkpointNames.get(coords).contains(username)) continue;
            return coords;
        }
        return null;
    }

    public static void removeCheckpointName(World world, ChunkCoordinates coord, String username) {
        if (!checkpointNames.containsKey(coord)) {
            return;
        }
        Vector<String> vec = checkpointNames.get(coord);
        vec.removeElement(username);
        checkpointNames.put(coord, vec);
        TileEntity tile = world.func_147438_o(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c);
        if (tile instanceof TileEntityCheckpoint) {
            TileEntityCheckpoint checkpoint = (TileEntityCheckpoint)tile;
            checkpoint.setPlayerNames(checkpointNames.get(coord));
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                PacketHandler.network.sendToServer((IMessage)new RemovePlayerFromCheckpointPacket(coord.field_71574_a, coord.field_71572_b, coord.field_71573_c, username));
            }
            LogHelper.debug("Removing " + username + " from " + coord);
        }
    }

    public static boolean isPlayerCheckpoint(ChunkCoordinates coord, String username) {
        if (!checkpointNames.containsKey(coord)) {
            return false;
        }
        for (String name : checkpointNames.get(coord)) {
            if (!name.equals(username)) continue;
            return true;
        }
        return false;
    }

    public static void removeCheckpoint(World world, ChunkCoordinates coord) {
        Vector<String> names = checkpointNames.remove(coord);
        if (names != null) {
            for (String name : names) {
                EntityPlayer playerToRemove = world.func_72924_a(name);
                if (playerToRemove != null) {
                    playerToRemove.func_71063_a(world.func_72861_E(), true);
                    continue;
                }
                playersToResetSpawnOnLogin.put(name, world.field_73011_w.field_76574_g);
            }
        }
    }

    public static void clear() {
        checkpointNames.clear();
    }
}

