/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.hyperioncraft.gui;

import com.djgiannuzz.hyperioncraft.gui.buttons.ButtonAddRemove;
import com.djgiannuzz.hyperioncraft.gui.buttons.ButtonLock;
import com.djgiannuzz.hyperioncraft.gui.buttons.ButtonTeleport;
import com.djgiannuzz.hyperioncraft.handler.FastTravelPosition;
import com.djgiannuzz.hyperioncraft.handler.PacketHandler;
import com.djgiannuzz.hyperioncraft.packets.FastTravelAddPacket;
import com.djgiannuzz.hyperioncraft.packets.FastTravelRemovePacket;
import com.djgiannuzz.hyperioncraft.packets.FastTravelTeleportPlayer;
import com.djgiannuzz.hyperioncraft.packets.LockFastTravelPacket;
import com.djgiannuzz.hyperioncraft.tileentity.TileEntityFastTravel;
import com.djgiannuzz.hyperioncraft.utility.ClientFastTravelHandler;
import com.djgiannuzz.hyperioncraft.utility.HUtility;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiFastTravel
extends GuiScreen {
    private static ResourceLocation tex = new ResourceLocation("hyperioncraft", "textures/gui/FastTravelGui.png");
    private TileEntityFastTravel tile;
    private String username;
    private boolean isGlobal;
    private int dimensionID;
    int x;
    int y;
    int z;
    private static int xSize = 215;
    private static int ySize = 241;
    private GuiTextField textBox;
    private FontRenderer fontRenderer;
    public static final int TELEPORT_BUTTON_ID_START = 3;
    private static final int MAX_BUTTONS = 12;
    private long lastClicked = Minecraft.func_71386_F();
    private int lastIDClicked = -1;
    private GuiButton selectedButton;
    private TileEntityFastTravel fastTravel;
    private float currentScroll;
    protected static HashMap<Integer, String> dimensionNames = new HashMap();

    public GuiFastTravel(int x, int y, int z, World world, String username) {
        this.username = username;
        this.dimensionID = world.field_73011_w.field_76574_g;
        this.x = x;
        this.y = y;
        this.z = z;
        this.field_146291_p = true;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityFastTravel) {
            this.fastTravel = (TileEntityFastTravel)tile;
            this.isGlobal = !this.fastTravel.isLocked;
        }
        Integer[] arr$ = DimensionManager.getStaticDimensionIDs();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int dimensionId = arr$[i$];
            dimensionNames.put(dimensionId, DimensionManager.createProviderFor((int)dimensionId).func_80007_l());
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.fontRenderer = this.field_146297_k.field_71466_p;
        Keyboard.enableRepeatEvents((boolean)true);
        this.textBox = new GuiTextField(this.fontRenderer, (this.field_146294_l - xSize) / 2 + 23, (this.field_146295_m - ySize) / 2 + 40, 120, this.fontRenderer.field_78288_b + 4);
        this.textBox.func_146203_f(20);
        this.textBox.func_146185_a(true);
        this.textBox.func_146193_g(0xFFFFFF);
        this.textBox.func_146205_d(true);
        this.textBox.func_146195_b(this.canPlayerModify());
        this.field_146292_n.add(new ButtonAddRemove(0, (this.field_146294_l - xSize) / 2 + 150, (this.field_146295_m - ySize) / 2 + 37, true));
        this.field_146292_n.add(new ButtonAddRemove(1, (this.field_146294_l - xSize) / 2 + 170, (this.field_146295_m - ySize) / 2 + 37, false));
        this.field_146292_n.add(new ButtonLock(2, (this.field_146294_l - xSize) / 2 + 160, (this.field_146295_m - ySize) / 2 + 10, !this.isGlobal));
        this.updateTeleportButtons();
    }

    public void clearTeleportButtons() {
        Iterator itr = this.field_146292_n.iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof ButtonTeleport)) continue;
            itr.remove();
        }
    }

    private boolean canPlayerModify() {
        return this.fastTravel.ownerUsername.equals(this.field_146297_k.field_71439_g.getDisplayName()) || this.field_146297_k.field_71439_g.field_71075_bZ.field_75098_d;
    }

    private void updateTeleportButtons() {
        this.clearTeleportButtons();
        Vector<FastTravelPosition> globalPoints = ClientFastTravelHandler.getGlobalPoints();
        Vector<FastTravelPosition> privatePoints = ClientFastTravelHandler.getPrivatePoints(this.username);
        if (this.isGlobal) {
            if (globalPoints != null) {
                for (int i = 0; i < globalPoints.size(); ++i) {
                    ButtonTeleport button = new ButtonTeleport(i + 3, (this.field_146294_l - xSize) / 2 + 10, (this.field_146295_m - ySize) / 2 + 64 + 13 * i, globalPoints.get(i).getName(), globalPoints.get(i).equals(this.dimensionID, this.x, this.y, this.z));
                    if (i >= 12) {
                        button.field_146125_m = false;
                    }
                    this.field_146292_n.add(button);
                }
            }
        } else if (privatePoints != null) {
            for (int i = 0; i < privatePoints.size(); ++i) {
                ButtonTeleport button = new ButtonTeleport(i + 3, (this.field_146294_l - xSize) / 2 + 10, (this.field_146295_m - ySize) / 2 + 64 + 13 * i, privatePoints.get(i).getName(), privatePoints.get(i).equals(this.dimensionID, this.x, this.y, this.z));
                if (i >= 12) {
                    button.field_146125_m = false;
                }
                this.field_146292_n.add(button);
            }
        }
        if (!this.getCurrentName().isEmpty()) {
            this.textBox.func_146180_a(this.getCurrentName());
        }
    }

    public int getCurrentScrollInt() {
        int i = this.field_146292_n.size() - 3 - 12;
        int j = (int)((double)(this.currentScroll * (float)i) + 0.5);
        if (j < 0) {
            j = 0;
        }
        return j;
    }

    public void updateTeleportButtons(int scroll) {
        if (this.field_146292_n.size() - 3 < 13) {
            this.updateTeleportButtons();
        }
        this.clearTeleportButtons();
        Vector<FastTravelPosition> globalPoints = ClientFastTravelHandler.getGlobalPoints();
        Vector<FastTravelPosition> privatePoints = ClientFastTravelHandler.getPrivatePoints(this.username);
        int j = 0;
        if (this.isGlobal) {
            if (globalPoints != null) {
                for (int i = 0; i < globalPoints.size(); ++i) {
                    ButtonTeleport button;
                    if (i >= scroll && i < 12 + scroll) {
                        button = new ButtonTeleport(i + 3, (this.field_146294_l - xSize) / 2 + 10, (this.field_146295_m - ySize) / 2 + 64 + 13 * j, globalPoints.get(i).getName(), globalPoints.get(i).equals(this.dimensionID, this.x, this.y, this.z));
                        ++j;
                    } else {
                        button = new ButtonTeleport(i + 3, 0, 0, globalPoints.get(i).getName(), globalPoints.get(i).equals(this.dimensionID, this.x, this.y, this.z));
                        button.field_146125_m = false;
                    }
                    this.field_146292_n.add(button);
                }
            }
        } else if (privatePoints != null) {
            for (int i = 0; i < privatePoints.size(); ++i) {
                j = i + scroll;
                ButtonTeleport button = new ButtonTeleport(i + 3, (this.field_146294_l - xSize) / 2 + 10, (this.field_146295_m - ySize) / 2 + 64 + 13 * i, privatePoints.get(j).getName(), privatePoints.get(j).equals(this.dimensionID, this.x, this.y, this.z));
                if (i < scroll || i >= 12 + scroll) {
                    button.field_146125_m = false;
                }
                this.field_146292_n.add(button);
            }
        }
        if (!this.getCurrentName().isEmpty()) {
            this.textBox.func_146180_a(this.getCurrentName());
        }
    }

    public void func_73863_a(int x, int y, float var3) {
        this.field_146297_k.field_71446_o.func_110577_a(tex);
        int var5 = (this.field_146294_l - xSize) / 2;
        int var6 = (this.field_146295_m - ySize) / 2;
        this.func_73729_b(var5, var6, 0, 0, xSize, ySize);
        this.textBox.func_146194_f();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_73863_a(x, y, var3);
        this.renderToolTip(this.getButtonToolTip(x, y), x, y);
    }

    private int getButtonIdAt(int x, int z) {
        int i = 0;
        for (Object o : this.field_146292_n) {
            if (!(o instanceof ButtonTeleport)) continue;
            ButtonTeleport button = (ButtonTeleport)((Object)o);
            if (HUtility.isIntegerInRangeEqual(x, button.field_146128_h, button.field_146128_h + button.func_146117_b()) && HUtility.isIntegerInRangeEqual(z, button.field_146129_i, button.field_146129_i + button.getButtonHeight())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private ArrayList getTeleportButtonPos(int x, int z) {
        ArrayList<String> list = new ArrayList<String>();
        int id = this.getButtonIdAt(x, z);
        if (id >= 0) {
            int maxScroll = this.field_146292_n.size() - 3 - 12;
            int scroll = (int)((double)(this.currentScroll * (float)maxScroll) + 0.5);
            if (scroll < 0) {
                scroll = 0;
            }
            if (this.isGlobal) {
                if (id + scroll < ClientFastTravelHandler.getGlobalPoints().size()) {
                    FastTravelPosition pos = ClientFastTravelHandler.getGlobalPoints().get(id + scroll);
                    list.add(dimensionNames.get(pos.getDimensionID()) + pos.toString());
                }
            } else if (id + scroll < ClientFastTravelHandler.getPrivatePoints(this.username).size()) {
                FastTravelPosition pos = ClientFastTravelHandler.getPrivatePoints(this.username).get(id + scroll);
                list.add(dimensionNames.get(pos.getDimensionID()) + pos.toString());
            }
        }
        return list;
    }

    private List getButtonToolTip(int x, int z) {
        ArrayList list = new ArrayList();
        if (this.isPublicPrivateButton(x, z)) {
            if (this.isGlobal) {
                list.add("Public");
            } else {
                list.add("Private");
            }
        } else if (this.isAddButton(x, z)) {
            list.add("Add");
        } else if (this.isRemoveButton(x, z)) {
            list.add("Remove");
        } else {
            list = this.getTeleportButtonPos(x, z);
        }
        return list;
    }

    private boolean isPublicPrivateButton(int x, int y) {
        return HUtility.isIntegerInRangeEqual(x, (this.field_146294_l - xSize) / 2 + 160, (this.field_146294_l - xSize) / 2 + 184) && HUtility.isIntegerInRangeEqual(y, (this.field_146295_m - ySize) / 2 + 10, (this.field_146295_m - ySize) / 2 + 34);
    }

    public boolean isAddButton(int x, int y) {
        return HUtility.isIntegerInRangeEqual(x, (this.field_146294_l - xSize) / 2 + 150, (this.field_146294_l - xSize) / 2 + 168) && HUtility.isIntegerInRangeEqual(y, (this.field_146295_m - ySize) / 2 + 37, (this.field_146295_m - ySize) / 2 + 55);
    }

    public boolean isRemoveButton(int x, int y) {
        return HUtility.isIntegerInRangeEqual(x, (this.field_146294_l - xSize) / 2 + 170, (this.field_146294_l - xSize) / 2 + 188) && HUtility.isIntegerInRangeEqual(y, (this.field_146295_m - ySize) / 2 + 37, (this.field_146295_m - ySize) / 2 + 55);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146274_d() {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            int j = this.field_146292_n.size() - 3 - 12;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
            this.scrollTo(this.currentScroll);
        }
    }

    public void scrollTo(float scroll) {
        int i = this.field_146292_n.size() - 3 - 12;
        int j = (int)((double)(scroll * (float)i) + 0.5);
        if (j < 0) {
            j = 0;
        }
        this.updateTeleportButtons(j);
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else if (this.textBox.func_146206_l() && par2 == 28) {
            this.addThis();
            this.textBox.func_146195_b(false);
        } else if (!this.textBox.func_146206_l() && par2 == 211) {
            this.removeThis();
        } else {
            this.textBox.func_146201_a(par1, par2);
        }
    }

    protected void func_73864_a(int x, int y, int buttonClicked) {
        super.func_73864_a(x, y, buttonClicked);
        if (this.canPlayerModify()) {
            this.textBox.func_146192_a(x, y, buttonClicked);
        }
    }

    private String getCurrentName() {
        for (Object o : this.field_146292_n) {
            if (!(o instanceof ButtonTeleport)) continue;
            ButtonTeleport button = (ButtonTeleport)((Object)o);
            if (!button.isActive) continue;
            return button.field_146126_j;
        }
        return "";
    }

    protected void sendMessageDoesntBelongToYou() {
        HUtility.addUnlocalizedChatMessage((EntityPlayer)this.field_146297_k.field_71439_g, "chat.hyperioncraft:doesntbelongtoyou.name");
    }

    private void addThis() {
        if (this.canPlayerModify()) {
            if (!this.textBox.func_146179_b().isEmpty()) {
                if (this.isGlobal) {
                    PacketHandler.network.sendToServer((IMessage)new FastTravelAddPacket(this.dimensionID, this.x, this.y, this.z, this.textBox.func_146179_b()));
                } else {
                    PacketHandler.network.sendToServer((IMessage)new FastTravelAddPacket(this.dimensionID, this.x, this.y, this.z, this.textBox.func_146179_b(), this.username));
                }
                this.updateTeleportButtons();
            }
        } else {
            this.sendMessageDoesntBelongToYou();
        }
    }

    private void removeThis() {
        if (this.canPlayerModify()) {
            if (this.isGlobal) {
                PacketHandler.network.sendToServer((IMessage)new FastTravelRemovePacket(this.dimensionID, this.x, this.y, this.z));
            } else {
                PacketHandler.network.sendToServer((IMessage)new FastTravelRemovePacket(this.dimensionID, this.x, this.y, this.z, this.username));
            }
            this.updateTeleportButtons();
            this.textBox.func_146195_b(true);
        } else {
            this.sendMessageDoesntBelongToYou();
        }
    }

    protected void func_146284_a(GuiButton var1) {
        if (var1.field_146124_l) {
            int ID = var1.field_146127_k;
            switch (ID) {
                case 0: {
                    this.addThis();
                    break;
                }
                case 1: {
                    this.removeThis();
                    break;
                }
                case 2: {
                    GuiButton button;
                    if (var1 instanceof ButtonLock) {
                        if (this.canPlayerModify()) {
                            button = (ButtonLock)var1;
                            button.isLocked = !button.isLocked;
                            this.isGlobal = !button.isLocked;
                            this.fastTravel.isLocked = button.isLocked;
                            PacketHandler.network.sendToServer((IMessage)new LockFastTravelPacket(this.dimensionID, this.x, this.y, this.z, button.isLocked));
                            this.updateTeleportButtons();
                        } else {
                            this.sendMessageDoesntBelongToYou();
                        }
                    }
                }
                default: {
                    GuiButton button;
                    if (var1 instanceof ButtonTeleport) {
                        button = (ButtonTeleport)var1;
                        if (!button.isActive && ID == this.lastIDClicked && Minecraft.func_71386_F() - this.lastClicked < 250L) {
                            FastTravelPosition pos = this.isGlobal ? ClientFastTravelHandler.getGlobalPoints().get(ID - 3) : ClientFastTravelHandler.getPrivatePoints(this.username).get(ID - 3);
                            if (pos != null) {
                                PacketHandler.network.sendToServer((IMessage)new FastTravelTeleportPlayer(pos.getDimensionID(), pos.getX(), pos.getY(), pos.getZ()));
                                this.field_146297_k.field_71439_g.func_70107_b((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                                this.field_146297_k.field_71439_g.func_71053_j();
                            }
                        } else {
                            this.lastIDClicked = -1;
                        }
                    }
                    this.lastClicked = Minecraft.func_71386_F();
                    this.lastIDClicked = ID;
                }
            }
        }
    }

    protected void renderToolTip(List list, int x, int y) {
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, EnumRarity.common.field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        this.drawHoveringText(list, x, y, this.fontRenderer);
    }
}

