/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.hyperioncraft.blocks;

import com.djgiannuzz.hyperioncraft.blocks.BlockCheckpoint;
import com.djgiannuzz.hyperioncraft.init.ModBlocks;
import com.djgiannuzz.hyperioncraft.tileentity.TileEntityCheckpoint;
import com.djgiannuzz.hyperioncraft.tileentity.TileEntityFastTravel;
import com.djgiannuzz.hyperioncraft.tileentity.TileEntityGag;
import com.djgiannuzz.hyperioncraft.utility.HUtility;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockFastTravel
extends BlockCheckpoint {
    public BlockFastTravel() {
        this.func_149663_c("fasttravel");
        this.func_149711_c(5.0f);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        TileEntityFastTravel tile = (TileEntityFastTravel)world.func_147438_o(x, y, z);
        return tile.activate(player);
    }

    @Override
    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new TileEntityFastTravel();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(String.format("%s", this.getUnwrappedUnlocalizedName(String.format("tile.%s%s", "hyperioncraft".toLowerCase() + ":", this.getUnwrappedUnlocalizedName("checkpoint")))));
    }

    @Override
    public boolean func_149742_c(World world, int x, int y, int z) {
        boolean canPlace = true;
        for (int i = 0; i < gagShift.length; ++i) {
            if (world.func_147439_a(x + gagShift[i][0], y + gagShift[i][1], z + gagShift[i][2]) == null || world.func_147437_c(x + gagShift[i][0], y + gagShift[i][1], z + gagShift[i][2]) && world.func_147439_a(x + gagShift[i][0], y + gagShift[i][1], z + gagShift[i][2]).isReplaceable((IBlockAccess)world, x + gagShift[i][0], y + gagShift[i][1], z + gagShift[i][2])) continue;
            canPlace = false;
        }
        Block block = world.func_147439_a(x, y, z);
        return (block == null || block.isReplaceable((IBlockAccess)world, x, y, z)) && canPlace;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack item) {
        boolean isCheckpointDeactivated = false;
        EntityPlayer player = null;
        if (entity instanceof EntityPlayer) {
            player = (EntityPlayer)entity;
        }
        if (player != null) {
            if (!world.field_73011_w.func_76567_e()) {
                if (FMLCommonHandler.instance().getEffectiveSide().isClient() && player != null) {
                    HUtility.addUnlocalizedChatMessage(player, "chat.hyperioncraft:checkpointwontworkhere.name");
                }
                isCheckpointDeactivated = true;
            }
        } else {
            return;
        }
        if (this.areCheckpointsAround(world, x, y, z)) {
            if (FMLCommonHandler.instance().getEffectiveSide().isClient() && player != null) {
                HUtility.addUnlocalizedChatMessage(player, "chat.hyperioncraft:checkpointwontworkherearound.name");
            }
            isCheckpointDeactivated = true;
        }
        int dir = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        world.func_72921_c(x, y, z, dir, 2);
        for (int i = 0; i < gagShift.length; ++i) {
            world.func_147465_d(x + gagShift[i][0], y + gagShift[i][1], z + gagShift[i][2], (Block)ModBlocks.gagFastTravel, 0, 2);
            TileEntityGag tileFiller = (TileEntityGag)world.func_147438_o(x + gagShift[i][0], y + gagShift[i][1], z + gagShift[i][2]);
            if (tileFiller == null) continue;
            tileFiller.primary_x = x;
            tileFiller.primary_y = y;
            tileFiller.primary_z = z;
        }
        TileEntityFastTravel fastTravel = (TileEntityFastTravel)world.func_147438_o(x, y, z);
        fastTravel.ownerUsername = player.getDisplayName();
        if (!world.field_72995_K) {
            TileEntityCheckpoint checkpoint = (TileEntityCheckpoint)world.func_147438_o(x, y, z);
            if (!isCheckpointDeactivated) {
                if (!world.func_72864_z(x, y, z)) {
                    checkpoint.setActive(true);
                } else if (world.func_72864_z(x, y, z)) {
                    checkpoint.setActive(false);
                }
            } else {
                checkpoint.setActive(false);
                checkpoint.ignoreRedstone = true;
            }
        }
    }

    @Override
    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntityCheckpoint checkpoint = (TileEntityCheckpoint)world.func_147438_o(x, y, z);
        if (!checkpoint.ignoreRedstone && !world.field_72995_K) {
            if (!world.func_72864_z(x, y, z)) {
                checkpoint.setActive(true);
            } else if (world.func_72864_z(x, y, z)) {
                checkpoint.setActive(false);
            }
        }
    }

    @Override
    public boolean func_149696_a(World world, int x, int y, int z, int p_149696_5_, int p_149696_6_) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityCheckpoint) {
            TileEntityCheckpoint checkpoint = (TileEntityCheckpoint)tile;
            if (!checkpoint.ignoreRedstone && !world.field_72995_K) {
                if (!world.func_72864_z(x, y, z)) {
                    checkpoint.setActive(true);
                } else if (world.func_72864_z(x, y, z)) {
                    checkpoint.setActive(false);
                }
            }
            return true;
        }
        return false;
    }
}

