/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.hyperioncraft.blocks;

import com.djgiannuzz.hyperioncraft.blocks.BlockHyperion;
import com.djgiannuzz.hyperioncraft.handler.ConfigHandler;
import com.djgiannuzz.hyperioncraft.init.ModBlocks;
import com.djgiannuzz.hyperioncraft.tileentity.TileEntityCheckpoint;
import com.djgiannuzz.hyperioncraft.tileentity.TileEntityGag;
import com.djgiannuzz.hyperioncraft.utility.HUtility;
import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCheckpoint
extends BlockHyperion {
    public static final int[][] gagShift = new int[][]{{0, 1, 0}, {0, 2, 0}};

    public BlockCheckpoint() {
        this.func_149663_c("checkpoint");
        this.func_149658_d("checkpoint");
        this.func_149711_c(5.0f);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 3.0f, 1.0f);
        this.func_149715_a(3.0f);
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new TileEntityCheckpoint();
    }

    public boolean func_149646_a(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        boolean canPlace = true;
        for (int i = 0; i < gagShift.length; ++i) {
            if (world.func_147439_a(x + gagShift[i][0], y + gagShift[i][1], z + gagShift[i][2]) == null || world.func_147437_c(x + gagShift[i][0], y + gagShift[i][1], z + gagShift[i][2]) && world.func_147439_a(x + gagShift[i][0], y + gagShift[i][1], z + gagShift[i][2]).isReplaceable((IBlockAccess)world, x + gagShift[i][0], y + gagShift[i][1], z + gagShift[i][2])) continue;
            canPlace = false;
        }
        Block block = world.func_147439_a(x, y, z);
        return (block == null || block.isReplaceable((IBlockAccess)world, x, y, z)) && canPlace;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int p_149727_6_, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        TileEntityCheckpoint tile = (TileEntityCheckpoint)world.func_147438_o(x, y, z);
        return tile.activate(player);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack item) {
        super.func_149689_a(world, x, y, z, entity, item);
        EntityPlayer player = null;
        if (entity instanceof EntityPlayer) {
            player = (EntityPlayer)entity;
        }
        if (player != null) {
            if (!world.field_73011_w.func_76567_e()) {
                world.func_147468_f(x, y, z);
                if (FMLCommonHandler.instance().getEffectiveSide().isServer() && player.field_71075_bZ.field_75098_d) {
                    world.func_72885_a((Entity)null, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), 5.0f, true, true);
                }
                if (FMLCommonHandler.instance().getEffectiveSide().isClient() && player != null) {
                    HUtility.addUnlocalizedChatMessage(player, "chat.hyperioncraft:cannotplacehererespawn.name");
                }
                return;
            }
        } else {
            return;
        }
        if (this.areCheckpointsAround(world, x, y, z)) {
            world.func_147468_f(x, y, z);
            if (FMLCommonHandler.instance().getEffectiveSide().isClient() && player != null) {
                HUtility.addUnlocalizedChatMessage(player, "chat.hyperioncraft:cannotplaceherecheckpointsaround.name");
            }
            return;
        }
        int dir = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        world.func_72921_c(x, y, z, dir, 2);
        for (int i = 0; i < gagShift.length; ++i) {
            world.func_147465_d(x + gagShift[i][0], y + gagShift[i][1], z + gagShift[i][2], (Block)ModBlocks.gagCheckpoint, 0, 2);
            TileEntityGag tileFiller = (TileEntityGag)world.func_147438_o(x + gagShift[i][0], y + gagShift[i][1], z + gagShift[i][2]);
            if (tileFiller == null) continue;
            tileFiller.primary_x = x;
            tileFiller.primary_y = y;
            tileFiller.primary_z = z;
        }
        if (!world.field_72995_K) {
            TileEntityCheckpoint checkpoint = (TileEntityCheckpoint)world.func_147438_o(x, y, z);
            if (!world.func_72864_z(x, y, z)) {
                checkpoint.setActive(true);
            } else if (world.func_72864_z(x, y, z)) {
                checkpoint.setActive(false);
            }
        }
    }

    protected boolean areCheckpointsAround(World world, int x, int y, int z) {
        int range = ConfigHandler.checkpointRange * 2 + 1;
        for (int i = x - range; i < x + range; ++i) {
            for (int j = y - range; j < y + range; ++j) {
                for (int k = z - range; k < z + range; ++k) {
                    if (!Block.func_149680_a((Block)world.func_147439_a(i, j, k), (Block)ModBlocks.checkpoint) && !Block.func_149680_a((Block)world.func_147439_a(i, j, k), (Block)ModBlocks.fastTravel) || i == x && j == y && k == z) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return side != -1;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            TileEntityCheckpoint checkpoint = (TileEntityCheckpoint)world.func_147438_o(x, y, z);
            if (!world.func_72864_z(x, y, z)) {
                checkpoint.setActive(true);
            } else if (world.func_72864_z(x, y, z)) {
                checkpoint.setActive(false);
            }
        }
    }

    public boolean func_149696_a(World world, int x, int y, int z, int p_149696_5_, int p_149696_6_) {
        if (!world.field_72995_K) {
            TileEntityCheckpoint checkpoint = (TileEntityCheckpoint)world.func_147438_o(x, y, z);
            if (!world.func_72864_z(x, y, z)) {
                checkpoint.setActive(true);
            } else if (world.func_72864_z(x, y, z)) {
                checkpoint.setActive(false);
            }
        }
        return true;
    }
}

