/*
 * Decompiled with CFR 0.152.
 */
package co.uk.silvania.hudwidgets.client;

import co.uk.silvania.hudwidgets.HUDWidgetsConfig;
import co.uk.silvania.hudwidgets.client.GuiWidgetBase;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class GuiWidgetHotbar
extends GuiWidgetBase {
    private static final ResourceLocation guiStatsBar = new ResourceLocation("hudwidgets", "textures/gui/" + HUDWidgetsConfig.hotbarTextureStyle);
    protected static final RenderItem itemRenderer = new RenderItem();

    public GuiWidgetHotbar(Minecraft mc) {
        super(mc);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void renderHotbar(RenderGameOverlayEvent.Pre event) {
        if (HUDWidgetsConfig.hotbarEnabled) {
            double widthMultiplier = this.getResIncreaseMultiplier("x");
            double heightMultiplier = this.getResIncreaseMultiplier("y");
            int sizeX = 182;
            int sizeY = 22;
            if (!HUDWidgetsConfig.horizontalHotbar) {
                sizeX = 22;
                sizeY = 182;
            }
            if (HUDWidgetsConfig.hotbarAnchor == 0 || HUDWidgetsConfig.hotbarAnchor > 8) {
                this.configX = (int)Math.round((double)HUDWidgetsConfig.hotbarXPos * widthMultiplier);
                this.configY = (int)Math.round((double)HUDWidgetsConfig.hotbarYPos * heightMultiplier);
            } else {
                this.configX = this.calculateAnchorPointX(HUDWidgetsConfig.hotbarAnchor, sizeX);
                this.configY = this.calculateAnchorPointY(HUDWidgetsConfig.hotbarAnchor, sizeY);
            }
            int xPos = this.configX + HUDWidgetsConfig.hotbarXOffset;
            int yPos = this.configY + HUDWidgetsConfig.hotbarYOffset;
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.field_71446_o.func_110577_a(guiStatsBar);
            if (HUDWidgetsConfig.horizontalHotbar) {
                InventoryPlayer inv = this.mc.field_71439_g.field_71071_by;
                this.func_73729_b(xPos, yPos, 0, 168, sizeX, sizeY);
                this.func_73729_b(xPos - 1 + inv.field_70461_c * 20, yPos - 1, 182, 168, 24, 24);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)32826);
                RenderHelper.func_74520_c();
                for (int i = 0; i < 9; ++i) {
                    int x = xPos + i * 20 + 3;
                    int z = yPos + 3;
                    this.renderInventorySlot(i, x, z, 1.0f);
                }
            } else {
                InventoryPlayer inv = this.mc.field_71439_g.field_71071_by;
                this.func_73729_b(xPos, yPos, 234, 0, sizeX, sizeY);
                this.func_73729_b(xPos - 1, yPos - 1 + inv.field_70461_c * 20, 182, 168, 24, 24);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)32826);
                RenderHelper.func_74520_c();
                for (int i = 0; i < 9; ++i) {
                    int x = xPos + 3;
                    int z = yPos + i * 20 + 2;
                    this.renderInventorySlot(i, x, z, 1.0f);
                }
            }
            RenderHelper.func_74518_a();
            GL11.glDisable((int)32826);
        }
    }

    @Override
    public int calculateAnchorPointX(int anchor, int widgetWidth) {
        if (anchor == 1 || anchor == 4 || anchor == 6) {
            return 2;
        }
        if (anchor == 2 || anchor == 7) {
            return this.screenWidth / 2 - Math.round(widgetWidth / 2);
        }
        if (anchor == 3 || anchor == 5 || anchor == 8) {
            return this.screenWidth - widgetWidth - 2;
        }
        return 0;
    }

    @Override
    public int calculateAnchorPointY(int anchor, int widgetHeight) {
        if (anchor == 1 || anchor == 2 || anchor == 3) {
            return 2;
        }
        if (anchor == 4 || anchor == 5) {
            return this.screenHeight / 2 - Math.round(widgetHeight / 2);
        }
        if (anchor == 6 || anchor == 7 || anchor == 8) {
            return this.screenHeight - widgetHeight - 2;
        }
        return 0;
    }

    protected void renderInventorySlot(int par1, int par2, int par3, float par4) {
        ItemStack itemstack = this.mc.field_71439_g.field_71071_by.field_70462_a[par1];
        if (itemstack != null) {
            float f1 = (float)itemstack.field_77992_b - par4;
            if (f1 > 0.0f) {
                GL11.glPushMatrix();
                float f2 = 1.0f + f1 / 5.0f;
                GL11.glTranslatef((float)(par2 + 8), (float)(par3 + 12), (float)0.0f);
                GL11.glScalef((float)(1.0f / f2), (float)((f2 + 1.0f) / 2.0f), (float)1.0f);
                GL11.glTranslatef((float)(-(par2 + 8)), (float)(-(par3 + 12)), (float)0.0f);
            }
            itemRenderer.func_82406_b(this.mc.field_71466_p, this.mc.func_110434_K(), itemstack, par2, par3);
            if (f1 > 0.0f) {
                GL11.glPopMatrix();
            }
            itemRenderer.func_77021_b(this.mc.field_71466_p, this.mc.func_110434_K(), itemstack, par2, par3);
        }
    }
}

