/*
 * Decompiled with CFR 0.152.
 */
package co.uk.silvania.hudwidgets.client;

import co.uk.silvania.hudwidgets.HUDWidgetsConfig;
import co.uk.silvania.hudwidgets.client.GuiWidgetBase;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class GuiWidgetHealth
extends GuiWidgetBase {
    boolean debugMode;
    private static final ResourceLocation guiStatsBar = new ResourceLocation("hudwidgets", "textures/gui/" + HUDWidgetsConfig.healthTextureStyle);

    public GuiWidgetHealth(Minecraft mc) {
        super(mc);
        this.debugMode = this.mc.field_71474_y.field_74330_P;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderGui(RenderGameOverlayEvent.Pre event) {
        boolean enabled = true;
        if (!HUDWidgetsConfig.healthEnabled) {
            enabled = false;
        }
        if (this.mc.field_71439_g.field_71075_bZ.field_75098_d && !HUDWidgetsConfig.renderHealthCreative) {
            enabled = false;
        }
        if (this.debugMode) {
            enabled = false;
        }
        if (enabled) {
            FontRenderer font = this.mc.field_71466_p;
            int health = Math.round(this.mc.field_71439_g.func_110143_aJ());
            int maxHealth = Math.round(this.mc.field_71439_g.func_110138_aP());
            int healthAmount = Math.round(200 / maxHealth * health);
            int armourAmount = 2 * this.mc.field_71439_g.func_70658_aO();
            int oxygenAmount = Math.round(this.mc.field_71439_g.func_70086_ai() / 2);
            double widthMultiplier = this.getResIncreaseMultiplier("x");
            double heightMultiplier = this.getResIncreaseMultiplier("y");
            int sizeX = 204;
            int sizeY = 20;
            if (HUDWidgetsConfig.healthAnchor == 0 || HUDWidgetsConfig.healthAnchor > 8) {
                this.configX = (int)Math.round((double)HUDWidgetsConfig.healthXPos * widthMultiplier);
                this.configY = (int)Math.round((double)HUDWidgetsConfig.healthYPos * heightMultiplier);
            } else {
                this.configX = this.calculateAnchorPointX(HUDWidgetsConfig.healthAnchor, sizeX);
                this.configY = this.calculateAnchorPointY(HUDWidgetsConfig.healthAnchor, sizeY);
            }
            int xPos = this.configX + HUDWidgetsConfig.healthXOffset;
            int yPos = this.configY + HUDWidgetsConfig.healthYOffset;
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            this.mc.field_71446_o.func_110577_a(guiStatsBar);
            this.func_73729_b(xPos, yPos, 0, 108, sizeX, sizeY);
            this.func_73729_b(xPos + 2, yPos + 2, 0, 60, healthAmount, 16);
            this.func_73729_b(xPos, yPos, 0, 0, sizeX, sizeY);
            if (HUDWidgetsConfig.armourBarStyle == 2 && (HUDWidgetsConfig.alwaysRenderArmour || this.mc.field_71439_g.func_70658_aO() > 0)) {
                this.func_73729_b(xPos + 23, yPos + 2, 0, 190, armourAmount, 6);
            }
            if (HUDWidgetsConfig.oxygenBarStyle == 2 && this.mc.field_71439_g.func_70086_ai() < 300) {
                this.func_73729_b(xPos + 27, yPos + 2, 0, 196, oxygenAmount, 6);
                this.func_73729_b(xPos + 25, yPos + 2, 0, 210, 154, 8);
            }
            this.mc.field_71446_o.func_110577_a(hudStatIcons);
            this.func_73729_b(xPos + 2, yPos + 1, 0, 0, 18, 18);
            if (HUDWidgetsConfig.healthText) {
                font.func_78261_a("Health: " + health + "/" + maxHealth, xPos + 22, yPos + 6, HUDWidgetsConfig.healthTextColour);
            }
            GL11.glPopMatrix();
        }
    }
}

