/*
 * Decompiled with CFR 0.152.
 */
package co.uk.silvania.hudwidgets.client;

import co.uk.silvania.hudwidgets.HUDWidgetsConfig;
import co.uk.silvania.hudwidgets.client.GuiWidgetBase;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class GuiWidgetCompass
extends GuiWidgetBase {
    private static final ResourceLocation guiStatsBar = new ResourceLocation("hudwidgets", "textures/gui/" + HUDWidgetsConfig.compassTextureStyle);

    public GuiWidgetCompass(Minecraft mc) {
        super(mc);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderCompass(RenderGameOverlayEvent.Pre event) {
        boolean enabled = true;
        if (!HUDWidgetsConfig.compassEnabled) {
            enabled = false;
        }
        if (this.mc.field_71439_g.field_71075_bZ.field_75098_d && !HUDWidgetsConfig.renderCompassCreative) {
            enabled = false;
        }
        if (enabled) {
            int rotation;
            FontRenderer font = this.mc.field_71466_p;
            for (rotation = MathHelper.func_76128_c((double)this.mc.field_71439_g.func_70079_am()); rotation > 360; rotation -= 360) {
            }
            while (rotation < 0) {
                rotation += 360;
            }
            double widthMultiplier = this.getResIncreaseMultiplier("x");
            double heightMultiplier = this.getResIncreaseMultiplier("y");
            int sizeX = 36;
            int sizeY = 20;
            if (HUDWidgetsConfig.compassAnchor == 0 || HUDWidgetsConfig.compassAnchor > 8) {
                this.configX = (int)Math.round((double)HUDWidgetsConfig.compassXPos * widthMultiplier);
                this.configY = (int)Math.round((double)HUDWidgetsConfig.compassYPos * heightMultiplier);
            } else {
                this.configX = this.calculateAnchorPointX(HUDWidgetsConfig.compassAnchor, sizeX);
                this.configY = this.calculateAnchorPointY(HUDWidgetsConfig.compassAnchor, sizeY);
            }
            int xPos = this.configX + HUDWidgetsConfig.compassXOffset;
            int yPos = this.configY + HUDWidgetsConfig.compassYOffset;
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            this.mc.field_71446_o.func_110577_a(guiStatsBar);
            if (HUDWidgetsConfig.textCompass) {
                String n = "N";
                String e = "E";
                String s = "S";
                String w = "W";
                String p = " .:!!:. ";
                String compass = "!:. " + s + p + w + p + n + p + e + p + s + p;
                int stringLength = Math.round(rotation / 10);
                String compassShort = compass.substring(stringLength, stringLength + 9);
                this.func_73729_b(xPos, yPos, 158, 188, sizeX, sizeY);
                font.func_78276_b(compassShort, xPos + 6, yPos + 6, 0xFFFFFF);
            }
            GL11.glPopMatrix();
        }
    }
}

