/*
 * Decompiled with CFR 0.152.
 */
package co.uk.silvania.hudwidgets.client;

import co.uk.silvania.hudwidgets.HUDWidgetsConfig;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class GuiWidgetBase
extends Gui {
    public Minecraft mc;
    public static int defaultWidth;
    public static int defaultHeight;
    public int screenWidth;
    public int screenHeight;
    public int configX = 0;
    public int configY = 0;
    public static HUDWidgetsConfig config;
    public static final ResourceLocation hudStatIcons;

    public GuiWidgetBase(Minecraft mc) {
        this.mc = mc;
    }

    public static void defaultResolution() {
        ScaledResolution res = new ScaledResolution(Minecraft.func_71410_x().field_71474_y, Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        defaultWidth = res.func_78326_a();
        defaultHeight = res.func_78328_b();
    }

    public double calculateWorldMinutes(double ticks) {
        for (int i = 0; i < 61; ++i) {
            double minute = Math.round(16.9 * (double)i);
            if (!(minute >= ticks)) continue;
            return i;
        }
        return 0.0;
    }

    public double getResIncreaseMultiplier(String str) {
        ScaledResolution res = new ScaledResolution(this.mc.field_71474_y, this.mc.field_71443_c, this.mc.field_71440_d);
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        int widthDiff = width - defaultWidth;
        int heightDiff = height - defaultHeight;
        double widthMult = Math.round((double)widthDiff / (double)defaultWidth * 100.0 * 100.0) / 100L;
        double widthMultiplier = widthMult / 100.0 + 1.0;
        double heightMult = Math.round((double)heightDiff / (double)defaultHeight * 100.0 * 100.0) / 100L;
        double heightMultiplier = heightMult / 100.0 + 1.0;
        if (str.equalsIgnoreCase("x")) {
            return widthMultiplier;
        }
        if (str.equalsIgnoreCase("y")) {
            return heightMultiplier;
        }
        return 0.0;
    }

    public int calculateAnchorPointX(int anchor, int widgetWidth) {
        if (anchor == 1 || anchor == 4 || anchor == 6) {
            return 2;
        }
        if (anchor == 2 || anchor == 7) {
            return this.screenWidth - Math.round(widgetWidth / 2);
        }
        if (anchor == 3 || anchor == 5 || anchor == 8) {
            return this.screenWidth * 2 - widgetWidth - 2;
        }
        return 0;
    }

    public int calculateAnchorPointY(int anchor, int widgetHeight) {
        if (anchor == 1 || anchor == 2 || anchor == 3) {
            return 2;
        }
        if (anchor == 4 || anchor == 5) {
            return this.screenHeight - Math.round(widgetHeight / 2);
        }
        if (anchor == 6 || anchor == 7 || anchor == 8) {
            return this.screenHeight * 2 - widgetHeight - 2;
        }
        return 0;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void cancelRenders(RenderGameOverlayEvent.Pre event) {
        ScaledResolution res = new ScaledResolution(this.mc.field_71474_y, this.mc.field_71443_c, this.mc.field_71440_d);
        this.screenWidth = res.func_78326_a();
        this.screenHeight = res.func_78328_b();
        if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.BOSSHEALTH)) {
            event.setCanceled(true);
        }
        if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.ARMOR)) {
            event.setCanceled(true);
        }
        if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.HEALTH)) {
            event.setCanceled(true);
        }
        if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.FOOD)) {
            event.setCanceled(true);
        }
        if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.AIR)) {
            event.setCanceled(true);
        }
        if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR)) {
            event.setCanceled(false);
        }
        if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.EXPERIENCE)) {
            event.setCanceled(true);
        }
        if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.HEALTHMOUNT)) {
            event.setCanceled(true);
        }
        if (event.type.equals((Object)RenderGameOverlayEvent.ElementType.JUMPBAR)) {
            event.setCanceled(true);
        }
    }

    static {
        hudStatIcons = new ResourceLocation("hudwidgets", "textures/gui/staticons.png");
    }
}

