/*
 * Decompiled with CFR 0.152.
 */
package co.uk.silvania.hudwidgets.client;

import co.uk.silvania.hudwidgets.HUDWidgetsConfig;
import co.uk.silvania.hudwidgets.client.GuiWidgetBase;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class GuiWidgetArmour
extends GuiWidgetBase {
    private Minecraft mc;
    private static final ResourceLocation guiStatsBar = new ResourceLocation("hudwidgets", "textures/gui/" + HUDWidgetsConfig.armourTextureStyle);

    public GuiWidgetArmour(Minecraft mc) {
        super(mc);
        this.mc = mc;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderArmourWidget(RenderGameOverlayEvent.Pre event) {
        boolean enabled = true;
        int armour = this.mc.field_71439_g.func_70658_aO() * 10;
        if (!HUDWidgetsConfig.armourEnabled || HUDWidgetsConfig.armourBarStyle >= 2) {
            enabled = false;
        }
        if (this.mc.field_71439_g.field_71075_bZ.field_75098_d && !HUDWidgetsConfig.renderArmourCreative) {
            enabled = false;
        }
        if (armour == 0 && !HUDWidgetsConfig.alwaysRenderArmour) {
            enabled = false;
        }
        if (enabled) {
            FontRenderer font = this.mc.field_71466_p;
            double widthMultiplier = this.getResIncreaseMultiplier("x");
            double heightMultiplier = this.getResIncreaseMultiplier("y");
            int sizeX = 204;
            int sizeY = 20;
            if (HUDWidgetsConfig.armourBarStyle == 1) {
                sizeX = 79;
                armour = Math.round(armour / 8 * 3);
            }
            if (HUDWidgetsConfig.armourAnchor == 0 || HUDWidgetsConfig.armourAnchor > 8) {
                this.configX = (int)Math.round((double)HUDWidgetsConfig.armourXPos * widthMultiplier);
                this.configY = (int)Math.round((double)HUDWidgetsConfig.armourYPos * heightMultiplier);
            } else {
                this.configX = this.calculateAnchorPointX(HUDWidgetsConfig.armourAnchor, sizeX);
                this.configY = this.calculateAnchorPointY(HUDWidgetsConfig.armourAnchor, sizeY);
            }
            int xPos = this.configX + HUDWidgetsConfig.armourXOffset;
            int yPos = this.configY + HUDWidgetsConfig.armourYOffset;
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            this.mc.field_71446_o.func_110577_a(guiStatsBar);
            if (HUDWidgetsConfig.armourBarStyle == 1) {
                this.func_73729_b(xPos, yPos, 79, 188, sizeX, sizeY);
                this.func_73729_b(xPos + 2, yPos + 2, 79, 168, armour, 16);
                this.func_73729_b(xPos, yPos, 79, 148, sizeX, sizeY);
            } else {
                this.func_73729_b(xPos, yPos, 0, 128, sizeX, sizeY);
                this.func_73729_b(xPos + 2, yPos + 2, 0, 76, armour, 16);
                this.func_73729_b(xPos, yPos, 0, 20, sizeX, sizeY);
            }
            this.mc.field_71446_o.func_110577_a(hudStatIcons);
            this.func_73729_b(xPos + 2, yPos + 1, 36, 0, 18, 18);
            if (HUDWidgetsConfig.armourText) {
                String amr = "";
                if (HUDWidgetsConfig.armourBarStyle != 1) {
                    amr = "Armour: ";
                }
                font.func_78261_a(amr + armour + "/" + 75, xPos + 22, yPos + 6, HUDWidgetsConfig.armourTextColour);
            }
            GL11.glPopMatrix();
        }
    }
}

