/*
 * Decompiled with CFR 0.152.
 */
package co.uk.silvania.hudwidgets.client;

import co.uk.silvania.hudwidgets.HUDWidgetsConfig;
import co.uk.silvania.hudwidgets.client.GuiWidgetBase;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class GuiWidgetTime
extends GuiWidgetBase {
    private static final ResourceLocation guiStatsBar = new ResourceLocation("hudwidgets", "textures/gui/" + HUDWidgetsConfig.timeTextureStyle);

    public GuiWidgetTime(Minecraft mc) {
        super(mc);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderGamemode(RenderGameOverlayEvent.Pre event) {
        boolean enabled = true;
        if (!HUDWidgetsConfig.timeEnabled) {
            enabled = false;
        }
        if (!HUDWidgetsConfig.renderTimeCreative && this.mc.field_71439_g.field_71075_bZ.field_75098_d) {
            enabled = false;
        }
        if (enabled) {
            double worldTime;
            FontRenderer font = this.mc.field_71466_p;
            int hour = 0;
            int minute = 0;
            double storedTime = worldTime;
            for (worldTime = (double)this.mc.field_71441_e.func_72912_H().func_76073_f(); worldTime > 24000.0; worldTime -= 24000.0) {
            }
            while (worldTime > 1000.0) {
                ++hour;
                worldTime -= 1000.0;
            }
            if (storedTime >= 24000.0) {
                storedTime -= 24000.0;
            }
            hour = hour <= 17 ? (hour += 6) : (hour -= 18);
            String time = "";
            if (HUDWidgetsConfig.timeStyle == 0) {
                if (hour == 0) {
                    hour = 12;
                }
                if (hour > 12) {
                    hour -= 12;
                }
                time = worldTime < 6000.0 || worldTime > 18000.0 ? " AM" : " PM";
            }
            if ((minute = (int)this.calculateWorldMinutes(worldTime)) >= 60) {
                minute = 0;
            }
            if (minute <= 0) {
                minute = 0;
            }
            String hours = "" + hour;
            String minutes = "" + minute;
            String divider = "";
            if (minutes.length() <= 1) {
                minutes = "0" + (minute - 1);
            }
            if (hours.length() <= 1) {
                hours = "0" + hour;
            }
            divider = minute % 2 == 0 ? ":" : " ";
            double widthMultiplier = this.getResIncreaseMultiplier("x");
            double heightMultiplier = this.getResIncreaseMultiplier("y");
            int sizeX = 36;
            int sizeY = 20;
            if (HUDWidgetsConfig.timeStyle == 0) {
                sizeX = 36;
                sizeY = 28;
            } else if (HUDWidgetsConfig.timeStyle == 2) {
                sizeX = 36;
                sizeY = 36;
            }
            if (HUDWidgetsConfig.timeAnchor == 0 || HUDWidgetsConfig.timeAnchor > 8) {
                this.configX = (int)Math.round((double)HUDWidgetsConfig.timeXPos * widthMultiplier);
                this.configY = (int)Math.round((double)HUDWidgetsConfig.timeYPos * heightMultiplier);
            } else {
                this.configX = this.calculateAnchorPointX(HUDWidgetsConfig.timeAnchor, sizeX);
                this.configY = this.calculateAnchorPointY(HUDWidgetsConfig.timeAnchor, sizeY);
            }
            int xPos = this.configX + HUDWidgetsConfig.timeXOffset;
            int yPos = this.configY + HUDWidgetsConfig.timeYOffset;
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            this.mc.field_71446_o.func_110577_a(guiStatsBar);
            if (HUDWidgetsConfig.timeStyle == 0) {
                this.func_73729_b(xPos, yPos, 194, 224, sizeX, sizeY);
            } else if (HUDWidgetsConfig.timeStyle == 1) {
                this.func_73729_b(xPos, yPos, 158, 208, sizeX, sizeY);
            } else {
                this.func_73729_b(xPos, yPos, 122, 208, sizeX, sizeY);
            }
            font.func_78276_b(hours, xPos + 5, yPos + 6, HUDWidgetsConfig.timeTextColour);
            font.func_78276_b(divider, xPos + 17, yPos + 6, HUDWidgetsConfig.timeTextColour);
            font.func_78276_b(minutes, xPos + 20, yPos + 6, HUDWidgetsConfig.timeTextColour);
            font.func_78276_b(time, xPos + 9, yPos + 15, HUDWidgetsConfig.timeTextColour);
            GL11.glPopMatrix();
        }
    }
}

