/*
 * Decompiled with CFR 0.152.
 */
package co.uk.silvania.hudwidgets.client;

import co.uk.silvania.hudwidgets.HUDWidgetsConfig;
import co.uk.silvania.hudwidgets.client.GuiWidgetBase;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class GuiWidgetHorseHealth
extends GuiWidgetBase {
    private static final ResourceLocation guiStatsBar = new ResourceLocation("hudwidgets", "textures/gui/" + HUDWidgetsConfig.horseHealthTextureStyle);

    public GuiWidgetHorseHealth(Minecraft mc) {
        super(mc);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderGui(RenderGameOverlayEvent.Pre event) {
        boolean enabled = true;
        if (!HUDWidgetsConfig.horseHealthEnabled) {
            enabled = false;
        }
        if (!(this.mc.field_71439_g.field_70154_o instanceof EntityLivingBase)) {
            enabled = false;
        }
        if (this.mc.field_71439_g.field_71075_bZ.field_75098_d && !HUDWidgetsConfig.renderHorseHealthCreative) {
            enabled = false;
        }
        if ((this.mc.field_71439_g.func_70115_ae() || HUDWidgetsConfig.alwaysRenderHorseHealth) && enabled) {
            Entity entity = this.mc.field_71439_g.field_70154_o;
            EntityLivingBase mount = (EntityLivingBase)entity;
            FontRenderer font = this.mc.field_71466_p;
            String mountName = "" + this.mc.field_71439_g.field_70154_o.func_145782_y();
            float mountHealth = mount.func_110143_aJ();
            float mountMaxHealth = mount.func_110138_aP();
            int healthAmount = Math.round(200.0f / mountMaxHealth * mountHealth);
            double widthMultiplier = this.getResIncreaseMultiplier("x");
            double heightMultiplier = this.getResIncreaseMultiplier("y");
            int sizeX = 204;
            int sizeY = 20;
            if (HUDWidgetsConfig.horseHealthAnchor == 0 || HUDWidgetsConfig.horseHealthAnchor > 8) {
                this.configX = (int)Math.round((double)HUDWidgetsConfig.horseHealthXPos * widthMultiplier);
                this.configY = (int)Math.round((double)HUDWidgetsConfig.horseHealthYPos * heightMultiplier);
            } else {
                this.configX = this.calculateAnchorPointX(HUDWidgetsConfig.horseHealthAnchor, sizeX);
                this.configY = this.calculateAnchorPointY(HUDWidgetsConfig.horseHealthAnchor, sizeY);
            }
            int xPos = this.configX + HUDWidgetsConfig.horseHealthXOffset;
            int yPos = this.configY + HUDWidgetsConfig.horseHealthYOffset;
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            this.mc.field_71446_o.func_110577_a(guiStatsBar);
            this.func_73729_b(xPos, yPos, 0, 108, sizeX, sizeY);
            this.func_73729_b(xPos + 2, yPos + 2, 0, 60, healthAmount, 16);
            this.func_73729_b(xPos, yPos, 0, 0, sizeX, sizeY);
            this.mc.field_71446_o.func_110577_a(hudStatIcons);
            this.func_73729_b(xPos + 2, yPos + 1, 0, 18, 18, 18);
            if (HUDWidgetsConfig.textHorseHealth) {
                font.func_78261_a(mountName + "'s Health: " + (int)mountHealth + "/" + (int)mountMaxHealth, xPos + 22, yPos + 6, 0xFFFFFF);
            }
            GL11.glPopMatrix();
        }
    }
}

