/*
 * Decompiled with CFR 0.152.
 */
package co.uk.silvania.hudwidgets.client;

import co.uk.silvania.hudwidgets.HUDWidgetsConfig;
import co.uk.silvania.hudwidgets.client.GuiWidgetBase;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class GuiWidgetGamemode
extends GuiWidgetBase {
    private static final ResourceLocation guiStatsBar = new ResourceLocation("hudwidgets", "textures/gui/" + HUDWidgetsConfig.gamemodeTextureStyle);

    public GuiWidgetGamemode(Minecraft mc) {
        super(mc);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderGamemode(RenderGameOverlayEvent.Pre event) {
        boolean enabled = true;
        if (!HUDWidgetsConfig.gamemodeEnabled) {
            enabled = false;
        }
        if (enabled) {
            FontRenderer font = this.mc.field_71466_p;
            String gameMode = "Survival";
            int textColour = HUDWidgetsConfig.gamemodeSTextColour;
            if (this.mc.field_71439_g.field_71075_bZ.field_75098_d) {
                gameMode = "Creative";
                textColour = HUDWidgetsConfig.gamemodeCTextColour;
            }
            if (!this.mc.field_71439_g.field_71075_bZ.field_75099_e) {
                gameMode = "Adventure";
                textColour = HUDWidgetsConfig.gamemodeATextColour;
            }
            double widthMultiplier = this.getResIncreaseMultiplier("x");
            double heightMultiplier = this.getResIncreaseMultiplier("y");
            int sizeX = 79;
            int sizeY = 20;
            if (HUDWidgetsConfig.gamemodeRelativeResize) {
                sizeX = 6 + gameMode.length() * 6;
                if (gameMode.equals("Survival")) {
                    sizeX -= 3;
                }
            }
            if (HUDWidgetsConfig.gamemodeAnchor == 0 || HUDWidgetsConfig.gamemodeAnchor > 8) {
                this.configX = (int)Math.round((double)HUDWidgetsConfig.gamemodeXPos * widthMultiplier);
                this.configY = (int)Math.round((double)HUDWidgetsConfig.gamemodeYPos * heightMultiplier);
            } else {
                this.configX = this.calculateAnchorPointX(HUDWidgetsConfig.gamemodeAnchor, sizeX) - 1;
                this.configY = this.calculateAnchorPointY(HUDWidgetsConfig.gamemodeAnchor, sizeY);
            }
            int xPos = this.configX + HUDWidgetsConfig.gamemodeXOffset;
            int yPos = this.configY + HUDWidgetsConfig.gamemodeYOffset;
            int xTextPos = xPos;
            int yTextPos = yPos;
            if (HUDWidgetsConfig.gamemodeRelativeResize) {
                xPos = 79 - sizeX + xPos;
            }
            if (HUDWidgetsConfig.gamemodeTextAlignRight && !HUDWidgetsConfig.gamemodeRelativeResize) {
                if (gameMode.equalsIgnoreCase("Survival")) {
                    xTextPos = xPos + 27;
                } else if (gameMode.equalsIgnoreCase("Creative")) {
                    xTextPos = xPos + 26;
                } else if (gameMode.equalsIgnoreCase("Adventure")) {
                    xTextPos = xPos + 16;
                }
            }
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            this.mc.field_71446_o.func_110577_a(guiStatsBar);
            if (HUDWidgetsConfig.gamemodeRelativeResize) {
                this.func_73729_b(xPos + 1, yPos, 158, 168, sizeX - 3, sizeY);
                this.func_73729_b(xPos + sizeX - 2, yPos, 235, 168, 2, 20);
            } else {
                this.func_73729_b(xPos + 1, yPos, 158, 168, sizeX, sizeY);
            }
            font.func_78276_b(gameMode, xTextPos + 6, yTextPos + 6, textColour);
            GL11.glPopMatrix();
        }
    }
}

