/*
 * Decompiled with CFR 0.152.
 */
package build.world;

import CoroUtil.util.CoroUtilBlock;
import build.ITileEntityCustomGenData;
import build.SchematicData;
import build.world.Build;
import build.world.BuildJob;
import cpw.mods.fml.common.FMLCommonHandler;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class BuildManager {
    public List<BuildJob> activeBuilds;
    public List<String> buildNames;
    public int nextBuildID = 0;
    public int build_rate = 100000;
    public int build_rand = 20;
    public Block placeholderID = Blocks.field_150348_b;

    public BuildManager() {
        this.activeBuilds = new LinkedList<BuildJob>();
        this.buildNames = new LinkedList<String>();
    }

    public void updateTick() {
        for (int i = 0; i < this.activeBuilds.size(); ++i) {
            BuildJob bj = this.activeBuilds.get(i);
            if (bj == null) continue;
            if (bj.build_active) {
                bj.updateTick();
                this.updateBuildProgress(bj);
                continue;
            }
            this.activeBuilds.remove(bj);
        }
    }

    public boolean isBuildActive(int id) {
        for (int i = 0; i < this.activeBuilds.size(); ++i) {
            BuildJob bj = this.activeBuilds.get(i);
            if (bj.id != id) continue;
            return true;
        }
        return false;
    }

    public boolean isBuildActive(Build build) {
        for (int i = 0; i < this.activeBuilds.size(); ++i) {
            BuildJob bj = this.activeBuilds.get(i);
            if (bj.build != build) continue;
            return true;
        }
        return false;
    }

    public int newBuild(int x, int y, int z, String name) {
        int buildID = this.nextBuildID++;
        BuildJob newBuild = new BuildJob(buildID, x, y, z, name);
        this.addBuild(newBuild);
        return buildID;
    }

    public int newBuild(Build build) {
        int buildID = this.nextBuildID++;
        BuildJob newBuild = new BuildJob(buildID, build);
        this.addBuild(newBuild);
        return buildID;
    }

    public void addBuild(BuildJob buildJob) {
        this.activeBuilds.add(buildJob);
        buildJob.buildStart();
    }

    public void addBuild(BuildJob build, int x, int y, int z) {
        this.activeBuilds.add(build);
        build.buildStart();
    }

    public void updateBuildProgress(BuildJob buildJob) {
        boolean replaceAir;
        Build build = buildJob.build;
        ++buildJob.build_currentTick;
        WorldServer worldRef = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(buildJob.build.dim);
        if (buildJob.timeout > 0) {
            --buildJob.timeout;
            Build b = buildJob.build;
            worldRef.func_147458_c(buildJob.build_startX, buildJob.build_startY, buildJob.build_startZ, buildJob.build_startX + b.map_sizeX, buildJob.build_startY + b.map_sizeY, buildJob.build_startZ + b.map_sizeZ);
            return;
        }
        this.build_rate = 100000;
        this.build_rate = 25000;
        this.build_rate = 1000;
        this.build_rate = buildJob.build_rate;
        boolean bl = replaceAir = !buildJob.useFirstPass;
        if (buildJob.neverPlaceAir) {
            replaceAir = false;
        }
        Block id = null;
        buildJob.curLayerCountMax = build.map_sizeX * build.map_sizeZ;
        buildJob.doRandomBuild = false;
        try {
            if (buildJob.doRandomBuild) {
                if (worldRef.field_73012_v.nextInt(this.build_rand) != 0) {
                    return;
                }
                boolean first = true;
                for (int tryCount = 0; (first || CoroUtilBlock.isAir(id)) && tryCount < 300; ++tryCount) {
                    first = false;
                    buildJob.build_loopTickX = worldRef.field_73012_v.nextInt(build.map_sizeX);
                    buildJob.build_loopTickZ = worldRef.field_73012_v.nextInt(build.map_sizeZ);
                    if (!((float)buildJob.curLayerCount / (float)buildJob.curLayerCountMax > 0.9f)) continue;
                    buildJob.doRandomBuild = false;
                    buildJob.build_loopTickX = 0;
                    buildJob.build_loopTickZ = 0;
                    return;
                }
            } else {
                for (int loopCount = 0; loopCount < this.build_rate; ++loopCount) {
                    if (buildJob.build_loopTickX >= build.map_sizeX) {
                        buildJob.build_loopTickX = 0;
                        ++buildJob.build_loopTickZ;
                    }
                    if (buildJob.build_loopTickZ >= build.map_sizeZ) {
                        buildJob.build_loopTickZ = 0;
                        ++buildJob.build_loopTickY;
                        buildJob.curLayerCount = 0;
                    }
                    if (buildJob.build_loopTickY >= build.map_sizeY) {
                        if (buildJob.pass == 2) {
                            this.buildComplete(buildJob);
                            buildJob.buildComplete();
                            if (buildJob.customGenCallback != null) {
                                buildJob.customGenCallback.genPassPre((World)worldRef, buildJob, -1);
                            }
                        } else {
                            ++buildJob.pass;
                            buildJob.build_loopTickX = 0;
                            buildJob.build_loopTickZ = 0;
                            buildJob.build_loopTickY = 0;
                            buildJob.timeout = 5;
                            if (buildJob.customGenCallback != null) {
                                buildJob.customGenCallback.genPassPre((World)worldRef, buildJob, buildJob.pass);
                            }
                            if (buildJob.pass == 1) {
                                // empty if block
                            }
                        }
                        return;
                    }
                    ++buildJob.curTick;
                    if (buildJob.pass == 0) {
                        Block checkCoord;
                        int xx = buildJob.build_startX + buildJob.build_loopTickX;
                        int yy = buildJob.build_startY + buildJob.build_loopTickY;
                        int zz = buildJob.build_startZ + buildJob.build_loopTickZ;
                        id = build.build_blockIDArr[buildJob.build_loopTickX][buildJob.build_loopTickY][buildJob.build_loopTickZ];
                        boolean skipGen = false;
                        ChunkCoordinates coords = new ChunkCoordinates(xx, yy, zz);
                        if (buildJob.useRotationBuild) {
                            coords = buildJob.build.backwardsCompatibleOldRotate ? BuildManager.rotate(coords, buildJob.direction, Vec3.func_72443_a((double)buildJob.build_startX, (double)buildJob.build_startY, (double)buildJob.build_startZ), Vec3.func_72443_a((double)build.map_sizeX, (double)build.map_sizeY, (double)build.map_sizeZ)) : BuildManager.rotateNew(coords, buildJob.direction, Vec3.func_72443_a((double)buildJob.build_startX, (double)buildJob.build_startY, (double)buildJob.build_startZ), Vec3.func_72443_a((double)build.map_sizeX, (double)build.map_sizeY, (double)build.map_sizeZ));
                        } else {
                            boolean centerBuild = true;
                            if (centerBuild) {
                                coords.field_71574_a -= MathHelper.func_76128_c((double)((double)build.map_sizeX / 2.0));
                                coords.field_71573_c -= MathHelper.func_76128_c((double)((double)build.map_sizeZ / 2.0));
                            }
                        }
                        if (buildJob.blockIDsNoBuildOver.size() > 0 && buildJob.blockIDsNoBuildOver.contains(checkCoord = worldRef.func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c))) {
                            skipGen = true;
                        }
                        if (!skipGen) {
                            worldRef.func_147465_d(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, Blocks.field_150350_a, 0, 2);
                        }
                    } else if (!buildJob.build_blockPlaced[buildJob.build_loopTickX][buildJob.build_loopTickY][buildJob.build_loopTickZ]) {
                        id = build.build_blockIDArr[buildJob.build_loopTickX][buildJob.build_loopTickY][buildJob.build_loopTickZ];
                        int meta = build.build_blockMetaArr[buildJob.build_loopTickX][buildJob.build_loopTickY][buildJob.build_loopTickZ];
                        int xx = buildJob.build_startX + buildJob.build_loopTickX;
                        int yy = buildJob.build_startY + buildJob.build_loopTickY;
                        int zz = buildJob.build_startZ + buildJob.build_loopTickZ;
                        boolean skip = false;
                        if (buildJob.pass == 1 && buildJob.blockIDsSkipFirstPass.contains(id)) {
                            skip = true;
                        }
                        if (!(skip || !replaceAir && CoroUtilBlock.isAir(id))) {
                            Block checkCoord;
                            boolean skipGen;
                            ChunkCoordinates coords = new ChunkCoordinates(xx, yy, zz);
                            if (buildJob.useRotationBuild) {
                                coords = buildJob.build.backwardsCompatibleOldRotate ? BuildManager.rotate(coords, buildJob.direction, Vec3.func_72443_a((double)buildJob.build_startX, (double)buildJob.build_startY, (double)buildJob.build_startZ), Vec3.func_72443_a((double)build.map_sizeX, (double)build.map_sizeY, (double)build.map_sizeZ)) : BuildManager.rotateNew(coords, buildJob.direction, Vec3.func_72443_a((double)buildJob.build_startX, (double)buildJob.build_startY, (double)buildJob.build_startZ), Vec3.func_72443_a((double)build.map_sizeX, (double)build.map_sizeY, (double)build.map_sizeZ));
                                int tryMeta = this.rotateMeta((World)worldRef, coords, buildJob.rotation, id, meta);
                                if (tryMeta != -1) {
                                    meta = tryMeta;
                                }
                            } else {
                                boolean centerBuild = true;
                                if (centerBuild) {
                                    coords.field_71574_a -= MathHelper.func_76128_c((double)((double)build.map_sizeX / 2.0));
                                    coords.field_71573_c -= MathHelper.func_76128_c((double)((double)build.map_sizeZ / 2.0));
                                }
                            }
                            if (id != null || CoroUtilBlock.isAir(id)) {
                                skipGen = false;
                                if (buildJob.blockIDsNoBuildOver.size() > 0 && buildJob.blockIDsNoBuildOver.contains(checkCoord = worldRef.func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c))) {
                                    skipGen = true;
                                }
                                if (!skipGen) {
                                    worldRef.func_147465_d(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, id, meta, 2);
                                }
                            } else {
                                System.out.println("BUILDMOD SEVERE: schematic contains non existant blockID: " + id + ", replacing with blockID: " + this.placeholderID);
                                skipGen = false;
                                if (buildJob.blockIDsNoBuildOver.size() > 0 && buildJob.blockIDsNoBuildOver.contains(checkCoord = worldRef.func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c))) {
                                    skipGen = true;
                                }
                                if (!skipGen) {
                                    worldRef.func_147465_d(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, this.placeholderID, 0, 2);
                                }
                            }
                            buildJob.build_blockPlaced[buildJob.build_loopTickX][buildJob.build_loopTickY][buildJob.build_loopTickZ] = true;
                            ++buildJob.curLayerCount;
                        } else {
                            --loopCount;
                        }
                    }
                    ++buildJob.build_loopTickX;
                }
            }
        }
        catch (Exception ex) {
            buildJob.build_active = false;
            ex.printStackTrace();
        }
    }

    public static void rotateSet(BuildJob parBuildJob, ChunkCoordinates coords, Block id, int meta) {
        coords = BuildManager.rotate(coords, parBuildJob.direction, Vec3.func_72443_a((double)parBuildJob.build_startX, (double)parBuildJob.build_startY, (double)parBuildJob.build_startZ), Vec3.func_72443_a((double)parBuildJob.build.map_sizeX, (double)parBuildJob.build.map_sizeY, (double)parBuildJob.build.map_sizeZ));
        WorldServer world = DimensionManager.getWorld((int)parBuildJob.build.dim);
        if (world != null) {
            world.func_147465_d(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, id, meta, 2);
        }
    }

    public static ChunkCoordinates rotate(ChunkCoordinates coords, int direction, Vec3 start, Vec3 size) {
        double rotation = direction * 90 + 180;
        double centerX = start.field_72450_a + size.field_72450_a / 2.0;
        double centerZ = start.field_72449_c + size.field_72449_c / 2.0;
        double vecX = (double)coords.field_71574_a - centerX + 0.05;
        double vecZ = (double)coords.field_71573_c - centerZ + 0.05;
        double distToCenter = Math.sqrt(vecX * vecX + vecZ * vecZ);
        double rotYaw = (double)((float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI)) - rotation;
        double newX = start.field_72450_a + Math.cos(rotYaw * 0.017453) * distToCenter;
        double newZ = start.field_72449_c + Math.sin(rotYaw * 0.017453) * distToCenter;
        if (direction == 1) {
            newZ += 1.0;
        } else if (direction == 2) {
            newX += 1.0;
            newZ += 1.0;
        } else if (direction == 3) {
            newX += 1.0;
        }
        return new ChunkCoordinates((int)Math.floor(newX), coords.field_71572_b, (int)Math.floor(newZ));
    }

    public static ChunkCoordinates rotateNew(ChunkCoordinates coords, int direction, Vec3 start, Vec3 size) {
        double rotation = (double)direction * Math.PI / 2.0;
        double centerX = start.field_72450_a + size.field_72450_a / 2.0;
        double centerZ = start.field_72449_c + size.field_72449_c / 2.0;
        double vecX = (double)coords.field_71574_a + 0.5 - centerX;
        double vecZ = (double)coords.field_71573_c + 0.5 - centerZ;
        Vec3 vec = Vec3.func_72443_a((double)vecX, (double)0.0, (double)vecZ);
        vec.func_72442_b((float)rotation);
        return new ChunkCoordinates((int)Math.floor(start.field_72450_a + vec.field_72450_a), coords.field_71572_b, (int)Math.floor(start.field_72449_c + vec.field_72449_c));
    }

    public int rotateMeta(World par1World, ChunkCoordinates coords, double rotation, Block id, int meta) {
        int dir = MathHelper.func_76128_c((double)(rotation * 4.0 / 360.0 + 0.5)) & 3;
        dir = (int)rotation / 90 & 3;
        Block block = id;
        if (block instanceof BlockStairs) {
            int rotateMeta = meta & 4;
            System.out.println("rotation: " + rotation + ", dir: " + dir + ", meta: " + meta + ", rotateMeta: " + rotateMeta);
            int fMeta = -1;
            if (dir != 0) {
                if (dir == 1) {
                    if (meta == 0) {
                        fMeta = 3;
                    } else if (meta == 1) {
                        fMeta = 2;
                    } else if (meta == 2) {
                        fMeta = 0;
                    } else if (meta == 3) {
                        fMeta = 1;
                    }
                } else if (dir == 2) {
                    if (meta == 0) {
                        fMeta = 1;
                    } else if (meta == 1) {
                        fMeta = 0;
                    } else if (meta == 2) {
                        fMeta = 3;
                    } else if (meta == 3) {
                        fMeta = 2;
                    }
                } else if (dir == 3) {
                    if (meta == 0) {
                        fMeta = 2;
                    } else if (meta == 1) {
                        fMeta = 3;
                    } else if (meta == 2) {
                        fMeta = 1;
                    } else if (meta == 3) {
                        fMeta = 0;
                    }
                }
            }
            return fMeta | rotateMeta;
        }
        return -1;
    }

    public void buildComplete(BuildJob buildJob) {
        this.spawnLevelEntities(buildJob);
    }

    public void spawnLevelEntities(BuildJob buildJob) {
        Build build = buildJob.build;
        WorldServer worldRef = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(build.dim);
        List ents = worldRef.field_72996_f;
        for (int i = 0; i < ents.size(); ++i) {
            Entity ent = (Entity)ents.get(i);
            if (!(ent instanceof EntityItem)) continue;
            ent.func_70106_y();
        }
        if (build.entities != null) {
            for (int var17 = 0; var17 < build.entities.func_74745_c(); ++var17) {
                NBTTagCompound var16 = build.entities.func_150305_b(var17);
                Entity var18 = EntityList.func_75615_a((NBTTagCompound)var16, (World)worldRef);
            }
        }
        if (build.tileEntities != null) {
            for (int var21 = 0; var21 < build.tileEntities.func_74745_c(); ++var21) {
                NBTTagCompound nbt;
                NBTTagCompound var20 = build.tileEntities.func_150305_b(var21);
                TileEntity var13 = worldRef.func_147438_o(build.map_coord_minX + var20.func_74762_e("x"), buildJob.build_startY + var20.func_74762_e("y"), build.map_coord_minZ + var20.func_74762_e("z"));
                if (var13 instanceof SchematicData) {
                    ((SchematicData)var13).readFromNBT(var20, build);
                } else if (var13 != null) {
                    var13.func_145839_a(var20);
                }
                if (buildJob.customGenCallback != null && (nbt = buildJob.customGenCallback.getInitNBTTileEntity()) != null && var13 instanceof ITileEntityCustomGenData) {
                    ((ITileEntityCustomGenData)var13).initWithNBT(nbt);
                }
                if (var13 == null) continue;
                var13.field_145851_c = build.map_coord_minX + var13.field_145851_c;
                var13.field_145848_d = buildJob.build_startY + var13.field_145848_d;
                var13.field_145849_e = build.map_coord_minZ + var13.field_145849_e;
                try {
                    Packet packet = var13.func_145844_m();
                    if (packet == null) continue;
                    MinecraftServer.func_71276_C().func_71203_ab().func_148540_a(packet);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

