/*
 * Decompiled with CFR 0.152.
 */
package build.world;

import CoroUtil.util.CoroUtilBlock;
import build.SchematicData;
import cpw.mods.fml.common.FMLCommonHandler;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class Build {
    public static int blockIDHighestVanilla = 158;
    public String file = "";
    public NBTTagCompound levelData = null;
    public NBTTagList tileEntities;
    public NBTTagList entities;
    public Block[][][] build_blockIDArr;
    public int[][][] build_blockMetaArr;
    public HashMap<Integer, Block> blockMappingInternalIDToBlock = new HashMap();
    public int map_sizeX = 0;
    public int map_sizeY = 0;
    public int map_sizeZ = 0;
    public int map_coord_minX = 0;
    public int map_coord_minY = 0;
    public int map_coord_minZ = 0;
    public int map_surfaceOffset = 0;
    public int dim = 0;
    public boolean newFormat = true;
    public String version = "1.0";
    public boolean backwardsCompatibleOldRotate = false;

    public Build(int x, int y, int z, String parFile, boolean noLoad) {
        this.file = parFile;
        this.map_coord_minX = x;
        this.map_coord_minY = y;
        this.map_coord_minZ = z;
        if (!noLoad) {
            this.readNBT(this.file);
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getSaveVersion() {
        return "1.1";
    }

    public Build(int x, int y, int z, String parFile) {
        this(x, y, z, parFile, false);
    }

    public void load() {
    }

    public void start() {
    }

    public void updateTick() {
    }

    public void setCornerPosition(int x, int y, int z) {
        this.map_coord_minX = x;
        this.map_coord_minY = y;
        this.map_coord_minZ = z;
    }

    public void recalculateLevelSize(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.recalculateLevelSize(x1, y1, z1, x2, y2, z2, false);
    }

    public void recalculateLevelSize(int x1, int y1, int z1, int x2, int y2, int z2, boolean sizeUp) {
        this.map_sizeX = 0;
        this.map_sizeY = 0;
        this.map_sizeZ = 0;
        this.map_coord_minX = x1;
        this.map_coord_minY = y1;
        this.map_coord_minZ = z1;
        if (x1 > x2) {
            this.map_coord_minX = x2;
        }
        if (y1 > y2) {
            this.map_coord_minY = y2;
        }
        if (z1 > z2) {
            this.map_coord_minZ = z2;
        }
        this.map_sizeX = x1 - x2 >= 0 ? x1 - x2 : x2 - x1;
        this.map_sizeY = y1 - y2 >= 0 ? y1 - y2 : y2 - y1;
        this.map_sizeZ = z1 - z2 >= 0 ? z1 - z2 : z2 - z1;
        if (sizeUp) {
            ++this.map_sizeX;
            ++this.map_sizeY;
            ++this.map_sizeZ;
        }
    }

    public void readNBT(String level) {
        this.levelData = null;
        try {
            NBTTagCompound nbttagcompound;
            this.levelData = nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(level + ".schematic"));
            this.newFormat = nbttagcompound.func_74767_n("newFormat");
            if (nbttagcompound.func_74764_b("version")) {
                this.version = nbttagcompound.func_74779_i("version");
            }
            if (this.newFormat) {
                NBTTagCompound nbtMapping = nbttagcompound.func_74775_l("blockTranslationMap");
                if (this.getVersion().equals("1.0")) {
                    this.blockMappingInternalIDToBlock = this.genBlockIDSchemToBlockWithUnlocalizedName(nbtMapping);
                } else if (this.getVersion().equals("1.1")) {
                    this.blockMappingInternalIDToBlock = this.genBlockIDSchemToBlockWithRegistry(nbtMapping);
                } else {
                    System.out.println("CRITICAL! BuildMod does not support version: " + this.getVersion());
                }
            } else {
                System.out.println("TODO: a fallback lookup table for old block IDs to unlocalized names");
            }
            System.out.println("TODO for BuildMod: verify 9 is accurate type to use, NBTBase defines type 9 as NBTTagList");
            this.tileEntities = nbttagcompound.func_150295_c("TileEntities", 9);
            this.entities = nbttagcompound.func_150295_c("Entities", 9);
            int n = nbttagcompound.func_74765_d("Width");
            this.map_sizeX = n;
            int sizeX = n;
            int n2 = nbttagcompound.func_74765_d("Length");
            this.map_sizeZ = n2;
            int sizeZ = n2;
            int n3 = nbttagcompound.func_74765_d("Height");
            this.map_sizeY = n3;
            int sizeY = n3;
            this.map_surfaceOffset = nbttagcompound.func_74765_d("surfaceOffset");
            boolean bPosX = false;
            boolean bPosY = false;
            boolean bPosZ = false;
            this.build_blockIDArr = new Block[sizeX][sizeY][sizeZ];
            this.build_blockMetaArr = new int[sizeX][sizeY][sizeZ];
            if (this.newFormat) {
                int[] metadata = nbttagcompound.func_74759_k("Data");
                int[] blockids = nbttagcompound.func_74759_k("Blocks");
                for (int xx = 0; xx < sizeX; ++xx) {
                    for (int yy = 0; yy < sizeY; ++yy) {
                        for (int zz = 0; zz < sizeZ; ++zz) {
                            int index = yy * sizeX * sizeZ + zz * sizeX + xx;
                            this.build_blockMetaArr[xx][yy][zz] = metadata[index];
                            int internalID = blockids[index];
                            Block block = this.getConvertInternalIDToBlock(internalID);
                            if (block == null) {
                                System.out.println("CRITICAL! BuildMod: null block when converting a version " + this.getVersion() + " schematic to block instance, this should be a bug, contact Corosus");
                                block = Blocks.field_150350_a;
                            }
                            this.build_blockIDArr[xx][yy][zz] = block;
                        }
                    }
                }
            } else {
                System.out.println("Notice: BuildMod detected really old schematic version, noted incase of future import errors");
                byte[] metadata = nbttagcompound.func_74770_j("Data");
                byte[] blockids = nbttagcompound.func_74770_j("Blocks");
                for (int xx = 0; xx < sizeX; ++xx) {
                    for (int yy = 0; yy < sizeY; ++yy) {
                        for (int zz = 0; zz < sizeZ; ++zz) {
                            Block block;
                            int index = yy * sizeX * sizeZ + zz * sizeX + xx;
                            this.build_blockMetaArr[xx][yy][zz] = metadata[index];
                            int internalID = blockids[index];
                            if (internalID < 0) {
                                internalID += 256;
                            }
                            if ((block = this.getConvertInternalIDToBlock(internalID)) == null) {
                                System.out.println("CRITICAL! BuildMod: null block when converting a version " + this.getVersion() + " schematic to block instance, this should be a bug, contact Corosus");
                                block = Blocks.field_150350_a;
                            }
                            this.build_blockIDArr[xx][yy][zz] = block;
                        }
                    }
                }
            }
            this.file = level;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Block getConvertInternalIDToBlock(int internalID) {
        Block block = null;
        if (!this.getVersion().equals("1.0") || internalID > blockIDHighestVanilla) {
            if (this.blockMappingInternalIDToBlock.containsKey(internalID)) {
                block = this.blockMappingInternalIDToBlock.get(internalID);
                if (block == null) {
                    System.out.println("CRITICAL! BuildMod: null block when using blockMappingInternalIDToBlock.get(int) for ID " + internalID);
                }
            } else {
                System.out.println("CRITICAL! BuildMod: error finding block internalID to real block for ID " + internalID);
            }
        } else {
            block = (Block)Block.field_149771_c.func_148754_a(internalID);
            if (block == null) {
                System.out.println("CRITICAL! BuildMod: null block when using Block.blockRegistry.getObjectById(int) for ID " + internalID);
            }
        }
        return block;
    }

    public void resetData() {
        this.build_blockIDArr = new Block[this.map_sizeX][this.map_sizeY][this.map_sizeZ];
        this.build_blockMetaArr = new int[this.map_sizeX][this.map_sizeY][this.map_sizeZ];
    }

    public void scanLevelToData() {
        this.scanLevelToData((World)FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dim));
    }

    public void scanLevelToData(World worldObj) {
        this.resetData();
        for (int xx = 0; xx < this.map_sizeX; ++xx) {
            for (int yy = 0; yy < this.map_sizeY; ++yy) {
                for (int zz = 0; zz < this.map_sizeZ; ++zz) {
                    int index = yy * this.map_sizeX * this.map_sizeZ + zz * this.map_sizeX + xx;
                    World worldRef = worldObj;
                    this.build_blockIDArr[xx][yy][zz] = worldRef.func_147439_a(this.map_coord_minX + xx, this.map_coord_minY + yy, this.map_coord_minZ + zz);
                    this.build_blockMetaArr[xx][yy][zz] = worldRef.func_72805_g(this.map_coord_minX + xx, this.map_coord_minY + yy, this.map_coord_minZ + zz);
                }
            }
        }
    }

    public void scanWriteNBT() {
        this.scanLevelToData();
        this.writeNBT();
    }

    public void writeNBT() {
        HashMap<Block, Integer> mapBlockToInternalID = this.getBlockToInternalIDMap();
        try {
            if (this.levelData == null) {
                System.out.println("New NBT Data Object");
                this.levelData = new NBTTagCompound();
            }
            int[] metadataInt = new int[this.map_sizeX * this.map_sizeY * this.map_sizeZ];
            int[] blockidsInt = new int[this.map_sizeX * this.map_sizeY * this.map_sizeZ];
            byte[] metadataByte = new byte[this.map_sizeX * this.map_sizeY * this.map_sizeZ];
            byte[] blockidsByte = new byte[this.map_sizeX * this.map_sizeY * this.map_sizeZ];
            NBTTagList var16 = new NBTTagList();
            for (int xx = 0; xx < this.map_sizeX; ++xx) {
                for (int yy = 0; yy < this.map_sizeY; ++yy) {
                    for (int zz = 0; zz < this.map_sizeZ; ++zz) {
                        int index = yy * this.map_sizeX * this.map_sizeZ + zz * this.map_sizeX + xx;
                        if (this.newFormat) {
                            Integer tryID = mapBlockToInternalID.get(this.build_blockIDArr[xx][yy][zz]);
                            if (tryID == null) {
                                System.out.println("CRITICAL! BuildMod: converting block to internal ID failed, for block: " + this.build_blockIDArr[xx][yy][zz]);
                            } else {
                                int internalID;
                                blockidsInt[index] = internalID = Integer.valueOf(tryID).intValue();
                            }
                            metadataInt[index] = this.build_blockMetaArr[xx][yy][zz];
                        } else {
                            System.out.println("CRITICAL BUILDMOD: UNSUPPORTED OLD VERSION OF MAP FOR WRITE OUT, THIS SHOULDNT HAPPEN EVER!");
                        }
                        WorldServer worldRef = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dim);
                        TileEntity tEnt = worldRef.func_147438_o(this.map_coord_minX + xx, this.map_coord_minY + yy, this.map_coord_minZ + zz);
                        if (tEnt == null) continue;
                        NBTTagCompound var10 = new NBTTagCompound();
                        if (tEnt instanceof SchematicData) {
                            ((SchematicData)tEnt).writeToNBT(var10, this);
                        } else {
                            tEnt.func_145841_b(var10);
                        }
                        var10.func_74757_a("coordsSetRelative", true);
                        var10.func_74768_a("x", xx);
                        var10.func_74768_a("y", yy);
                        var10.func_74768_a("z", zz);
                        var16.func_74742_a((NBTBase)var10);
                    }
                }
            }
            this.levelData.func_74782_a("TileEntities", (NBTBase)var16);
            if (this.newFormat) {
                this.levelData.func_74783_a("Blocks", blockidsInt);
                this.levelData.func_74783_a("Data", metadataInt);
            } else {
                this.levelData.func_74773_a("Blocks", blockidsByte);
                this.levelData.func_74773_a("Data", metadataByte);
            }
            this.levelData.func_74757_a("newFormat", this.newFormat);
            this.levelData.func_74778_a("version", this.getSaveVersion());
            this.levelData.func_74782_a("blockTranslationMap", (NBTBase)this.genBlockIDToNameMap());
            this.levelData.func_74777_a("Width", (short)this.map_sizeX);
            this.levelData.func_74777_a("Height", (short)this.map_sizeY);
            this.levelData.func_74777_a("Length", (short)this.map_sizeZ);
            this.levelData.func_74777_a("surfaceOffset", (short)this.map_surfaceOffset);
            this.saveLevelData(this.file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public HashMap<Block, Integer> getBlockToInternalIDMap() {
        HashMap<Block, Integer> map = new HashMap<Block, Integer>();
        Set set = Block.field_149771_c.func_148742_b();
        Iterator it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            String tagName = (String)it.next();
            Block block = (Block)Block.field_149771_c.func_82594_a(tagName);
            if (block == null || block.func_149739_a().equals("tile.ForgeFiller")) continue;
            map.put(block, i);
            ++i;
        }
        return map;
    }

    public NBTTagCompound genBlockIDToNameMap() {
        NBTTagCompound nbt = new NBTTagCompound();
        Set set = Block.field_149771_c.func_148742_b();
        Iterator it = set.iterator();
        int i = 0;
        while (it.hasNext()) {
            String tagName = (String)it.next();
            Block block = (Block)Block.field_149771_c.func_82594_a(tagName);
            if (block == null || block.func_149739_a().equals("tile.ForgeFiller")) continue;
            nbt.func_74768_a(CoroUtilBlock.getNameByBlock(block), i);
            ++i;
        }
        return nbt;
    }

    public HashMap<Integer, Block> genBlockIDSchemToBlockWithUnlocalizedName(NBTTagCompound parMappingNBT) {
        HashMap<String, Block> swapMap = new HashMap<String, Block>();
        HashMap<Integer, Block> finalMap = new HashMap<Integer, Block>();
        try {
            Set set = Block.field_149771_c.func_148742_b();
            for (String tagName : set) {
                Block block = (Block)Block.field_149771_c.func_82594_a(tagName);
                if (block == null || block.func_149739_a().equals("tile.ForgeFiller")) continue;
                swapMap.put(block.func_149739_a(), block);
            }
            for (String tagName : parMappingNBT.func_150296_c()) {
                int tag = parMappingNBT.func_74762_e(tagName);
                if (swapMap.get(tagName) != null) {
                    finalMap.put(tag, (Block)swapMap.get(tagName));
                    continue;
                }
                System.out.println("missing a mapping in this schematic for: " + tag);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return finalMap;
    }

    public HashMap<Integer, Block> genBlockIDSchemToBlockWithRegistry(NBTTagCompound parMappingNBT) {
        HashMap<String, Block> swapMap = new HashMap<String, Block>();
        HashMap<Integer, Block> finalMap = new HashMap<Integer, Block>();
        try {
            Set set = Block.field_149771_c.func_148742_b();
            for (String tagName : set) {
                Block block = (Block)Block.field_149771_c.func_82594_a(tagName);
                if (block == null || block.func_149739_a().equals("tile.ForgeFiller")) continue;
                swapMap.put(CoroUtilBlock.getNameByBlock(block), block);
            }
            for (String tagName : parMappingNBT.func_150296_c()) {
                int tag = parMappingNBT.func_74762_e(tagName);
                if (swapMap.get(tagName) != null) {
                    finalMap.put(tag, (Block)swapMap.get(tagName));
                    continue;
                }
                System.out.println("missing a mapping in this schematic for: " + tag);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return finalMap;
    }

    public void saveLevelData(String level) {
        try {
            if (this.levelData != null) {
                FileOutputStream fos = new FileOutputStream(level + ".schematic");
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.levelData, (OutputStream)fos);
                fos.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fillBuildData(Build parBuild) {
        FileInputStream fis = null;
        try {
            FileInputStream is = new FileInputStream(parBuild.file);
            fis = new FileInputStream(parBuild.file);
            NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fis);
            byte[] metadata = nbttagcompound.func_74770_j("Data");
            byte[] blockids = nbttagcompound.func_74770_j("Blocks");
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }
}

