/*
 * Decompiled with CFR 0.152.
 */
package build.render;

import CoroUtil.util.CoroUtilBlock;
import build.world.Build;
import build.world.BuildManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Vector3d;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import scala.util.Random;

@SideOnly(value=Side.CLIENT)
public class Overlays {
    public static List<Vector3d> listPolys = new ArrayList<Vector3d>();

    public static void renderBuildPreview(Build b, Vec3 pos, Vec3 angle) {
        Tessellator tess = Tessellator.field_78398_a;
        float scale = 1.0f;
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        Vec3 posPlayer = Vec3.func_72443_a((double)mc.field_71439_g.field_70165_t, (double)mc.field_71439_g.field_70163_u, (double)mc.field_71439_g.field_70161_v);
        GL11.glTranslated((double)(-posPlayer.field_72450_a), (double)(-posPlayer.field_72448_b), (double)(-posPlayer.field_72449_c));
        GL11.glTranslated((double)(pos.field_72450_a - 0.5), (double)(pos.field_72448_b + 0.5), (double)(pos.field_72449_c - 0.5));
        for (int x = 0; x < b.map_sizeX; ++x) {
            for (int y = 0; y < b.map_sizeY; ++y) {
                for (int z = 0; z < b.map_sizeZ; ++z) {
                    Block block = b.build_blockIDArr[x][y][z];
                    int meta = b.build_blockMetaArr[x][y][z];
                    if (CoroUtilBlock.isAir(block) || block == null) continue;
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)((float)x * scale), (double)((float)y * scale), (double)((float)z * scale));
                    Overlays.renderBlock(block, meta, 0, 0, 0);
                    GL11.glPopMatrix();
                }
            }
        }
        GL11.glPopMatrix();
    }

    public static void renderBuildOutline(Build b, int dir) {
        float x = b.map_coord_minX;
        float y = b.map_coord_minY;
        float z = b.map_coord_minZ;
        float x1 = (float)b.map_sizeX + x - 1.0f;
        float y1 = (float)b.map_sizeY + y - 1.0f;
        float z1 = (float)b.map_sizeZ + z - 1.0f;
        ChunkCoordinates c1 = BuildManager.rotate(new ChunkCoordinates((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z)), dir, Vec3.func_72443_a((double)b.map_coord_minX, (double)b.map_coord_minY, (double)b.map_coord_minZ), Vec3.func_72443_a((double)b.map_sizeX, (double)b.map_sizeY, (double)b.map_sizeZ));
        ChunkCoordinates c2 = BuildManager.rotate(new ChunkCoordinates((int)Math.floor(x1), (int)Math.floor(y1), (int)Math.floor(z1)), dir, Vec3.func_72443_a((double)b.map_coord_minX, (double)b.map_coord_minY, (double)b.map_coord_minZ), Vec3.func_72443_a((double)b.map_sizeX, (double)b.map_sizeY, (double)b.map_sizeZ));
        Overlays.renderBuildOutline(c1.field_71574_a, c1.field_71572_b, c1.field_71573_c, c2.field_71574_a, c2.field_71572_b, c2.field_71573_c);
        Overlays.renderCircle(c1.field_71574_a, (double)c1.field_71572_b + 3.0, c1.field_71573_c, 255, 3.0);
        Overlays.renderFun(c1.field_71574_a, c1.field_71572_b, c1.field_71573_c, 255);
    }

    public static void renderDirectionArrow(Build b, int dir) {
        float x = (float)b.map_coord_minX - 5.5f + (float)b.map_sizeX / 2.0f;
        float y = b.map_coord_minY;
        float z = (float)b.map_coord_minZ + (float)b.map_sizeZ / 2.0f;
        float x1 = (float)b.map_coord_minX + (float)b.map_sizeX / 2.0f;
        float y1 = b.map_coord_minY;
        float z1 = (float)b.map_coord_minZ + (float)b.map_sizeZ / 2.0f;
        float x2 = (float)(b.map_sizeX / 2) + x - 1.0f;
        float y2 = (float)b.map_sizeY + y - 1.0f;
        float z2 = (float)(b.map_sizeZ / 2) + z - 1.0f;
        ChunkCoordinates c1 = BuildManager.rotateNew(new ChunkCoordinates((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z)), dir, Vec3.func_72443_a((double)b.map_coord_minX, (double)b.map_coord_minY, (double)b.map_coord_minZ), Vec3.func_72443_a((double)b.map_sizeX, (double)b.map_sizeY, (double)b.map_sizeZ));
        ChunkCoordinates c2 = BuildManager.rotateNew(new ChunkCoordinates((int)Math.floor(x1), (int)Math.floor(y1), (int)Math.floor(z1)), dir, Vec3.func_72443_a((double)b.map_coord_minX, (double)b.map_coord_minY, (double)b.map_coord_minZ), Vec3.func_72443_a((double)b.map_sizeX, (double)b.map_sizeY, (double)b.map_sizeZ));
        Overlays.renderLineFromToBlock((double)c1.field_71574_a + 0.5, (double)y + 3.5, (double)c1.field_71573_c + 0.5, (double)c2.field_71574_a + 0.5, (double)y + 8.5, (double)c2.field_71573_c + 0.5, 65280);
    }

    public static void renderAABB(AxisAlignedBB aabb, int color) {
        double x = aabb.field_72336_d;
        double y = aabb.field_72337_e;
        double z = aabb.field_72334_f;
        double x1 = aabb.field_72340_a;
        double y1 = aabb.field_72338_b;
        double z1 = aabb.field_72339_c;
        Overlays.renderLineFromToBlock(x, y, z, x1, y1, z1, color);
        Overlays.renderLineFromToBlock(x1, y, z1, x, y1, z, color);
        Overlays.renderLineFromToBlock(x, y, z1, x1, y1, z, color);
        Overlays.renderLineFromToBlock(x1, y, z, x, y1, z1, color);
        Overlays.renderLineFromToBlock(x, y, z, x, y, z1, color);
        Overlays.renderLineFromToBlock(x, y, z, x, y1, z, color);
        Overlays.renderLineFromToBlock(x, y, z, x1, y, z, color);
        Overlays.renderLineFromToBlock(x1, y, z, x1, y1, z, color);
        Overlays.renderLineFromToBlock(x1, y, z, x1, y, z1, color);
        Overlays.renderLineFromToBlock(x1, y, z1, x1, y1, z1, color);
        Overlays.renderLineFromToBlock(x1, y, z1, x, y, z1, color);
        Overlays.renderLineFromToBlock(x, y, z1, x, y1, z1, color);
        Overlays.renderLineFromToBlock(x, y1, z, x1, y1, z, color);
        Overlays.renderLineFromToBlock(x1, y1, z, x1, y1, z1, color);
        Overlays.renderLineFromToBlock(x1, y1, z1, x, y1, z1, color);
        Overlays.renderLineFromToBlock(x, y1, z1, x, y1, z, color);
    }

    public static void renderBuildOutline(float x, float y, float z, float x1, float y1, float z1) {
        Overlays.renderBuildOutline(x, y, z, x1, y1, z1, true, 0xFF0000);
    }

    public static void renderBuildOutline(double x, double y, double z, double x1, double y1, double z1, boolean center, int parColor) {
        Overlays.renderBuildOutline((float)x, (float)y, (float)z, (float)x1, (float)y1, (float)z1, center, parColor);
    }

    public static void renderBuildOutline(float x, float y, float z, float x1, float y1, float z1, boolean center, int parColor) {
        if (center) {
            x += 0.5f;
            y += 0.5f;
            z += 0.5f;
            x1 += 0.5f;
            y1 += 0.5f;
            z1 += 0.5f;
        }
        int color = parColor;
        Overlays.renderLineFromToBlock(x, y, z, x1, y1, z1, color);
        Overlays.renderLineFromToBlock(x1, y, z1, x, y1, z, color);
        Overlays.renderLineFromToBlock(x, y, z1, x1, y1, z, color);
        Overlays.renderLineFromToBlock(x1, y, z, x, y1, z1, color);
        Overlays.renderLineFromToBlock(x, y, z, x, y, z1, color);
        Overlays.renderLineFromToBlock(x, y, z, x, y1, z, color);
        Overlays.renderLineFromToBlock(x, y, z, x1, y, z, color);
        Overlays.renderLineFromToBlock(x1, y, z, x1, y1, z, color);
        Overlays.renderLineFromToBlock(x1, y, z, x1, y, z1, color);
        Overlays.renderLineFromToBlock(x1, y, z1, x1, y1, z1, color);
        Overlays.renderLineFromToBlock(x1, y, z1, x, y, z1, color);
        Overlays.renderLineFromToBlock(x, y, z1, x, y1, z1, color);
        Overlays.renderLineFromToBlock(x, y1, z, x1, y1, z, color);
        Overlays.renderLineFromToBlock(x1, y1, z, x1, y1, z1, color);
        Overlays.renderLineFromToBlock(x1, y1, z1, x, y1, z1, color);
        Overlays.renderLineFromToBlock(x, y1, z1, x, y1, z, color);
    }

    public static void renderLine(PathPoint ppx, PathPoint ppx2, double d, double d1, double d2, float f, float f1, int stringColor) {
        Overlays.renderLineFromToBlock(ppx.field_75839_a, ppx.field_75837_b, ppx.field_75838_c, ppx2.field_75839_a, ppx2.field_75837_b, ppx2.field_75838_c, stringColor);
    }

    public static void renderLineFromToBlockCenter(double x1, double y1, double z1, double x2, double y2, double z2, int stringColor) {
        Overlays.renderLineFromToBlock(x1 + 0.5, y1 + 0.5, z1 + 0.5, x2 + 0.5, y2 + 0.5, z2 + 0.5, stringColor);
    }

    public static void renderLineFromToBlock(double x1, double y1, double z1, double x2, double y2, double z2, int stringColor) {
        Tessellator tessellator = Tessellator.field_78398_a;
        RenderManager rm = RenderManager.field_78727_a;
        float castProgress = 1.0f;
        float f10 = 0.0f;
        double d4 = MathHelper.func_76126_a((float)f10);
        double d6 = MathHelper.func_76134_b((float)f10);
        double pirateX = x1;
        double pirateY = y1;
        double pirateZ = z1;
        double entX = x2;
        double entY = y2;
        double entZ = z2;
        double fishX = (double)castProgress * (entX - pirateX);
        double fishY = (double)castProgress * (entY - pirateY);
        double fishZ = (double)castProgress * (entZ - pirateZ);
        GL11.glDisable((int)3553);
        tessellator.func_78371_b(3);
        tessellator.func_78378_d(stringColor);
        int steps = 1;
        for (int i = 0; i <= steps; ++i) {
            float f4 = (float)i / (float)steps;
            tessellator.func_78377_a(pirateX - RenderManager.field_78725_b + fishX * (double)f4, pirateY - RenderManager.field_78726_c + fishY * (double)f4, pirateZ - RenderManager.field_78723_d + fishZ * (double)f4);
        }
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
    }

    public static void renderBlock(Block var2, int meta, int x, int y, int z) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        RenderBlocks a = new RenderBlocks((IBlockAccess)world);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        float var8 = 0.5f;
        float var9 = 1.0f;
        float var10 = 0.8f;
        float var11 = 0.6f;
        Tessellator var12 = Tessellator.field_78398_a;
        var12.func_78382_b();
        var12.func_78380_c(var2.func_149677_c((IBlockAccess)world, x, y, z));
        float var13 = 0.8f;
        float var14 = 0.8f;
        var14 = var13 = 1.0f;
        float var15 = 1.0f;
        float var16 = 1.0f;
        float var17 = 1.0f;
        if (var2 == Blocks.field_150362_t) {
            int var18 = var2.func_149720_d((IBlockAccess)world, x, y, z);
            var15 = (float)(var18 >> 16 & 0xFF) / 255.0f;
            var16 = (float)(var18 >> 8 & 0xFF) / 255.0f;
            var17 = (float)(var18 & 0xFF) / 255.0f;
            if (EntityRenderer.field_78517_a) {
                float var19 = (var15 * 30.0f + var16 * 59.0f + var17 * 11.0f) / 100.0f;
                float var20 = (var15 * 30.0f + var16 * 70.0f) / 100.0f;
                float var21 = (var15 * 30.0f + var17 * 70.0f) / 100.0f;
                var15 = var19;
                var16 = var20;
                var17 = var21;
            }
        }
        a.func_147782_a(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        var12.func_78386_a(var15 * var8 * var14, var16 * var8 * var14, var17 * var8 * var14);
        a.func_147768_a(var2, -0.5, -0.5, -0.5, var2.func_149691_a(0, meta));
        if (var14 < var13) {
            var14 = var13;
        }
        var12.func_78386_a(var15 * var9 * var14, var16 * var9 * var14, var17 * var9 * var14);
        a.func_147806_b(var2, -0.5, -0.5, -0.5, var2.func_149691_a(1, meta));
        if (var14 < var13) {
            var14 = var13;
        }
        var12.func_78386_a(var15 * var10 * var14, var16 * var10 * var14, var17 * var10 * var14);
        a.func_147761_c(var2, -0.5, -0.5, -0.5, var2.func_149691_a(2, meta));
        if (var14 < var13) {
            var14 = var13;
        }
        var12.func_78386_a(var15 * var10 * var14, var16 * var10 * var14, var17 * var10 * var14);
        a.func_147734_d(var2, -0.5, -0.5, -0.5, var2.func_149691_a(3, meta));
        if (var14 < var13) {
            var14 = var13;
        }
        var12.func_78386_a(var15 * var11 * var14, var16 * var11 * var14, var17 * var11 * var14);
        a.func_147798_e(var2, -0.5, -0.5, -0.5, var2.func_149691_a(4, meta));
        if (var14 < var13) {
            var14 = var13;
        }
        var12.func_78386_a(var15 * var11 * var14, var16 * var11 * var14, var17 * var11 * var14);
        a.func_147764_f(var2, -0.5, -0.5, -0.5, var2.func_149691_a(5, meta));
        var12.func_78381_a();
    }

    public static void renderCircle(double x1, double y1, double z1, int stringColor, double size) {
        try {
            Tessellator tessellator = Tessellator.field_78398_a;
            RenderManager rm = RenderManager.field_78727_a;
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3553);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-rm.field_78730_l), (double)(-rm.field_78731_m), (double)(-rm.field_78728_n));
            GL11.glBegin((int)9);
            GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
            double rate = 15.0;
            for (double angle = 0.0; angle <= 360.0; angle += rate) {
                GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glVertex3d((double)(x1 + Math.sin(Math.toRadians(angle)) * size), (double)y1, (double)(z1 + Math.cos(Math.toRadians(angle)) * size));
            }
            GL11.glEnd();
            GL11.glPopMatrix();
            GL11.glEnable((int)3553);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void renderSphereFun(double xx1, double yy1, double zz1, int stringColor) {
        try {
            Tessellator tessellator = Tessellator.field_78398_a;
            RenderManager rm = RenderManager.field_78727_a;
            double size = 3.0;
            yy1 -= 1.0;
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3553);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-rm.field_78730_l), (double)(-rm.field_78731_m + 5.0), (double)(-rm.field_78728_n));
            GL11.glTranslated((double)xx1, (double)yy1, (double)zz1);
            GL11.glRotated((double)-90.0, (double)1.0, (double)0.0, (double)0.0);
            GL11.glEnable((int)2903);
            GL11.glColorMaterial((int)1028, (int)5634);
            GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
            Random rand = new Random();
            double rate = 15.0;
            float radius = 5.0f;
            int lats = 32;
            int longs = 32;
            for (int i = 1; i <= lats; ++i) {
                double lat0 = Math.PI * (-0.5 + (double)(i - 1) / (double)lats);
                double z0 = Math.sin(lat0);
                double zr0 = Math.cos(lat0);
                double lat1 = Math.PI * (-0.5 + (double)i / (double)lats);
                double z1 = Math.sin(lat1);
                double zr1 = Math.cos(lat1);
                GL11.glBegin((int)8);
                for (int j = 0; j <= longs; ++j) {
                    double lng = Math.PI * 2 * (double)(j - 1) / (double)longs;
                    double x = Math.cos(lng);
                    double y = Math.sin(lng);
                    double adj1 = Math.sin(Math.toRadians(((long)(i * 200) + System.currentTimeMillis()) % 3600L) * 0.1);
                    double adj2 = Math.cos(Math.toRadians(((long)(i * 200) + System.currentTimeMillis()) % 3600L) * 0.1);
                    GL11.glColor3d((double)0.0, (double)((double)i / (double)lats + 1.0 * Math.sin(Math.toRadians(System.currentTimeMillis() % 3600L) * 0.1) * 0.3), (double)((double)i / (double)lats + 1.0 * Math.sin(Math.toRadians((System.currentTimeMillis() + 1800L) % 3600L) * 0.1) * 0.3));
                    GL11.glVertex3d((double)(x * zr0 + adj1), (double)(y * zr0 + adj2), (double)z0);
                    GL11.glVertex3d((double)(x * zr1 + adj1), (double)(y * zr1 + adj2), (double)z1);
                }
                GL11.glEnd();
            }
            GL11.glPopMatrix();
            GL11.glEnable((int)3553);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void renderFun(double xx1, double yy1, double zz1, int stringColor) {
        try {
            Tessellator tessellator = Tessellator.field_78398_a;
            RenderManager rm = RenderManager.field_78727_a;
            double size = 3.0;
            yy1 += 5.0;
            GL11.glMatrixMode((int)5888);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3553);
            GL11.glPushMatrix();
            GL11.glTranslated((double)(-rm.field_78730_l), (double)(-rm.field_78731_m + 5.0), (double)(-rm.field_78728_n));
            GL11.glTranslated((double)xx1, (double)yy1, (double)zz1);
            Random rand = new Random();
            double rate = 15.0;
            double spawnRad = 3.0;
            if (listPolys.size() == 0) {
                listPolys.clear();
                for (int i = 0; i < 10; ++i) {
                    listPolys.add(new Vector3d(rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad, rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad, rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad));
                }
            }
            int vertPerPoly = 3;
            for (int i = 0; i < listPolys.size(); ++i) {
                GL11.glBegin((int)9);
                double x1 = Overlays.listPolys.get((int)i).x;
                double y1 = Overlays.listPolys.get((int)i).y;
                double z1 = Overlays.listPolys.get((int)i).z;
                double v1 = 45.0;
                double v2 = 90.0;
                double v3 = 135.0;
                double x2 = Math.sin(Math.toRadians(((double)(System.currentTimeMillis() / 10L) + v1) % 360.0));
                double x3 = Math.cos(Math.toRadians(((double)(System.currentTimeMillis() / 10L) + v2) % 360.0));
                double x4 = -Math.sin(Math.toRadians(((double)(System.currentTimeMillis() / 10L) + v3) % 360.0));
                double y2 = Math.sin(Math.toRadians(System.currentTimeMillis() / 10L % 360L));
                double y3 = Math.cos(Math.toRadians(System.currentTimeMillis() / 10L % 360L));
                double y4 = -Math.sin(Math.toRadians(System.currentTimeMillis() / 10L % 360L));
                double z2 = Math.sin(Math.toRadians(System.currentTimeMillis() / 10L % 360L));
                double z3 = Math.cos(Math.toRadians(System.currentTimeMillis() / 10L % 360L));
                double z4 = -Math.sin(Math.toRadians(System.currentTimeMillis() / 10L % 360L));
                GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glVertex3d((double)(x1 + x2), (double)(y1 + y2), (double)(z1 + z2));
                GL11.glVertex3d((double)(x1 + x3), (double)(y1 + y3), (double)(z1 + z3));
                GL11.glVertex3d((double)(x1 + x4), (double)(y1 + y4), (double)(z1 + z4));
                GL11.glEnd();
            }
            float radius = 5.0f;
            int lats = 32;
            int longs = 32;
            GL11.glPopMatrix();
            GL11.glEnable((int)3553);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

