/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.entity.monster;

import CoroUtil.componentAI.jobSystem.JobBase;
import CoroUtil.util.CoroUtilBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hostileworlds.HostileWorlds;
import hostileworlds.ai.jobs.JobHunt;
import hostileworlds.entity.EntityWorm;
import hostileworlds.entity.MovingBlock;
import hostileworlds.entity.particle.EntityMeteorTrailFX;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityReddustFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityWormFire
extends EntityWorm {
    public boolean spawnBlock = true;
    public List<WormNode> nodes = new ArrayList<WormNode>();
    public float smoothYaw;
    public float smoothPitch;
    public int nodePieces = 7;
    public int nodePieceBlockCount = 18;
    public int tempMaxHealth = 100;
    public int maxHealth = 20;
    public float nodeToNodeDist = 1.0f;
    public float blockRotateSpeed = 0.11f;
    public float baseRadius = 2.0f;
    public float bodyShiftRate = 0.2f;
    public float bodyShiftSize = 0.2f;
    public float moveSpeedMax;
    public float moveSpeed = 0.04f;
    public float lastHealth = this.maxHealth;
    public boolean spawning = true;
    public double lastMotionX = 0.0;
    public double lastMotionY = 0.0;
    public double lastMotionZ = 0.0;

    public EntityWormFire(World par1World) {
        super(par1World);
        this.maxHealth = this.nodePieces * this.nodePieceBlockCount;
        this.func_70105_a(1.5f, 1.0f);
        this.func_110163_bv();
        this.agent.jobMan.addPrimaryJob((JobBase)new JobHunt(this.agent.jobMan));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.tempMaxHealth = 100;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.tempMaxHealth);
    }

    public void func_70066_B() {
        super.func_70066_B();
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource == DamageSource.field_76367_g) {
            System.out.println("boom");
            this.func_70606_j(this.func_110143_aJ() - 1.0f);
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public void spawnBlock(WormNode node) {
        MovingBlock mb = new MovingBlock(this.field_70170_p, Blocks.field_150341_Y, 0);
        mb.func_70107_b(this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v);
        mb.gravity = 0.0f;
        mb.blockifyDelay = -1;
        mb.blockNum = node.blocks.size();
        mb.blockRow = this.nodes.size();
        float speed = 0.5f;
        this.field_70170_p.func_72838_d((Entity)mb);
        node.blocks.add(mb);
    }

    public void func_70106_y() {
        this.field_70128_L = true;
        for (int j = 0; j < this.nodes.size(); ++j) {
            List<MovingBlock> blocks = this.nodes.get((int)j).blocks;
            for (int i = 0; i < blocks.size(); ++i) {
                MovingBlock mb = blocks.get(i);
                mb.triggerOwnerDied();
            }
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 60; ++i) {
                Random rand = new Random();
                double range = 1.0;
                EntityReddustFX particle = new EntityReddustFX(this.field_70170_p, this.field_70165_t + 0.5 + rand.nextDouble() * range - rand.nextDouble() * range, this.field_70163_u + rand.nextDouble() * range, this.field_70161_v + 0.5 + rand.nextDouble() * range - rand.nextDouble() * range, 2.0f, rand.nextFloat(), 0.0f, 0.0f);
                particle.field_70159_w = rand.nextDouble() * range - rand.nextDouble() * range;
                particle.field_70181_x = rand.nextDouble() * range - rand.nextDouble() * range;
                particle.field_70179_y = rand.nextDouble() * range - rand.nextDouble() * range;
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70178_ae = true;
        if (!this.field_70170_p.field_72995_K) {
            MovingBlock mb;
            int i;
            List<MovingBlock> blocks;
            int j;
            if (this.func_70090_H() && this.field_70170_p.func_72820_D() % 20L == 0L) {
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
            if (this.spawning) {
                if (this.nodes.size() < this.nodePieces) {
                    this.nodes.add(new WormNode(this.field_70170_p, this.nodePieceBlockCount));
                } else {
                    this.spawning = false;
                    this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.maxHealth);
                }
            }
            if (this.func_110143_aJ() != this.lastHealth) {
                float diff = this.lastHealth - this.func_110143_aJ();
                this.lastHealth = this.func_110143_aJ();
                block0: for (j = this.nodes.size() - 1; j >= 0; --j) {
                    blocks = this.nodes.get((int)j).blocks;
                    for (i = 0; i < blocks.size(); ++i) {
                        mb = blocks.get(i);
                        if (!(diff > 0.0f)) continue block0;
                        mb.triggerOwnerDied();
                        blocks.remove(i);
                        diff -= 1.0f;
                    }
                }
            }
            int aliveCount = 0;
            for (j = this.nodes.size() - 1; j >= 0; --j) {
                blocks = this.nodes.get((int)j).blocks;
                for (i = 0; i < blocks.size(); ++i) {
                    mb = blocks.get(i);
                    if (mb.field_70128_L) continue;
                    ++aliveCount;
                }
            }
            int totalAlive = aliveCount;
            if (aliveCount == 0) {
                this.func_70606_j(0.0f);
            }
        }
        double speed = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
        float startY = (float)(this.field_70163_u + 1.0);
        this.field_70144_Y = 1.0f;
        if (!this.field_70170_p.field_72995_K) {
            int range = 3;
            int xx = (int)this.field_70165_t - range;
            while ((double)xx < this.field_70165_t + (double)range) {
                int yy = (int)this.field_70163_u - range;
                while ((double)yy < this.field_70163_u + (double)range) {
                    int zz = (int)this.field_70161_v - range;
                    while ((double)zz < this.field_70161_v + (double)range) {
                        Block id = this.field_70170_p.func_147439_a(xx, yy, zz);
                        if (!(CoroUtilBlock.isAir((Block)id) || id == Blocks.field_150480_ab || this.field_70170_p.func_147438_o(xx, yy, zz) != null || id.func_149688_o() == Material.field_151586_h || HostileWorlds.blocksList.contains(id) || this.field_70170_p.field_72995_K)) {
                            if (this.func_70011_f(xx, yy, zz) <= (double)range) {
                                if (id.func_149712_f(this.field_70170_p, xx, yy, zz) != -1.0f && (yy > 7 || this.field_70163_u < 7.0)) {
                                    this.field_70170_p.func_147449_b(xx, yy, zz, Blocks.field_150350_a);
                                }
                            } else if (CoroUtilBlock.isAir((Block)this.field_70170_p.func_147439_a(xx, yy + 1, zz)) && this.field_70170_p.field_73012_v.nextInt(10) == 0) {
                                this.field_70170_p.func_147449_b(xx, yy + 1, zz, (Block)Blocks.field_150480_ab);
                            }
                        }
                        ++zz;
                    }
                    ++yy;
                }
                ++xx;
            }
            float targetRange = (float)this.agent.maxDistanceFromHome;
            this.moveSpeedMax = 1.5f;
            Vec3 targetCoord = Vec3.func_72443_a((double)this.agent.homeX, (double)this.agent.homeY, (double)this.agent.homeZ);
            boolean chasingAPlayer = false;
            EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, (double)targetRange);
            if (player != null && this.func_70011_f(targetCoord.field_72450_a, targetCoord.field_72448_b, targetCoord.field_72449_c) < this.agent.maxDistanceFromHome) {
                chasingAPlayer = true;
                targetCoord.field_72450_a = player.field_70165_t;
                targetCoord.field_72448_b = player.field_70163_u;
                targetCoord.field_72449_c = player.field_70161_v;
            }
            if (!chasingAPlayer) {
                this.moveSpeedMax = 0.2f;
            }
            double vecX = targetCoord.field_72450_a - this.field_70165_t;
            double vecZ = targetCoord.field_72449_c - this.field_70161_v;
            float aimYaw = (float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI);
            this.smoothYaw += (aimYaw = MathHelper.func_76142_g((float)(this.smoothYaw - aimYaw))) < 0.0f ? -0.7f : 0.7f;
            this.smoothPitch = (float)(Math.atan2(targetCoord.field_72448_b - this.field_70163_u, Math.sqrt(vecX * vecX + vecZ * vecZ)) * 180.0 / Math.PI);
            this.func_70101_b(this.smoothYaw + 90.0f, this.field_70125_A);
            if (180.0f - Math.abs(aimYaw) < 30.0f) {
                if (speed < (double)this.moveSpeedMax) {
                    this.moveTowards((Entity)this, targetCoord, this.moveSpeed);
                } else {
                    this.field_70159_w *= (double)0.99f;
                    this.field_70181_x *= (double)0.99f;
                    this.field_70179_y *= (double)0.99f;
                }
            } else if (this.func_70011_f(targetCoord.field_72450_a, targetCoord.field_72448_b, targetCoord.field_72449_c) < 90.0) {
                this.field_70159_w *= (double)1.1f;
                this.field_70181_x *= (double)1.1f;
                this.field_70179_y *= (double)1.1f;
                this.field_70181_x = 0.05f;
            } else {
                this.field_70159_w *= (double)1.05f;
                this.field_70181_x *= (double)1.05f;
                this.field_70179_y *= (double)1.05f;
                this.field_70181_x = 0.05f;
            }
            float distt = (float)this.func_70011_f(targetCoord.field_72450_a, targetCoord.field_72448_b, targetCoord.field_72449_c);
            if (distt < 16.0f) {
                this.baseRadius = 2.0f + (16.0f - distt) / 6.0f;
            }
        }
        for (int j = 0; j < this.nodes.size(); ++j) {
            this.nodes.get((int)j).field_70144_Y = 1.0f;
            float dist = this.nodeToNodeDist;
            float shiftRate = 0.0f;
            if (j == 0) {
                this.nodes.get((int)j).field_70165_t = this.field_70165_t + Math.cos((this.smoothYaw + (float)j * shiftRate + 90.0f) * 0.01745329f) * (double)dist * (double)j;
                this.nodes.get((int)j).field_70163_u = (double)startY + Math.sin(this.field_70125_A - (float)j * 0.3f + (float)this.field_70170_p.func_72820_D() * 0.2f) * (double)dist * 0.5;
                this.nodes.get((int)j).field_70161_v = this.field_70161_v + Math.sin((this.smoothYaw + (float)j * shiftRate + 90.0f) * 0.01745329f) * (double)dist * (double)j;
                this.nodes.get((int)j).field_70177_z = this.smoothYaw + 90.0f;
            } else {
                float aimYaw;
                double targX = this.nodes.get((int)(j - 1)).field_70165_t;
                double targY = this.nodes.get((int)(j - 1)).field_70163_u;
                double targZ = this.nodes.get((int)(j - 1)).field_70161_v;
                double vecX = this.nodes.get((int)(j - 1)).field_70165_t - this.nodes.get((int)j).field_70165_t;
                double vecY = this.nodes.get((int)(j - 1)).field_70163_u - this.nodes.get((int)j).field_70163_u;
                double vecZ = this.nodes.get((int)(j - 1)).field_70161_v - this.nodes.get((int)j).field_70161_v;
                double nodeDist = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
                if (nodeDist > 40.0) {
                    this.nodes.get((int)j).field_70165_t = this.field_70165_t + Math.cos((this.smoothYaw + (float)j * shiftRate + 90.0f) * 0.01745329f) * (double)dist * (double)j;
                    this.nodes.get((int)j).field_70163_u = (double)startY + Math.sin(this.field_70125_A - (float)j * 0.3f + (float)this.field_70170_p.func_72820_D() * 0.2f) * (double)dist * 0.5;
                    this.nodes.get((int)j).field_70161_v = this.field_70161_v + Math.sin((this.smoothYaw + (float)j * shiftRate + 90.0f) * 0.01745329f) * (double)dist * (double)j;
                    this.nodes.get((int)j).field_70159_w = 0.0;
                    this.nodes.get((int)j).field_70181_x = 0.0;
                    this.nodes.get((int)j).field_70179_y = 0.0;
                } else if (nodeDist > (double)(this.nodeToNodeDist * 1.0f)) {
                    double speed2 = Math.sqrt(this.nodes.get((int)j).field_70159_w * this.nodes.get((int)j).field_70159_w + this.nodes.get((int)j).field_70181_x * this.nodes.get((int)j).field_70181_x + this.nodes.get((int)j).field_70179_y * this.nodes.get((int)j).field_70179_y);
                    if (speed2 < (double)(this.moveSpeedMax * 1.2f)) {
                        this.nodes.get((int)j).field_70159_w *= (double)0.85f;
                        this.nodes.get((int)j).field_70181_x *= (double)0.85f;
                        this.nodes.get((int)j).field_70179_y *= (double)0.85f;
                        this.moveTowards((Entity)this.nodes.get(j), this.nodes.get(j - 1), this.moveSpeed * 1.2f);
                    } else {
                        this.nodes.get((int)j).field_70159_w *= (double)0.95f;
                        this.nodes.get((int)j).field_70181_x *= (double)0.95f;
                        this.nodes.get((int)j).field_70179_y *= (double)0.95f;
                    }
                    this.moveTowards((Entity)this.nodes.get(j), this.nodes.get(j - 1), 0.05f);
                } else {
                    this.nodes.get((int)j).field_70159_w = 0.0;
                    this.nodes.get((int)j).field_70181_x = 0.0;
                    this.nodes.get((int)j).field_70179_y = 0.0;
                }
                this.nodes.get(j).func_70107_b(this.nodes.get((int)j).field_70165_t + this.nodes.get((int)j).field_70159_w, this.nodes.get((int)j).field_70163_u + this.nodes.get((int)j).field_70181_x, this.nodes.get((int)j).field_70161_v + this.nodes.get((int)j).field_70179_y);
                this.nodes.get((int)j).field_70177_z = aimYaw = (float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI) + 90.0f;
            }
            List<MovingBlock> blocks = this.nodes.get((int)j).blocks;
            for (int i = 0; i < blocks.size(); ++i) {
                MovingBlock mb = blocks.get(i);
                mb.field_70144_Y = 1.0f;
                if (mb.field_70128_L) {
                    blocks.remove((Object)mb);
                    continue;
                }
                double blockSpeed = Math.sqrt(mb.field_70159_w * mb.field_70159_w + mb.field_70181_x * mb.field_70181_x + mb.field_70179_y * mb.field_70179_y);
                if (mb.func_70032_d((Entity)this) > 60.0f || !(mb.func_70032_d((Entity)this) < 2.0f) || blockSpeed < (double)0.1f) {
                    // empty if block
                }
                float angleXZ = (float)(Math.atan2(this.nodes.get((int)j).field_70161_v - mb.field_70161_v, this.nodes.get((int)j).field_70165_t - mb.field_70165_t) * 180.0 / Math.PI) - 90.0f;
                angleXZ = -(this.nodes.get((int)j).field_70177_z + (float)j * shiftRate * 2.5f) * 0.01745329f;
                float radius = (float)((double)this.baseRadius + Math.cos((float)(this.field_70170_p.func_72820_D() + (long)j) * this.bodyShiftRate) * (double)this.bodyShiftSize);
                float rotateSpeed = this.blockRotateSpeed;
                float range1 = (float)(Math.sin(((float)this.field_70170_p.func_72820_D() - (float)i * 3.5f) * rotateSpeed) * (double)radius);
                float range2 = (float)(Math.cos(((float)this.field_70170_p.func_72820_D() - (float)i * 3.5f) * rotateSpeed) * (double)radius);
                double newX = (float)Math.cos(angleXZ);
                double newZ = (float)Math.sin(angleXZ);
                double newY = 1.0;
                mb.field_70165_t = this.nodes.get((int)j).field_70165_t - newX * (double)(j % 2 == 0 ? range1 : -range1);
                mb.field_70163_u = this.nodes.get((int)j).field_70163_u + newY * (double)range2;
                mb.field_70161_v = this.nodes.get((int)j).field_70161_v + newZ * (double)(j % 2 == 0 ? range1 : -range1);
                mb.field_70159_w = 0.0;
                mb.field_70181_x = 0.0;
                mb.field_70179_y = 0.0;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.lastMotionX = this.field_70159_w * (double)0.95f;
            this.lastMotionY = this.field_70181_x * (double)0.95f;
            this.lastMotionZ = this.field_70179_y * (double)0.95f;
        }
    }

    public void moveTowards(Entity ent, Entity targ, float speed) {
        double vecX = targ.field_70165_t - ent.field_70165_t;
        double vecY = targ.field_70163_u - ent.field_70163_u;
        double vecZ = targ.field_70161_v - ent.field_70161_v;
        double dist2 = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        ent.field_70159_w += vecX / dist2 * (double)speed;
        ent.field_70181_x += vecY / dist2 * (double)speed;
        ent.field_70179_y += vecZ / dist2 * (double)speed;
    }

    public void moveTowards(Entity ent, Vec3 targ, float speed) {
        double vecX = targ.field_72450_a - ent.field_70165_t;
        double vecY = targ.field_72448_b - ent.field_70163_u;
        double vecZ = targ.field_72449_c - ent.field_70161_v;
        double dist2 = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        ent.field_70159_w += vecX / dist2 * (double)speed;
        ent.field_70181_x += vecY / dist2 * (double)speed;
        ent.field_70179_y += vecZ / dist2 * (double)speed;
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles() {
        for (int i = 0; i < 1; ++i) {
            float speed = 0.1f;
            float randPos = 8.0f;
            float ahead = 2.5f;
            EntityMeteorTrailFX particle = new EntityMeteorTrailFX(this.field_70170_p, this.field_70165_t + this.field_70159_w * (double)ahead + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * randPos), this.field_70163_u + this.field_70181_x * (double)ahead + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * randPos), this.field_70161_v + this.field_70179_y * (double)ahead + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * randPos), this.field_70159_w, 0.25, this.field_70179_y, 0.0f, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            particle.field_70159_w = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * speed;
            particle.field_70181_x = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.1f;
            particle.field_70179_y = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * speed;
            particle.spawnAsWeatherEffect();
        }
    }

    public class WormNode
    extends Entity {
        public int blockCount;
        public List<MovingBlock> blocks;

        public WormNode(World world, int parBlockCount) {
            super(world);
            this.blocks = new ArrayList<MovingBlock>();
            this.blockCount = parBlockCount;
            for (int i = 0; i < this.blockCount; ++i) {
                EntityWormFire.this.spawnBlock(this);
            }
        }

        protected void func_70088_a() {
        }

        protected void func_70037_a(NBTTagCompound var1) {
        }

        protected void func_70014_b(NBTTagCompound var1) {
        }
    }
}

