/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.entity.abilities;

import CoroUtil.ability.Ability;
import CoroUtil.entity.projectile.EntityFireBall;
import CoroUtil.entity.projectile.EntityProjectileBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extendedrenderer.ExtendedRenderer;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class AbilityCastProjectile
extends Ability {
    public EntityLivingBase target;
    public int projectileType = 0;

    public AbilityCastProjectile() {
        this.name = "CastProjectile";
        this.ticksToCharge = 30;
        this.ticksToPerform = 5;
        this.ticksToCooldown = 80;
        this.bestDist = 25.0f;
        this.bestDistRange = 30.0f;
    }

    public void nbtLoad(NBTTagCompound nbt) {
        super.nbtLoad(nbt);
        this.projectileType = nbt.func_74762_e("projectileType");
    }

    public NBTTagCompound nbtSave() {
        NBTTagCompound nbt = super.nbtSave();
        nbt.func_74768_a("projectileType", this.projectileType);
        return nbt;
    }

    public void setTarget(Entity parTarget) {
        if (parTarget instanceof EntityLivingBase) {
            this.target = (EntityLivingBase)parTarget;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void tickRender(Render parRender) {
        super.tickRender(parRender);
        int curTick = this.curTickPerform;
        float amp = 1.0f;
        double offset = -1.1780972450961724;
        double range = Math.PI * 2;
        float swap = this.usageCount % 2 == 0 ? 1.0f : -1.0f;
    }

    public void tickChargeUp() {
        super.tickChargeUp();
        if (this.owner.field_70170_p.field_72995_K) {
            Random rand = new Random();
            if (this.curTickCharge > 0) {
                int amount = 1 + (int)(10.0 * ((double)this.curTickCharge / (double)this.ticksToCharge) / (double)(Minecraft.func_71410_x().field_71474_y.field_74362_aa + 1));
                for (int i = 0; i < amount; ++i) {
                    double speed = 0.15;
                    double speedInheritFactor = 0.5;
                    EntityRotFX entityfx = this.particleBehavior.spawnNewParticleIconFX((World)Minecraft.func_71410_x().field_71441_e, ParticleRegistry.squareGrey, this.owner.field_70165_t + rand.nextDouble(), this.owner.field_70121_D.field_72338_b + 0.8, this.owner.field_70161_v + rand.nextDouble(), (rand.nextDouble() - rand.nextDouble()) * speed, 0.03, (rand.nextDouble() - rand.nextDouble()) * speed);
                    this.particleBehavior.initParticle(entityfx);
                    entityfx.callUpdatePB = false;
                    ExtendedRenderer.rotEffRenderer.addEffect((EntityFX)entityfx);
                    this.particleBehavior.particles.add(entityfx);
                }
            }
        } else {
            this.owner.field_70159_w = 0.0;
            this.owner.field_70181_x = 0.0;
            this.owner.field_70179_y = 0.0;
        }
    }

    public void tickCooldown() {
        super.tickCooldown();
    }

    public void tickPerform() {
        if (this.target == null) {
            this.setFinishedPerform();
            return;
        }
        if (this.owner.field_70170_p.field_72995_K) {
            this.particleBehavior.particles.clear();
            Random rand = new Random();
        } else if (!(this.target != null && (this.target.field_70128_L || this.target instanceof EntityLivingBase && this.target.field_70725_aQ > 0) || this.hasAppliedDamage)) {
            this.hasAppliedDamage = true;
            if (this.target instanceof EntityLivingBase) {
                EntityFireBall prj = null;
                if (this.projectileType == EntityProjectileBase.PRJTYPE_FIREBALL) {
                    prj = new EntityFireBall(this.owner.field_70170_p, this.owner, this.target, 0.7);
                    prj.targetSeeking = true;
                } else if (this.projectileType == EntityProjectileBase.PRJTYPE_ICEBALL) {
                    // empty if block
                }
                if (prj != null) {
                    this.owner.field_70170_p.func_72838_d(prj);
                }
            }
        }
        super.tickPerform();
    }
}

