/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.ai.invasion;

import hostileworlds.HostileWorlds;
import hostileworlds.ServerTickHandler;
import hostileworlds.ai.WorldDirectorMultiDim;
import hostileworlds.ai.invasion.WorldEvent;
import hostileworlds.config.ModConfigFields;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class InvasionPortalCatacombs
extends WorldEvent {
    public InvasionPortalCatacombs() {
    }

    public InvasionPortalCatacombs(int parDim, String parName, WorldEvent.EnumWorldEventType parType, ChunkCoordinates source, ChunkCoordinates dest) {
        super(parDim, parName, parType, source, dest);
    }

    @Override
    public void tick() {
        super.tick();
        if (!(this.coordSource == null || this.waveCount != 0 && this.checkForActiveInvadersCached())) {
            if (this.curCooldown > 0) {
                --this.curCooldown;
            }
            if (this.waveCount == ModConfigFields.invasionWaveCountMax || this.curCooldown <= 0) {
                this.updateCursedPlayersList(false);
                this.updatePlayerStates();
                this.calculatePlayerRatingData();
                TileEntity tEnt = DimensionManager.getWorld((int)this.dimensionID).func_147438_o(this.coordSource.field_71574_a, this.coordSource.field_71572_b, this.coordSource.field_71573_c);
                if (tEnt == null) {
                    HostileWorlds.dbg("portal broke, end!");
                    WorldDirectorMultiDim.coordInvasionSources.get(this.dimensionID).remove(this.coordSource);
                    this.invasionEnd();
                    return;
                }
                if (this.waveCount < ModConfigFields.invasionWaveCountMax) {
                    this.currentWaveSpawnedInvaders = (int)((float)ModConfigFields.invasionBaseInvaderCount + this.currentWaveDifficultyRating / 3.0f);
                    HostileWorlds.dbg("trying to spawn group of: " + this.currentWaveSpawnedInvaders);
                    if (ServerTickHandler.wd.spawnGroup((World)DimensionManager.getWorld((int)this.dimensionID), this.coordDestination, this.coordSource, this, this.currentWaveSpawnedInvaders)) {
                        if (!this.mainPlayerName.equals("")) {
                            NBTTagCompound nbt = WorldDirectorMultiDim.getPlayerNBT(this.mainPlayerName);
                            nbt.func_74768_a("numOfWavesSpawned", nbt.func_74762_e("numOfWavesSpawned") + 1);
                        }
                        ++this.waveCount;
                    }
                } else {
                    HostileWorlds.dbg("max waves hit, ending invasion");
                    this.invasionEnd();
                }
            }
        }
    }

    @Override
    public void onFirstDetectNoActiveInvaders() {
        super.onFirstDetectNoActiveInvaders();
        this.curCooldown = ModConfigFields.coolDownBetweenWaves;
    }
}

