/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.ai;

import CoroUtil.util.CoroUtilBlock;
import hostileworlds.HostileWorlds;
import hostileworlds.config.ModConfigFields;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class AreaConverter {
    public int dimID;
    public ChunkCoordinates sourceCoord;
    public boolean convertActive;
    public int convertRangeMax = 15;
    public int convertCache;
    public Block convertBlock = (Block)Block.field_149771_c.func_82594_a(ModConfigFields.areaConverterReplaceBlocksWith);
    public int failTryCount = 0;
    public int failTryCountMax = 80;
    public int curRange = 5;
    public int curRangeInc = 5;
    public World world;

    public AreaConverter(World parWorld, ChunkCoordinates parSource) {
        this.world = parWorld;
        this.sourceCoord = parSource;
    }

    public AreaConverter(World parWorld, NBTTagCompound par1NBTTagCompound) {
        this.world = parWorld;
        this.readFromNBT(par1NBTTagCompound);
    }

    public void start() {
        this.convertActive = true;
    }

    public void stop() {
        this.convertActive = false;
    }

    public void onTick() {
        if (this.world == null) {
            this.world = DimensionManager.getWorld((int)this.dimID);
        }
        if (this.world == null) {
            return;
        }
        this.failTryCountMax = 80;
        for (int i = 0; i < 1; ++i) {
            int topY;
            if (!this.convertActive || this.sourceCoord == null) continue;
            Random rand = new Random();
            int tryX = this.sourceCoord.field_71574_a + rand.nextInt(this.curRange) - rand.nextInt(this.curRange);
            int tryZ = this.sourceCoord.field_71573_c + rand.nextInt(this.curRange) - rand.nextInt(this.curRange);
            int tryY = this.sourceCoord.field_71572_b + rand.nextInt(this.curRange) - rand.nextInt(this.curRange);
            if (!(Math.sqrt(this.sourceCoord.func_71569_e(tryX, tryY, tryZ)) < (double)this.curRange)) continue;
            Block id = this.world.func_147439_a(tryX, tryY, tryZ);
            boolean fail = true;
            if (CoroUtilBlock.isAir((Block)id) && Math.abs((topY = this.world.func_72976_f(tryX, tryZ)) - this.sourceCoord.field_71572_b) < this.convertRangeMax) {
                tryY = this.world.func_72976_f(tryX, tryZ);
                id = this.world.func_147439_a(tryX, tryY, tryZ);
            }
            if (!CoroUtilBlock.isAir((Block)id) && id != this.convertBlock && id != HostileWorlds.blockBloodyCobblestone && id.func_149688_o().func_76220_a() && this.world.func_147438_o(tryX, tryY, tryZ) == null && id.func_149688_o().func_76220_a()) {
                fail = false;
                this.world.func_147449_b(tryX, tryY, tryZ, this.convertBlock);
            }
            this.failTryCount = fail ? ++this.failTryCount : 0;
            if (this.failTryCount <= this.failTryCountMax) continue;
            this.failTryCount = 0;
            if (this.curRange < this.convertRangeMax) {
                this.curRange += this.curRangeInc;
                continue;
            }
            this.stop();
        }
    }

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        try {
            this.curRange = par1NBTTagCompound.func_74762_e("curRange");
            this.convertActive = par1NBTTagCompound.func_74767_n("convertActive");
            this.sourceCoord = new ChunkCoordinates(par1NBTTagCompound.func_74762_e("coordX"), par1NBTTagCompound.func_74762_e("coordY"), par1NBTTagCompound.func_74762_e("coordZ"));
            if (this.sourceCoord.field_71572_b == 0) {
                this.sourceCoord = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        try {
            par1NBTTagCompound.func_74768_a("curRange", this.curRange);
            par1NBTTagCompound.func_74757_a("convertActive", this.convertActive);
            if (this.sourceCoord != null) {
                par1NBTTagCompound.func_74768_a("coordX", this.sourceCoord.field_71574_a);
                par1NBTTagCompound.func_74768_a("coordY", this.sourceCoord.field_71572_b);
                par1NBTTagCompound.func_74768_a("coordZ", this.sourceCoord.field_71573_c);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

