/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds;

import CoroUtil.IChunkLoader;
import CoroUtil.util.CoroUtilFile;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import hostileworlds.CommonProxy;
import hostileworlds.EventHandlerFML;
import hostileworlds.EventHandlerPacket;
import hostileworlds.HWEventHandler;
import hostileworlds.ai.WorldDirectorMultiDim;
import hostileworlds.commands.CommandHW;
import hostileworlds.config.ModConfigFields;
import hostileworlds.dimension.HWDimensionManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import modconfig.ConfigMod;
import modconfig.IConfigCategory;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="HostileWorlds", name="Hostile Worlds", version="0.5.0", useMetadata=false)
public class HostileWorlds {
    @Mod.Instance(value="HostileWorlds")
    public static HostileWorlds instance;
    public static String modID;
    @SidedProxy(clientSide="hostileworlds.ClientProxy", serverSide="hostileworlds.CommonProxy")
    public static CommonProxy proxy;
    public static Block blockAuraCurse;
    public static Block blockSourceInvasion;
    public static Block blockBloodyCobblestone;
    public static Block blockSourceStructure;
    public static List<Block> blocksList;
    public static int texBloodCobble;
    public static boolean initProperNeededForWorld;
    public static String eventChannelName;
    public static final FMLEventChannel eventChannel;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (String)"hw", (IConfigCategory)new ModConfigFields());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        eventChannel.register((Object)new EventHandlerPacket());
        MinecraftForge.EVENT_BUS.register((Object)new HWEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new EventHandlerFML());
        proxy.init(this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new PortalChunkloadCallback());
    }

    public HostileWorlds() {
        boolean hm = false;
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
        ((ServerCommandManager)FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D()).func_71560_a((ICommand)new CommandHW());
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        HostileWorlds.writeGameNBT();
        initProperNeededForWorld = true;
    }

    public static void initTry() {
        if (initProperNeededForWorld) {
            initProperNeededForWorld = false;
            CoroUtilFile.getWorldFolderName();
            HWDimensionManager.loadAndRegisterDimensions();
        }
    }

    public static void writeGameNBT() {
        if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
            return;
        }
        HostileWorlds.dbg("Saving Hostile Worlds data");
        NBTTagCompound gameData = new NBTTagCompound();
        try {
            HWDimensionManager.writeNBT(gameData);
            String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName();
            FileOutputStream fos = new FileOutputStream(saveFolder + "HostileWorlds.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)gameData, (OutputStream)fos);
            fos.close();
            WorldDirectorMultiDim.writeAllPlayerNBT();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void readGameNBT() {
        HostileWorlds.dbg("Reading Hostile Worlds data");
        NBTTagCompound gameData = null;
        HWDimensionManager.registeredDimensions.clear();
        try {
            String saveFolder = CoroUtilFile.getWorldSaveFolderPath() + CoroUtilFile.getWorldFolderName();
            if (new File(saveFolder + "HostileWorlds.dat").exists()) {
                gameData = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(saveFolder + "HostileWorlds.dat"));
                HWDimensionManager.readNBT(gameData);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void writeChunkCoords(String prefix, ChunkCoordinates coords, NBTTagCompound nbt) {
        nbt.func_74768_a(prefix + "X", coords.field_71574_a);
        nbt.func_74768_a(prefix + "Y", coords.field_71572_b);
        nbt.func_74768_a(prefix + "Z", coords.field_71573_c);
    }

    public static ChunkCoordinates readChunkCoords(String prefix, NBTTagCompound nbt) {
        return new ChunkCoordinates(nbt.func_74762_e(prefix + "X"), nbt.func_74762_e(prefix + "Y"), nbt.func_74762_e(prefix + "Z"));
    }

    public static void dbg(Object obj) {
        if (ModConfigFields.debugConsoleOutput) {
            System.out.println(obj);
        }
    }

    static {
        modID = "hostileworlds";
        blocksList = new ArrayList<Block>();
        initProperNeededForWorld = true;
        eventChannelName = "hostileworlds";
        eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(eventChannelName);
    }

    public class PortalChunkloadCallback
    implements ForgeChunkManager.OrderedLoadingCallback {
        public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                Entity ent = ticket.getEntity();
                if (ent == null) {
                    TileEntity te;
                    int portalX = ticket.getModData().func_74762_e("portalX");
                    int portalY = ticket.getModData().func_74762_e("portalY");
                    int portalZ = ticket.getModData().func_74762_e("portalZ");
                    if (portalY < 0 || !((te = world.func_147438_o(portalX, portalY, portalZ)) instanceof IChunkLoader)) continue;
                    ((IChunkLoader)te).setChunkTicket(ticket);
                    ((IChunkLoader)te).forceChunkLoading(portalX / 16, portalZ / 16);
                    continue;
                }
                if (!(ent instanceof IChunkLoader)) continue;
                HostileWorlds.dbg("world load readd IChunkLoader chunkloader");
                ((IChunkLoader)ent).setChunkTicket(ticket);
                ((IChunkLoader)ent).forceChunkLoading(ent.field_70176_ah, ent.field_70164_aj);
            }
        }

        public List<ForgeChunkManager.Ticket> ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world, int maxTicketCount) {
            ArrayList validTickets = Lists.newArrayList();
            for (ForgeChunkManager.Ticket ticket : tickets) {
                Entity ent = ticket.getEntity();
                if (ent == null) {
                    int portalZ;
                    int portalY;
                    int portalX = ticket.getModData().func_74762_e("portalX");
                    TileEntity te = world.func_147438_o(portalX, portalY = ticket.getModData().func_74762_e("portalY"), portalZ = ticket.getModData().func_74762_e("portalZ"));
                    if (!(te instanceof IChunkLoader)) continue;
                    validTickets.add(ticket);
                    continue;
                }
                if (!(ent instanceof IChunkLoader)) continue;
                validTickets.add(ticket);
            }
            return validTickets;
        }
    }
}

