/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.entity.monster;

import CoroUtil.IChunkLoader;
import CoroUtil.componentAI.jobSystem.JobBase;
import hostileworlds.HostileWorlds;
import hostileworlds.ai.jobs.JobHunt;
import hostileworlds.ai.jobs.JobPathDigger;
import hostileworlds.entity.EntityInvader;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ZombieMiner
extends EntityInvader
implements IChunkLoader {
    public ForgeChunkManager.Ticket ticket = null;

    public ZombieMiner(World par1World) {
        super(par1World);
        this.agent.jobMan.addPrimaryJob((JobBase)new JobPathDigger(this.agent.jobMan));
        this.agent.jobMan.addJob((JobBase)new JobHunt(this.agent.jobMan));
        this.func_70062_b(0, new ItemStack(Items.field_151035_b));
        this.func_70062_b(4, new ItemStack((Item)Items.field_151028_Y));
        this.agent.shouldFixBadYPathing = false;
        this.field_70144_Y = 1.0f;
        this.agent.collideResistClose = 1.0f;
        this.agent.collideResistPathing = 1.0f;
        this.func_110163_bv();
    }

    @Override
    public void func_70619_bc() {
        super.func_70619_bc();
        if (this.ticket == null) {
            System.out.println("zombie miner init request ticket");
            this.requestTicket();
            this.forceChunkLoading(this.field_70176_ah, this.field_70164_aj);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
    }

    public void setChunkTicket(ForgeChunkManager.Ticket parTicket) {
        if (this.ticket != null && parTicket != this.ticket) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        }
        this.ticket = parTicket;
    }

    public void forceChunkLoading(int chunkX, int chunkZ) {
        if (this.ticket == null) {
            return;
        }
        Set chunks = this.getChunksAround(chunkX, chunkZ, 3);
        for (ChunkCoordIntPair chunk : chunks) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)chunk);
        }
        ChunkCoordIntPair myChunk = new ChunkCoordIntPair(chunkX, chunkZ);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)myChunk);
        ForgeChunkManager.reorderChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)myChunk);
    }

    public Set getChunksAround(int xChunk, int zChunk, int radius) {
        HashSet<ChunkCoordIntPair> chunkList = new HashSet<ChunkCoordIntPair>();
        for (int xx = xChunk - radius; xx <= xChunk + radius; ++xx) {
            for (int zz = zChunk - radius; zz <= zChunk + radius; ++zz) {
                chunkList.add(new ChunkCoordIntPair(xx, zz));
            }
        }
        return chunkList;
    }

    public void requestTicket() {
        ForgeChunkManager.Ticket chunkTicket = ForgeChunkManager.requestTicket((Object)HostileWorlds.instance, (World)this.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
        if (chunkTicket != null) {
            chunkTicket.getModData();
            chunkTicket.setChunkListDepth(12);
            chunkTicket.bindEntity((Entity)this);
            this.setChunkTicket(chunkTicket);
        }
    }
}

