/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.entity;

import CoroUtil.quest.PlayerQuestManager;
import CoroUtil.quest.PlayerQuests;
import CoroUtil.quest.quests.ActiveQuest;
import CoroUtil.util.CoroUtilBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hostileworlds.HostileWorlds;
import hostileworlds.ai.WorldDirectorMultiDim;
import hostileworlds.ai.invasion.WorldEvent;
import hostileworlds.block.TileEntitySourceInvasion;
import hostileworlds.entity.MovingBlock;
import hostileworlds.entity.particle.EntityMeteorTrailFX;
import hostileworlds.quest.InvasionSourceBreakEvent;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityMeteorite
extends Entity {
    private int xTileSnowball = -1;
    private int yTileSnowball = -1;
    private int zTileSnowball = -1;
    private Block inTileSnowball;
    private boolean inGroundSnowball = false;
    public int shakeSnowball = 0;
    private EntityLivingBase shootingEntity;
    private int ticksInGroundSnowball;
    private int ticksInAirSnowball = 0;
    public int age = 0;
    public int ticksDying = 0;
    public boolean dying = false;
    public ChunkCoordinates crashDestination = null;
    public WorldEvent invasion = null;

    public EntityMeteorite(World var1) {
        super(var1);
        this.func_70105_a(0.25f, 0.25f);
    }

    public EntityMeteorite(World var1, ChunkCoordinates parDest, WorldEvent parInvasion) {
        super(var1);
        this.func_70105_a(0.25f, 0.25f);
        this.crashDestination = parDest;
        this.invasion = parInvasion;
    }

    protected void func_70088_a() {
    }

    public void updateTargetCoord() {
        if (this.crashDestination == null) {
            HostileWorlds.dbg("crashDestination is null for meteor: " + this.func_145782_y());
            return;
        }
        float speed = 1.5f + (float)this.age * 0.005f;
        double vecX = (double)this.crashDestination.field_71574_a - this.field_70165_t;
        double vecY = (double)this.crashDestination.field_71572_b - this.field_70163_u;
        double vecZ = (double)this.crashDestination.field_71573_c - this.field_70161_v;
        double var9 = MathHelper.func_76133_a((double)(vecX * vecX + vecY * vecY + vecZ * vecZ));
        this.field_70159_w = vecX / var9 * (double)speed;
        this.field_70181_x = vecY / var9 * (double)speed;
        this.field_70179_y = vecZ / var9 * (double)speed;
    }

    public void setHeading(double var1, double var3, double var5, float var7) {
        float var9 = MathHelper.func_76133_a((double)(var1 * var1 + var3 * var3 + var5 * var5));
        var1 /= (double)var9;
        var3 /= (double)var9;
        var5 /= (double)var9;
        this.field_70159_w = var1 *= (double)var7;
        this.field_70181_x = var3 *= (double)var7;
        this.field_70179_y = var5 *= (double)var7;
        float var10 = MathHelper.func_76133_a((double)(var1 * var1 + var5 * var5));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(var1, var5) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(var3, var10) * 180.0 / Math.PI);
        this.ticksInGroundSnowball = 0;
    }

    public void func_70016_h(double var1, double var3, double var5) {
        this.field_70159_w = var1;
        this.field_70181_x = var3;
        this.field_70179_y = var5;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var7 = MathHelper.func_76133_a((double)(var1 * var1 + var5 * var5));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(var1, var5) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(var3, var7) * 180.0 / Math.PI);
        }
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        ++this.age;
        if (this.field_70170_p.field_72995_K) {
            this.spawnParticles();
        }
        if (this.shakeSnowball > 0) {
            --this.shakeSnowball;
        }
        if (this.inGroundSnowball) {
            Block var1 = this.field_70170_p.func_147439_a(this.xTileSnowball, this.yTileSnowball, this.zTileSnowball);
            if (var1 == this.inTileSnowball) {
                ++this.ticksInGroundSnowball;
                if (this.ticksInGroundSnowball == 1200) {
                    this.func_70106_y();
                }
                return;
            }
            this.inGroundSnowball = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.ticksInGroundSnowball = 0;
            this.ticksInAirSnowball = 0;
        } else {
            ++this.ticksInAirSnowball;
        }
        Vec3 var15 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        Vec3 var2 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        MovingObjectPosition var3 = this.field_70170_p.func_72933_a(var15, var2);
        var15 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
        var2 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
        if (var3 != null) {
            var2 = Vec3.func_72443_a((double)var3.field_72307_f.field_72450_a, (double)var3.field_72307_f.field_72448_b, (double)var3.field_72307_f.field_72449_c);
            if (this.field_70170_p.func_147439_a((int)var3.field_72307_f.field_72450_a, (int)var3.field_72307_f.field_72448_b, (int)var3.field_72307_f.field_72449_c) == Blocks.field_150395_bd) {
                this.field_70170_p.func_147449_b((int)var3.field_72307_f.field_72450_a, (int)var3.field_72307_f.field_72448_b, (int)var3.field_72307_f.field_72449_c, Blocks.field_150350_a);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            Entity var4 = null;
            List var5 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double var6 = 0.0;
            for (int var8 = 0; var8 < var5.size(); ++var8) {
                double var13;
                float var10;
                AxisAlignedBB var11;
                MovingObjectPosition var12;
                Entity var9 = (Entity)var5.get(var8);
                if (!var9.func_70067_L() || var9 == this.shootingEntity && this.ticksInAirSnowball < 5 || (var12 = (var11 = var9.field_70121_D.func_72314_b((double)(var10 = 0.3f), (double)var10, (double)var10)).func_72327_a(var15, var2)) == null || !((var13 = var15.func_72438_d(var12.field_72307_f)) < var6) && var6 != 0.0) continue;
                var4 = var9;
                var6 = var13;
            }
            if (var4 != null) {
                var3 = new MovingObjectPosition(var4);
            }
        }
        if (var3 == null || var3.field_72308_g == null || var3.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.shootingEntity), 0.0f)) {
            // empty if block
        }
        float var18 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var18) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float drag = 0.99f;
        float gravity = 0.07f;
        if (this.func_70090_H()) {
            for (int var7 = 0; var7 < 4; ++var7) {
                float var20 = 0.25f;
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)var20, this.field_70163_u - this.field_70181_x * (double)var20, this.field_70161_v - this.field_70179_y * (double)var20, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            drag = 0.8f;
        }
        if (this.ticksDying <= 3) {
            if (!this.field_70170_p.field_72995_K) {
                this.updateTargetCoord();
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            this.field_70159_w *= (double)drag;
            this.field_70181_x *= (double)drag;
            this.field_70179_y *= (double)drag;
            this.field_70181_x -= (double)gravity;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            if (!this.dying) {
                HostileWorlds.eventChannel.sendToDimension(WorldDirectorMultiDim.getMeteorPacket(this, 1), this.field_71093_bK);
            }
            this.onTickExplode();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!this.dying && Math.abs((double)this.crashDestination.field_71572_b - this.field_70163_u) < 3.0) {
                System.out.println("METEOR DEATH BEGIN, killing on client side");
                HostileWorlds.eventChannel.sendToDimension(WorldDirectorMultiDim.getMeteorPacket(this, 2), this.field_71093_bK);
                this.dying = true;
            }
            if (this.dying) {
                ++this.ticksDying;
                if (this.ticksDying > 60) {
                    int y = (int)this.field_70163_u;
                    boolean keepTry = true;
                    while (keepTry) {
                        Block id = this.field_70170_p.func_147439_a((int)this.field_70165_t, y, (int)this.field_70161_v);
                        if (!CoroUtilBlock.isAir((Block)id) && id.func_149688_o().func_76220_a()) {
                            keepTry = false;
                        }
                        if (--y > 0) continue;
                        keepTry = false;
                    }
                    ++y;
                    int topY = EntityMeteorite.genBuilding(this.field_70170_p, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(y += 8)), MathHelper.func_76128_c((double)this.field_70161_v), 22);
                    this.updateInvasionInfo(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)y) + 1 + topY, MathHelper.func_76128_c((double)this.field_70161_v));
                    this.func_70106_y();
                }
            }
        }
    }

    public static int genBuilding(World worldObj, int xx, int yy, int zz, int origSize) {
        int i;
        Block id = HostileWorlds.blockBloodyCobblestone;
        int portalBorderRadius = TileEntitySourceInvasion.portalBorderRadius;
        int startX = 0;
        int startZ = 0;
        int x = 0;
        int y = 0;
        int z = 0;
        int size = origSize;
        for (y = 0; y < 50; ++y) {
            for (x = startX; x <= size; ++x) {
                for (z = startZ; z <= size; ++z) {
                    worldObj.func_147449_b(xx + x - origSize / 2, yy + y, zz + z - origSize / 2, HostileWorlds.blockBloodyCobblestone);
                }
            }
            ++startZ;
            if (--size - ++startX < 5) break;
        }
        for (i = -portalBorderRadius; i <= portalBorderRadius; ++i) {
            worldObj.func_147449_b(xx - portalBorderRadius, yy + y + TileEntitySourceInvasion.portalHeight, zz + i, id);
            worldObj.func_147449_b(xx + portalBorderRadius, yy + y + TileEntitySourceInvasion.portalHeight, zz + i, id);
        }
        for (i = -portalBorderRadius + 1; i <= portalBorderRadius - 1; ++i) {
            worldObj.func_147449_b(xx + i, yy + y + TileEntitySourceInvasion.portalHeight, zz - portalBorderRadius, id);
            worldObj.func_147449_b(xx + i, yy + y + TileEntitySourceInvasion.portalHeight, zz + portalBorderRadius, id);
        }
        for (i = 0; i < TileEntitySourceInvasion.portalHeight; ++i) {
            worldObj.func_147449_b(xx - portalBorderRadius, yy + y + i, zz - portalBorderRadius, id);
            worldObj.func_147449_b(xx + portalBorderRadius, yy + y + i, zz - portalBorderRadius, id);
            worldObj.func_147449_b(xx - portalBorderRadius, yy + y + i, zz + portalBorderRadius, id);
            worldObj.func_147449_b(xx + portalBorderRadius, yy + y + i, zz + portalBorderRadius, id);
        }
        id = HostileWorlds.blockSourceInvasion;
        worldObj.func_147465_d(xx, yy + y + 1, zz, id, 0, 2);
        HostileWorlds.dbg("CREATED PORTAL AT " + xx + ", " + yy + ", " + zz);
        return y;
    }

    public void updateInvasionInfo(int x, int y, int z) {
        try {
            TileEntitySourceInvasion tEnt = (TileEntitySourceInvasion)this.field_70170_p.func_147438_o(x, y, z);
            if (tEnt != null) {
                this.invasion.coordSource = new ChunkCoordinates(tEnt.field_145851_c, tEnt.field_145848_d, tEnt.field_145849_e);
                WorldDirectorMultiDim.coordInvasionSources.get(this.field_71093_bK).add(this.invasion.coordSource);
            }
            PlayerQuests plQuests = PlayerQuestManager.i().getPlayerQuests(this.invasion.mainPlayerName);
            InvasionSourceBreakEvent aq = new InvasionSourceBreakEvent();
            if (aq != null) {
                aq.initCreateObject(plQuests);
                aq.initFirstTime(this.field_70170_p.field_73011_w.field_76574_g);
                aq.initCustomData(this.invasion.coordSource, HostileWorlds.blockSourceInvasion);
                plQuests.questAdd((ActiveQuest)aq);
                plQuests.saveAndSyncPlayer();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void onTickExplode() {
        int radius = 6;
        int xx = (int)this.field_70165_t - radius;
        while ((double)xx <= this.field_70165_t + (double)radius) {
            int yy = (int)this.field_70163_u - radius;
            while ((double)yy <= this.field_70163_u + (double)radius) {
                int zz = (int)this.field_70161_v - radius;
                while ((double)zz <= this.field_70161_v + (double)radius) {
                    Block id = this.field_70170_p.func_147439_a(xx, yy, zz);
                    if (!CoroUtilBlock.isAir((Block)id) && id != Blocks.field_150357_h && this.field_70170_p.func_147438_o(xx, yy, zz) == null && id.func_149688_o() != Material.field_151586_h && !this.field_70170_p.field_72995_K && this.func_70011_f((double)xx + 0.5, (double)yy + 0.5, (double)zz + 0.5) <= (double)(radius - 2)) {
                        this.field_70170_p.func_147449_b(xx, yy, zz, Blocks.field_150350_a);
                        if (this.field_70170_p.func_72890_a((Entity)this, 256.0) != null && this.field_70170_p.field_73012_v.nextInt(5) == 0) {
                            MovingBlock mb = new MovingBlock(this.field_70170_p, id, this.field_70170_p.func_72805_g(xx, yy, zz));
                            mb.func_70107_b((float)xx + 0.5f, (float)yy + 0.5f, (float)zz + 0.5f);
                            mb.field_70181_x = 1.0;
                            float speed = 0.5f;
                            mb.field_70159_w = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * speed;
                            mb.field_70179_y = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * speed;
                            this.field_70170_p.func_72838_d((Entity)mb);
                        }
                        if (this.field_70170_p.field_73012_v.nextInt(10) == 0 && this.field_70170_p.func_147439_a(xx, yy - 1, zz).func_149688_o().func_76220_a()) {
                            this.field_70170_p.func_147449_b(xx, yy, zz, (Block)Blocks.field_150480_ab);
                        }
                    }
                    ++zz;
                }
                ++yy;
            }
            ++xx;
        }
    }

    public void func_70106_y() {
        if (this.field_70128_L || !this.field_70170_p.field_72995_K) {
            // empty if block
        }
        super.func_70106_y();
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnExplodeParticles() {
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticles() {
        for (int i = 0; i < 10; ++i) {
            float speed = 0.1f;
            float randPos = 8.0f;
            float ahead = 2.5f;
            EntityMeteorTrailFX particle = new EntityMeteorTrailFX(this.field_70170_p, this.field_70165_t + this.field_70159_w * (double)ahead + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * randPos), this.field_70163_u + this.field_70181_x * (double)ahead + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * randPos), this.field_70161_v + this.field_70179_y * (double)ahead + (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * randPos), this.field_70159_w, 0.25, this.field_70179_y, 0.0f, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            particle.field_70159_w = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * speed;
            particle.field_70181_x = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.1f;
            particle.field_70179_y = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * speed;
            particle.spawnAsWeatherEffect();
        }
    }

    public void func_70014_b(NBTTagCompound var1) {
        var1.func_74777_a("xTile", (short)this.xTileSnowball);
        var1.func_74777_a("yTile", (short)this.yTileSnowball);
        var1.func_74777_a("zTile", (short)this.zTileSnowball);
        var1.func_74774_a("shake", (byte)this.shakeSnowball);
        var1.func_74774_a("inGround", (byte)(this.inGroundSnowball ? 1 : 0));
    }

    public void func_70037_a(NBTTagCompound var1) {
        this.xTileSnowball = var1.func_74765_d("xTile");
        this.yTileSnowball = var1.func_74765_d("yTile");
        this.zTileSnowball = var1.func_74765_d("zTile");
        this.shakeSnowball = var1.func_74771_c("shake") & 0xFF;
        this.inGroundSnowball = var1.func_74771_c("inGround") == 1;
    }

    public void func_70100_b_(EntityPlayer var1) {
        if (this.inGroundSnowball && this.shootingEntity == var1 && this.shakeSnowball <= 0 && var1.field_71071_by.func_70441_a(new ItemStack(Items.field_151032_g, 1))) {
            this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            var1.func_71001_a((Entity)this, 1);
            this.func_70106_y();
        }
    }

    public float func_70053_R() {
        return 0.0f;
    }

    public boolean func_145770_h(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return true;
    }
}

