/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.dimension;

import hostileworlds.HostileWorlds;
import hostileworlds.ServerTickHandler;
import hostileworlds.ai.CursedAreaCoordinates;
import hostileworlds.ai.WorldDirectorMultiDim;
import hostileworlds.ai.invasion.WorldEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.DimensionManager;

public class HWDimensionManager {
    public static HWDimensionManager instance;
    public static List<Integer> registeredDimensions;

    public HWDimensionManager() {
        if (instance != null) {
            System.out.println("Duplicate HWDimensionManager() creation detected");
        }
        instance = this;
    }

    public static void unregisterDimension(int id) {
        DimensionManager.unregisterDimension((int)id);
    }

    public static void loadAndRegisterDimensions() {
        ServerTickHandler.wd.resetDimData();
        HostileWorlds.instance.readGameNBT();
    }

    public static void readNBT(NBTTagCompound data) {
        NBTTagCompound playerData = data.func_74775_l("registeredDimensions");
        for (String tagName : playerData.func_150296_c()) {
            NBTTagCompound dimData = playerData.func_74775_l(tagName);
            int dim = dimData.func_74762_e("dimID");
            HWDimensionManager.readDimension(dim, dimData);
        }
    }

    public static void writeNBT(NBTTagCompound data) {
        NBTTagCompound dimList = new NBTTagCompound();
        NBTTagCompound dimData = new NBTTagCompound();
        HWDimensionManager.writeDimension(0, dimData);
        dimList.func_74782_a("dim_0", (NBTBase)dimData);
        data.func_74782_a("registeredDimensions", (NBTBase)dimList);
    }

    public static void readDimension(int dimID, NBTTagCompound dimData) {
        NBTTagCompound data;
        if (ServerTickHandler.wd == null) {
            ServerTickHandler.wd = new WorldDirectorMultiDim();
        }
        WorldDirectorMultiDim.initDimData(dimID);
        NBTTagCompound listData = dimData.func_74775_l("invasionData");
        for (String tagName : listData.func_150296_c()) {
            data = listData.func_74775_l(tagName);
            WorldEvent invasion = WorldEvent.newInvasionFromNBT(data);
            HostileWorlds.dbg("starting loaded invasion: " + (Object)((Object)invasion.type) + " - player name: " + invasion.mainPlayerName);
            WorldDirectorMultiDim.curInvasions.get(dimID).add(invasion);
        }
        listData = dimData.func_74775_l("curseData");
        for (String tagName : listData.func_150296_c()) {
            data = listData.func_74775_l(tagName);
            CursedAreaCoordinates curse = new CursedAreaCoordinates();
            curse.readNBT(data);
            WorldDirectorMultiDim.coordCurses.get(dimID).add(curse);
        }
        listData = dimData.func_74775_l("surfaceCaves");
        for (String tagName : listData.func_150296_c()) {
            data = listData.func_74775_l(tagName);
            WorldDirectorMultiDim.coordSurfaceCaves.get(dimID).add(HostileWorlds.readChunkCoords("coord", data));
        }
        listData = dimData.func_74775_l("caves");
        for (String tagName : listData.func_150296_c()) {
            data = listData.func_74775_l(tagName);
            WorldDirectorMultiDim.coordCaves.get(dimID).add(HostileWorlds.readChunkCoords("coord", data));
        }
        listData = dimData.func_74775_l("invasionSources");
        for (String tagName : listData.func_150296_c()) {
            data = listData.func_74775_l(tagName);
            WorldDirectorMultiDim.coordInvasionSources.get(dimID).add(HostileWorlds.readChunkCoords("coord", data));
        }
        HostileWorlds.dbg("dim: " + dimID + " - LOADED coordInvasionSources size: " + WorldDirectorMultiDim.coordInvasionSources.get(dimID).size());
    }

    public static void writeDimension(int dimID, NBTTagCompound dimData) {
        if (WorldDirectorMultiDim.curInvasions.get(dimID) == null) {
            return;
        }
        NBTTagCompound invasionList = new NBTTagCompound();
        for (int j = 0; j < WorldDirectorMultiDim.curInvasions.get(dimID).size(); ++j) {
            WorldEvent invasion = WorldDirectorMultiDim.curInvasions.get(dimID).get(j);
            NBTTagCompound invasionData = new NBTTagCompound();
            invasion.writeNBT(invasionData);
            invasionList.func_74782_a("invasion_" + j, (NBTBase)invasionData);
        }
        NBTTagCompound curseList = new NBTTagCompound();
        for (int j = 0; j < WorldDirectorMultiDim.coordCurses.get(dimID).size(); ++j) {
            CursedAreaCoordinates curse = WorldDirectorMultiDim.coordCurses.get(dimID).get(j);
            NBTTagCompound curseData = new NBTTagCompound();
            curse.writeNBT(curseData);
            curseList.func_74782_a("curse_" + j, (NBTBase)curseData);
        }
        NBTTagCompound surfaceCaveList = new NBTTagCompound();
        for (int j = 0; j < WorldDirectorMultiDim.coordSurfaceCaves.get(dimID).size(); ++j) {
            ChunkCoordinates coords = WorldDirectorMultiDim.coordSurfaceCaves.get(dimID).get(j);
            NBTTagCompound coordData = new NBTTagCompound();
            HostileWorlds.writeChunkCoords("coord", coords, coordData);
            surfaceCaveList.func_74782_a("surfaceCave_" + j, (NBTBase)coordData);
        }
        NBTTagCompound caveList = new NBTTagCompound();
        for (int j = 0; j < WorldDirectorMultiDim.coordCaves.get(dimID).size(); ++j) {
            ChunkCoordinates coords = WorldDirectorMultiDim.coordCaves.get(dimID).get(j);
            NBTTagCompound coordData = new NBTTagCompound();
            HostileWorlds.writeChunkCoords("coord", coords, coordData);
            caveList.func_74782_a("cave_" + j, (NBTBase)coordData);
        }
        NBTTagCompound invasionSourceList = new NBTTagCompound();
        for (int j = 0; j < WorldDirectorMultiDim.coordInvasionSources.get(dimID).size(); ++j) {
            ChunkCoordinates coords = WorldDirectorMultiDim.coordInvasionSources.get(dimID).get(j);
            NBTTagCompound coordData = new NBTTagCompound();
            HostileWorlds.writeChunkCoords("coord", coords, coordData);
            invasionSourceList.func_74782_a("invasionSource_" + j, (NBTBase)coordData);
        }
        dimData.func_74768_a("dimID", dimID);
        dimData.func_74782_a("invasionData", (NBTBase)invasionList);
        dimData.func_74782_a("curseData", (NBTBase)curseList);
        dimData.func_74782_a("surfaceCaves", (NBTBase)surfaceCaveList);
        dimData.func_74782_a("caves", (NBTBase)caveList);
        dimData.func_74782_a("invasionSources", (NBTBase)invasionSourceList);
    }

    static {
        registeredDimensions = new ArrayList<Integer>();
    }
}

