/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.block;

import CoroUtil.componentAI.ICoroAI;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hostileworlds.HostileWorlds;
import hostileworlds.ServerTickHandler;
import hostileworlds.ai.WorldDirectorMultiDim;
import hostileworlds.client.sound.MovingSoundStreamingSource;
import hostileworlds.entity.monster.ZombieBlockWielder;
import hostileworlds.entity.particle.EntityAuraCurseFX;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityReddustFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;

public class TileEntitySourceInvasion
extends TileEntity {
    public long lastCoordCheckTime;
    public boolean invasionActive = false;
    public long invasionLastTime = 0L;
    public float difficultyFactor = 0.0f;
    public ArrayList<ICoroAI> invasionEntities = new ArrayList();
    public ArrayList<String> cursedPlayers = new ArrayList();
    public ArrayList<EntityAuraCurseFX> particles = new ArrayList();
    public boolean hasSpawnedBoss1 = false;
    public boolean hasSpawnedBoss2 = false;
    public long lastPlayTime = 0L;
    @SideOnly(value=Side.CLIENT)
    public MovingSoundStreamingSource sound;
    public static int portalHeight = 5;
    public static int portalBorderRadius = 2;

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.herp();
            this.tickSound();
        } else {
            EntityPlayer player;
            if (!this.invasionActive || this.field_145850_b.func_72820_D() % 100L == 0L) {
                // empty if block
            }
            if (this.field_145850_b.func_72820_D() % 60L == 0L && !this.hasSpawnedBoss1 && (player = this.func_145831_w().func_72977_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0)) != null) {
                ZombieBlockWielder boss = new ZombieBlockWielder(this.field_145850_b);
                boss.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5);
                boss.agent.homeX = this.field_145851_c;
                boss.agent.homeY = this.field_145848_d + 1;
                boss.agent.homeZ = this.field_145849_e;
                this.field_145850_b.func_72838_d((Entity)boss);
                this.hasSpawnedBoss1 = true;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void tickSound() {
        float range = 120.0f;
        EntityPlayer player = this.field_145850_b.func_72977_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)range);
        if (player != null) {
            this.lastPlayTime = System.currentTimeMillis() + 43000L + 2000L;
            this.playNonMovingSound(Vec3.func_72443_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e), HostileWorlds.modID + ":bossfight", 1.0f, 1.0f, range);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void playNonMovingSound(Vec3 parPos, String var1, float var5, float var6, float parCutOffRange) {
        if (this.sound == null) {
            System.out.println("PLAY!!!!!!!!!!!!!!!!!!!!!");
            ResourceLocation res = new ResourceLocation(var1);
            this.sound = new MovingSoundStreamingSource(parPos, res, var5, var6, parCutOffRange);
            FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void stopSound() {
        if (this.sound != null) {
            this.sound.stopPlaying();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.stopSound();
        }
    }

    public void registerWithInvasion(ICoroAI ent) {
        System.out.println("ent registered with invasion: " + ent);
        this.invasionEntities.add(ent);
    }

    public void watchActiveInvaders() {
        for (int i = 0; i < this.invasionEntities.size(); ++i) {
            ICoroAI ent = this.invasionEntities.get(i);
            if (!ent.getAIAgent().ent.field_70128_L) continue;
            this.invasionEntities.remove(i);
        }
        if (this.invasionEntities.size() == 0) {
            this.invasionEnd();
        }
    }

    public void invasionStart() {
        System.out.println("Invasion started for: " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e);
        this.invasionActive = true;
    }

    public void invasionEnd() {
        System.out.println("Invasion ended for: " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e);
        this.invasionActive = false;
        this.invasionLastTime = System.currentTimeMillis();
        this.cursedPlayers.clear();
    }

    public void checkCoordAdd() {
        if (this.lastCoordCheckTime < System.currentTimeMillis() && ServerTickHandler.wd != null) {
            this.lastCoordCheckTime = System.currentTimeMillis() + 30000L;
            boolean found = false;
            int i = 0;
            while (true) {
                if (i >= WorldDirectorMultiDim.coordCurses.get(this.field_145850_b.field_73011_w.field_76574_g).size()) break;
                ChunkCoordinates cc = WorldDirectorMultiDim.coordCurses.get(this.field_145850_b.field_73011_w.field_76574_g).get(i);
                if (cc.field_71574_a == this.field_145851_c && cc.field_71572_b == this.field_145848_d && cc.field_71573_c == this.field_145849_e) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                System.out.println("FIX CURSE COORD REGISTRATION - checkCoordAdd()");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void herp() {
        int y = 80;
        if (Minecraft.func_71410_x().field_71439_g.func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) < 256.0) {
            float look = this.field_145850_b.func_72820_D() * 10L;
            float speed = 0.5f;
            Random rand = new Random();
            double motionX = -Math.sin(look / 180.0f * (float)Math.PI) * Math.cos(0.0) * ((double)speed + 0.1 * rand.nextDouble());
            double motionZ = Math.cos(look / 180.0f * (float)Math.PI) * Math.cos(0.0) * ((double)speed + 0.1 * rand.nextDouble());
            EntityAuraCurseFX particle = new EntityAuraCurseFX(this.field_145850_b, (float)this.field_145851_c + 0.5f, y, (float)this.field_145849_e + 0.5f, motionX, 0.25, motionZ, 20.0f);
            this.particles.add(particle);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
            particle = new EntityAuraCurseFX(this.field_145850_b, (float)this.field_145851_c + 0.5f, y, (float)this.field_145849_e + 0.5f, -motionX, 0.25, -motionZ, 30.0f);
            this.particles.add(particle);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
        }
        if (Minecraft.func_71410_x().field_71439_g.func_70011_f((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) < 64.0) {
            for (int i = 0; i < 3; ++i) {
                Random rand = new Random();
                double range = 1.0;
                EntityReddustFX particle = new EntityReddustFX(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f) + rand.nextDouble() * range - rand.nextDouble() * range, (double)this.field_145848_d + rand.nextDouble() * range, (double)((float)this.field_145849_e + 0.5f) + rand.nextDouble() * range - rand.nextDouble() * range, 2.0f, rand.nextFloat(), 0.0f, 0.0f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
            }
        }
        for (int var9 = 0; var9 < this.particles.size(); ++var9) {
            int max;
            EntityAuraCurseFX particle = this.particles.get(var9);
            if (particle == null) continue;
            if (particle.field_70128_L) {
                this.particles.remove((Object)particle);
                continue;
            }
            float vecX = (float)this.field_145851_c + 0.5f - (float)particle.field_70165_t;
            float vecZ = (float)this.field_145849_e + 0.5f - (float)particle.field_70161_v;
            float dist = MathHelper.func_76133_a((double)(vecX * vecX + vecZ * vecZ));
            float speed = 0.08f;
            float angle = (float)(Math.atan2(vecZ, vecX) * 180.0 / 3.1415927410125732);
            float angleAdj = (float)Math.sin((float)particle.getParticleAge() % 100.0f / 20.0f) * 60.0f;
            if (angleAdj < (float)(-(max = 30))) {
                angleAdj = -max;
            }
            if (angleAdj > (float)max) {
                angleAdj = max;
            }
            float angleAdj2 = (float)Math.sin((float)this.field_145850_b.func_72820_D() % 50.0f / 20.0f) * 30.0f;
            float angleAdj3 = (float)Math.sin((float)this.field_145850_b.func_72820_D() % 200.0f / 20.0f) * 30.0f;
            float staticAngle = 10.0f;
            angle = particle.direction == 0 ? (angle += staticAngle + angleAdj2) : (angle -= staticAngle + (angleAdj2 += angleAdj + angleAdj3));
            double rad_angle = angle * 0.01745329f;
            float newX = (float)Math.cos(rad_angle);
            float newZ = (float)Math.sin(rad_angle);
            particle.field_70159_w += (double)(newX * speed);
            particle.field_70179_y += (double)(newZ * speed);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - portalBorderRadius), (double)this.field_145848_d, (double)(this.field_145849_e - portalBorderRadius), (double)(this.field_145851_c + 1 + portalBorderRadius), (double)(this.field_145848_d + portalHeight + 2), (double)(this.field_145849_e + 1 + portalBorderRadius));
    }

    public void func_145841_b(NBTTagCompound var1) {
        super.func_145841_b(var1);
        var1.func_74757_a("hasSpawnedBoss1", this.hasSpawnedBoss1);
        var1.func_74757_a("hasSpawnedBoss2", this.hasSpawnedBoss2);
    }

    public void func_145839_a(NBTTagCompound var1) {
        super.func_145839_a(var1);
        this.hasSpawnedBoss1 = var1.func_74767_n("hasSpawnedBoss1");
        this.hasSpawnedBoss2 = var1.func_74767_n("hasSpawnedBoss2");
    }
}

