/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.ai.jobs;

import CoroUtil.OldUtil;
import CoroUtil.componentAI.jobSystem.JobManager;
import CoroUtil.entity.EnumJobState;
import CoroUtil.pathfinding.PFQueue;
import CoroUtil.util.CoroUtilBlock;
import hostileworlds.HostileWorlds;
import hostileworlds.ai.jobs.JobGroupHorde;
import hostileworlds.entity.monster.ZombieMiner;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class JobPathDigger
extends JobGroupHorde {
    public int pfReturnTimeout = 0;
    public boolean waitingForPath = false;
    public boolean waitingForThreadPath = false;
    public PathEntity pathReturned = null;
    public boolean tryPathToTarget = true;
    public boolean hasPathToTarget = false;
    public int simuDigCount;
    public int simuDigCooldownCur = 0;
    public int simuDigCooldownMax = 40;
    public ChunkCoordinates lastMinedCoord = null;
    public EnumJobState digState = EnumJobState.IDLE;
    public ChunkCoordinates bestDigCoord = null;
    public float curBlockDamage;
    public float tickBlockDamage = 0.1f;
    public int seesSkyTicks = 0;
    public int noMoveTicks = 0;
    public int noDigTicks = 0;
    public int noDigTicksMax = 300;
    public float yDiffMax = 2.0f;

    public JobPathDigger(JobManager jm) {
        super(jm);
    }

    @Override
    public boolean shouldExecute() {
        return true;
    }

    @Override
    public boolean shouldContinue() {
        return this.hasPathToTarget;
    }

    public void onIdleTickAct() {
    }

    public void dbg(Object par) {
        HostileWorlds.dbg(par);
    }

    @Override
    public void tick() {
        boolean tryDoorBreak;
        boolean doMineTick;
        block100: {
            block99: {
                doMineTick = false;
                tryDoorBreak = false;
                boolean doDoorBreak = false;
                try {
                    if (this.attackCoord != null && this.ent instanceof ZombieMiner && this.ent.field_70170_p.func_72820_D() % 60L == 0L) {
                        this.dbg("dim: " + this.ent.field_71093_bK + " miner cur dist: " + this.ent.func_70011_f((double)this.attackCoord.field_71574_a, (double)this.attackCoord.field_71572_b, (double)this.attackCoord.field_71573_c));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (this.ent.field_70170_p.func_147439_a((int)this.ent.field_70165_t, (int)this.ent.field_70163_u - 1, (int)this.ent.field_70161_v) != HostileWorlds.blockBloodyCobblestone) {
                    // empty if block
                }
                if (this.ent.func_70090_H()) {
                    this.ent.field_70181_x += (double)0.05f;
                    if (Math.sqrt(this.ent.field_70159_w * this.ent.field_70159_w + this.ent.field_70179_y * this.ent.field_70179_y) < (double)0.1f) {
                        this.ent.func_70060_a(0.0f, 0.1f, 0.1f);
                    }
                }
                if (this.state == EnumJobState.IDLE) break block99;
                if (this.state != EnumJobState.W1) break block100;
            }
            if (this.ent.field_70122_E && this.ent.field_70123_F) {
                OldUtil.jump((EntityLivingBase)this.ent);
            }
        }
        if (this.pfReturnTimeout > 0) {
            --this.pfReturnTimeout;
        } else if (this.waitingForPath) {
            this.waitingForPath = false;
        }
        this.checkCoord();
        if (((JobGroupHorde)this.jm.getPrimaryJob()).attackCoord == null) {
            return;
        }
        ChunkCoordinates attackCoord = ((JobGroupHorde)this.jm.getPrimaryJob()).attackCoord;
        if (this.state == EnumJobState.IDLE) {
            if (!this.hasPathToTarget) {
                if (!this.waitingForPath) {
                    if (this.tryPathToTarget) {
                        this.waitingForPath = true;
                        this.pathReturned = null;
                        this.pfReturnTimeout = 40;
                        this.dbg("requesting path test");
                        this.waitingForThreadPath = true;
                        PFQueue.getPath((Entity)this.ent, (int)attackCoord.field_71574_a, (int)attackCoord.field_71572_b, (int)attackCoord.field_71573_c, (float)512.0f, (int)-1);
                    }
                } else if (!this.waitingForThreadPath) {
                    if (this.pathReturned != null) {
                        float dist = (float)Math.sqrt(attackCoord.func_71569_e(this.pathReturned.func_75870_c().field_75839_a, this.pathReturned.func_75870_c().field_75837_b, this.pathReturned.func_75870_c().field_75838_c));
                        if (dist < 2.0f && this.pathReturned.func_75874_d() > 1) {
                            this.hasPathToTarget = true;
                            this.entInt.getAIAgent().setPathToEntityForce(this.pathReturned);
                        } else {
                            this.hasPathToTarget = false;
                        }
                        this.tryPathToTarget = false;
                    } else {
                        this.dbg("no path");
                        this.hasPathToTarget = false;
                        this.waitingForPath = false;
                    }
                }
            }
            if (!this.tryPathToTarget) {
                if (this.hasPathToTarget) {
                    super.tick();
                    if (this.ent.func_70661_as().func_75500_f()) {
                        this.hasPathToTarget = false;
                    }
                    return;
                }
                this.dbg("pathing to best spot");
                this.entInt.getAIAgent().walkToMark((Entity)this.ent, this.pathReturned, 2400);
                this.entInt.getAIAgent().setPathToEntityForce(this.pathReturned);
                this.setJobState(EnumJobState.W1);
            }
        } else if (this.state == EnumJobState.W1) {
            if (this.entInt.getAIAgent().notPathing()) {
                this.dbg("pathing finish");
                this.setJobState(EnumJobState.W2);
            } else {
                double speed = Math.sqrt(this.ent.field_70159_w * this.ent.field_70159_w + this.ent.field_70179_y * this.ent.field_70179_y);
                if (this.ent.field_70122_E && speed < (double)0.02f) {
                    tryDoorBreak = true;
                    doMineTick = true;
                }
                if (this.ent.field_70122_E && this.noMoveTicks > 5 && Math.sqrt(this.ent.field_70159_w * this.ent.field_70159_w + this.ent.field_70181_x * this.ent.field_70181_x + this.ent.field_70179_y * this.ent.field_70179_y) < (double)0.02f) {
                    this.ent.field_70181_x = 0.42f;
                    this.walkingTimeout -= 20;
                }
                --this.walkingTimeout;
                if (this.walkingTimeout <= 0) {
                    this.dbg("walking timeout reached, nulling path");
                    this.entInt.getAIAgent().pathToEntity = null;
                    return;
                }
            }
        } else if (this.state == EnumJobState.W2) {
            if (this.simuDigCooldownCur > 0) {
                --this.simuDigCooldownCur;
            } else {
                this.simuDigCooldownCur = this.simuDigCooldownMax;
                ChunkCoordinates coords = null;
                ChunkCoordinates aimCoord = ((JobGroupHorde)this.jm.getPrimaryJob()).attackCoord;
                boolean pathAndDig = false;
                this.dbg("simuDigCount: " + this.simuDigCount);
                if (this.simuDigCount == 0 && this.isDiggableAngle(aimCoord)) {
                    this.dbg("try strait dig");
                    coords = this.rayTraceBlocksInverted(Vec3.func_72443_a((double)this.ent.field_70165_t, (double)this.ent.field_70163_u, (double)this.ent.field_70161_v), Vec3.func_72443_a((double)aimCoord.field_71574_a, (double)aimCoord.field_71572_b, (double)aimCoord.field_71573_c));
                } else if (this.simuDigCount < 10) {
                    double xDiff = (double)aimCoord.field_71574_a - this.ent.field_70165_t;
                    double zDiff = (double)aimCoord.field_71573_c - this.ent.field_70161_v;
                    double distHoriz = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
                    if (distHoriz < 0.0) {
                        distHoriz = 1.0;
                    }
                    double distVert = (double)aimCoord.field_71572_b - this.ent.field_70163_u;
                    double factor = distVert / distHoriz;
                    if (!pathAndDig) {
                        this.dbg("bad angle, try randomized");
                        this.dbg("factor: " + factor);
                        double adjust = 20.0 * factor + distVert + (double)this.ent.field_70170_p.field_73012_v.nextInt(20);
                        double newX = 0.0;
                        double newY = 0.0;
                        double newZ = 0.0;
                        if (xDiff > 0.0) {
                            newX = (double)aimCoord.field_71574_a - adjust;
                        }
                        if (zDiff > 0.0) {
                            newZ = (double)aimCoord.field_71573_c - adjust;
                        }
                        if (xDiff <= 0.0) {
                            newX = (double)aimCoord.field_71574_a + adjust;
                        }
                        if (zDiff <= 0.0) {
                            newZ = (double)aimCoord.field_71573_c + adjust;
                        }
                        newY = this.ent.field_70170_p.func_72976_f((int)newX, (int)newZ) + 1;
                        this.dbg("attack coord: " + aimCoord.field_71574_a + ", " + aimCoord.field_71573_c);
                        this.dbg("new coord: " + newX + ", " + newZ);
                        coords = this.rayTraceBlocksInverted(Vec3.func_72443_a((double)this.ent.field_70165_t, (double)this.ent.field_70163_u, (double)this.ent.field_70161_v), Vec3.func_72443_a((double)newX, (double)newY, (double)newZ));
                    } else {
                        if ((this.simuDigCount + 1) % 2 == 0) {
                            int range = 80;
                            double newX = aimCoord.field_71574_a + this.ent.field_70170_p.field_73012_v.nextInt(range) - range / 2;
                            double newZ = aimCoord.field_71573_c + this.ent.field_70170_p.field_73012_v.nextInt(range) - range / 2;
                            double newY = this.ent.field_70170_p.func_72976_f((int)newX, (int)newZ) + 1;
                            this.dbg("attack coord: " + aimCoord.field_71574_a + ", " + aimCoord.field_71573_c);
                            this.dbg("new coord: " + newX + ", " + newZ);
                            this.entInt.getAIAgent().walkTo((Entity)this.ent, (int)newX, (int)newY, (int)newZ, 256.0f, 800);
                            this.bestDigCoord = new ChunkCoordinates((int)newX, (int)newY, (int)newZ);
                            ++this.simuDigCount;
                            this.setJobState(EnumJobState.W1);
                            this.dbg("walking to best random spot");
                            return;
                        }
                        if (this.bestDigCoord == null) {
                            this.bestDigCoord = aimCoord;
                            this.dbg("bestDigCoord null, switching to aimCoord");
                        }
                        coords = this.rayTraceBlocksInverted(Vec3.func_72443_a((double)this.ent.field_70165_t, (double)this.ent.field_70163_u, (double)this.ent.field_70161_v), Vec3.func_72443_a((double)this.bestDigCoord.field_71574_a, (double)this.bestDigCoord.field_71572_b, (double)this.bestDigCoord.field_71573_c));
                    }
                }
                if (coords != null) {
                    this.dbg("found end of solid, dist: " + this.ent.func_70011_f((double)coords.field_71574_a, (double)coords.field_71572_b, (double)coords.field_71573_c));
                    this.bestDigCoord = coords;
                    this.setJobState(EnumJobState.W3);
                } else if (this.simuDigCount < 10) {
                    ++this.simuDigCount;
                } else {
                    this.setJobState(EnumJobState.IDLE);
                    this.fullReset();
                    this.dbg("dig failed");
                }
            }
        } else if (this.state == EnumJobState.W3) {
            ++this.noDigTicks;
            if (this.noDigTicks > this.noDigTicksMax) {
                this.dbg("NO DIG TICK RESET");
                this.noDigTicks = 0;
                this.fullReset();
            }
            if (this.bestDigCoord != null && this.ent.func_70011_f((double)this.bestDigCoord.field_71574_a, (double)this.bestDigCoord.field_71572_b, (double)this.bestDigCoord.field_71573_c) >= 1.0) {
                double xDiff = (double)this.bestDigCoord.field_71574_a - this.ent.field_70165_t;
                double zDiff = (double)this.bestDigCoord.field_71573_c - this.ent.field_70161_v;
                double distHoriz = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
                double distVert = (double)this.bestDigCoord.field_71572_b - this.ent.field_70163_u;
                if (distHoriz == 0.0) {
                    distHoriz = 1.0;
                }
                double factor = distVert / distHoriz;
                int digYDir = 0;
                if (factor > 0.15) {
                    digYDir = 1;
                } else if (factor < -0.15) {
                    digYDir = -1;
                }
                int digYoffset = 0;
                if (digYDir == 1) {
                    digYoffset = 1;
                } else if (digYDir == -1) {
                    digYoffset = -1;
                }
                if (factor > (double)this.yDiffMax) {
                    this.dbg("extreme X/Y diff detected, full reset, factor: " + factor);
                    this.fullReset();
                    return;
                }
                double speed = Math.sqrt(this.ent.field_70159_w * this.ent.field_70159_w + this.ent.field_70179_y * this.ent.field_70179_y);
                if (speed < (double)0.02f || this.ent.func_70090_H()) {
                    if (this.curBlockDamage == 0.0f) {
                        if (this.digState == EnumJobState.IDLE) {
                            if (digYDir == 1) {
                                this.trySetNextDigBlock(digYoffset, true, 0);
                            }
                        } else if (this.digState == EnumJobState.W1) {
                            this.trySetNextDigBlock(1 + digYoffset);
                        } else if (this.digState == EnumJobState.W2) {
                            this.trySetNextDigBlock(digYoffset);
                        } else if (this.digState == EnumJobState.W3 && digYDir == -1) {
                            this.trySetNextDigBlock(0, false, 0);
                        }
                    }
                    doMineTick = true;
                }
                if (this.ent.field_70170_p.func_72937_j((int)this.ent.field_70165_t, (int)this.ent.field_70163_u + 2, (int)this.ent.field_70161_v)) {
                    ++this.seesSkyTicks;
                    if (this.lastMinedCoord == null && this.seesSkyTicks > 100) {
                        this.dbg("saw sky first time, reset!");
                        this.fullReset();
                        return;
                    }
                } else {
                    this.seesSkyTicks = 0;
                }
                this.ent.field_70159_w = 0.0;
                this.ent.field_70179_y = 0.0;
                this.entInt.getAIAgent().faceCoord(this.bestDigCoord, 180.0f, 0.0f);
                this.ent.func_70060_a(0.0f, 0.3f, 0.25f);
                this.ent.func_70091_d(0.0, 0.0, 0.0);
                this.entInt.getAIAgent().entityToAttack = null;
            } else {
                this.dbg("end of dig, full reset");
                this.fullReset();
            }
        } else if (this.state == EnumJobState.W4) {
            // empty if block
        }
        if (doMineTick || this.lastMinedCoord != null) {
            if (tryDoorBreak && this.curBlockDamage == 0.0f) {
                Block id;
                this.trySetNextDigBlock(1);
                if (this.lastMinedCoord != null && !CoroUtilBlock.isAir((Block)(id = this.ent.field_70170_p.func_147439_a(this.lastMinedCoord.field_71574_a, this.lastMinedCoord.field_71572_b, this.lastMinedCoord.field_71573_c))) && !(id instanceof BlockDoor)) {
                    this.lastMinedCoord = null;
                }
            }
            if (this.lastMinedCoord != null) {
                float strVsBlock = 0.0f;
                Block id = this.ent.field_70170_p.func_147439_a(this.lastMinedCoord.field_71574_a, this.lastMinedCoord.field_71572_b, this.lastMinedCoord.field_71573_c);
                if (!CoroUtilBlock.isAir((Block)id)) {
                    strVsBlock = id.func_149712_f(this.ent.field_70170_p, this.lastMinedCoord.field_71574_a, this.lastMinedCoord.field_71572_b, this.lastMinedCoord.field_71573_c);
                }
                if (strVsBlock == -1.0f) {
                    this.lastMinedCoord = null;
                    return;
                }
                this.curBlockDamage += 4.0f / strVsBlock / 20.0f;
                if (this.ent.field_70170_p.func_72820_D() % 4L == 0L && !CoroUtilBlock.isAir((Block)id)) {
                    this.ent.field_70170_p.func_72956_a((Entity)this.ent, "step.stone", 1.0f, 1.0f);
                }
                if (this.curBlockDamage > 1.0f) {
                    this.ent.field_70170_p.func_147443_d(this.ent.func_145782_y(), this.lastMinedCoord.field_71574_a, this.lastMinedCoord.field_71572_b, this.lastMinedCoord.field_71573_c, -1);
                    this.ent.field_70170_p.func_147449_b(this.lastMinedCoord.field_71574_a, this.lastMinedCoord.field_71572_b, this.lastMinedCoord.field_71573_c, Blocks.field_150350_a);
                    if (!CoroUtilBlock.isAir((Block)id) && id.field_149762_H != null) {
                        this.ent.field_70170_p.func_72956_a((Entity)this.ent, id.field_149762_H.func_150495_a(), 1.0f, 1.0f);
                    }
                    this.curBlockDamage = 0.0f;
                    this.noDigTicks = 0;
                    this.nextDigState();
                    this.lastMinedCoord = null;
                } else {
                    this.ent.field_70170_p.func_147443_d(this.ent.func_145782_y(), this.lastMinedCoord.field_71574_a, this.lastMinedCoord.field_71572_b, this.lastMinedCoord.field_71573_c, (int)(this.curBlockDamage * 10.0f));
                }
                this.ent.func_71038_i();
            } else {
                this.nextDigState();
                this.curBlockDamage = 0.0f;
            }
            if (this.ent.field_70170_p.func_72820_D() % 20L == 0L && this.bestDigCoord != null && this.ent.field_70181_x < (double)0.05f && this.ent.field_70121_D.field_72338_b < (double)this.bestDigCoord.field_71572_b) {
                OldUtil.jump((EntityLivingBase)this.ent);
            }
        }
        if (!doMineTick && this.lastMinedCoord == null) {
            this.noMoveTicks = Math.sqrt(this.ent.field_70159_w * this.ent.field_70159_w + this.ent.field_70179_y * this.ent.field_70179_y) < (double)0.02f ? ++this.noMoveTicks : 0;
        }
        if (this.noMoveTicks > 200) {
            if (this.state == EnumJobState.W1) {
                this.setJobState(EnumJobState.W2);
                this.noMoveTicks = 0;
                this.dbg("idle out set to W2");
            } else {
                this.dbg("idle out reset");
                this.fullReset();
            }
        }
    }

    public void nextDigState() {
        if (this.digState == EnumJobState.IDLE) {
            this.digState = EnumJobState.W1;
        } else if (this.digState == EnumJobState.W1) {
            this.digState = EnumJobState.W2;
        } else if (this.digState == EnumJobState.W2) {
            this.digState = EnumJobState.W3;
        } else if (this.digState == EnumJobState.W3) {
            this.digState = EnumJobState.IDLE;
        }
    }

    public boolean trySetNextDigBlock(int offset) {
        return this.trySetNextDigBlock(offset, false, 0);
    }

    public boolean trySetNextDigBlock(int offset, boolean usePosition, int afterTraceOffset) {
        ChunkCoordinates coords = null;
        if (usePosition) {
            coords = new ChunkCoordinates((int)this.ent.field_70165_t, (int)this.ent.field_70163_u + 1 + offset, (int)this.ent.field_70161_v);
        } else {
            MovingObjectPosition aim = null;
            int randSize = 30;
            this.ent.field_70125_A = 0.0f;
            this.ent.field_70177_z += (float)(this.ent.field_70170_p.field_73012_v.nextInt(randSize) - randSize / 2);
            aim = this.entInt.getAIAgent().rayTrace(1.0, (float)offset, null);
            if (aim != null || this.bestDigCoord == null || (double)this.bestDigCoord.field_71572_b < this.ent.field_70163_u) {
                // empty if block
            }
            if (aim != null) {
                coords = new ChunkCoordinates(aim.field_72311_b, aim.field_72312_c + afterTraceOffset, aim.field_72309_d);
            } else {
                for (int i = 0; i < 8; ++i) {
                    int l;
                    int k;
                    float f = ((float)((i >> 0) % 2) - 0.5f) * this.ent.field_70130_N * 0.8f;
                    float f1 = ((float)((i >> 1) % 2) - 0.5f) * 0.1f;
                    float f2 = ((float)((i >> 2) % 2) - 0.5f) * this.ent.field_70130_N * 0.8f;
                    int j = MathHelper.func_76128_c((double)(this.ent.field_70165_t + (double)f));
                    Block id = this.ent.field_70170_p.func_147439_a(j, k = MathHelper.func_76128_c((double)(this.ent.field_70163_u + (i % 2 == 0 ? (double)this.ent.func_70047_e() : 0.0) + (double)f1)), l = MathHelper.func_76128_c((double)(this.ent.field_70161_v + (double)f2)));
                    if (CoroUtilBlock.isAir((Block)id) || !id.func_149688_o().func_76220_a()) continue;
                    coords = new ChunkCoordinates(j, k, l);
                }
            }
        }
        if (coords != null) {
            Block id = this.ent.field_70170_p.func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
            if (!CoroUtilBlock.isAir((Block)id) && id.func_149688_o() == Material.field_151587_i) {
                this.fullReset();
                return false;
            }
            if (!CoroUtilBlock.isAir((Block)id) && id.func_149688_o() != Material.field_151586_h && this.ent.field_70170_p.func_147438_o(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c) == null && !HostileWorlds.blocksList.contains(this.ent.field_70170_p.func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c))) {
                this.lastMinedCoord = coords;
                return true;
            }
        }
        return false;
    }

    public void fullReset() {
        this.noMoveTicks = 0;
        this.seesSkyTicks = 0;
        this.simuDigCount = 0;
        this.pfReturnTimeout = 0;
        this.waitingForPath = false;
        this.waitingForThreadPath = false;
        this.pathReturned = null;
        this.tryPathToTarget = true;
        this.hasPathToTarget = false;
        if (this.lastMinedCoord != null) {
            this.ent.field_70170_p.func_147443_d(this.ent.func_145782_y(), this.lastMinedCoord.field_71574_a, this.lastMinedCoord.field_71572_b, this.lastMinedCoord.field_71573_c, -1);
        }
        this.lastMinedCoord = null;
        this.simuDigCooldownCur = 0;
        this.digState = EnumJobState.IDLE;
        this.setJobState(EnumJobState.IDLE);
    }

    public boolean isDiggableAngle(ChunkCoordinates coord) {
        if (this.ent.field_70163_u > (double)((JobGroupHorde)this.jm.getPrimaryJob()).attackCoord.field_71572_b) {
            return true;
        }
        return this.getVerticalAngle(coord) < this.yDiffMax;
    }

    public float getVerticalAngle(ChunkCoordinates coord) {
        double xDiff = (double)coord.field_71574_a - this.ent.field_70165_t;
        double zDiff = (double)coord.field_71573_c - this.ent.field_70161_v;
        double distHoriz = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        double distVert = (double)coord.field_71572_b - this.ent.field_70163_u;
        if (distHoriz == 0.0) {
            distHoriz = 1.0;
        }
        return (float)(distVert / distHoriz);
    }

    public void setPathToEntity(PathEntity pathentity) {
        if (this.waitingForThreadPath) {
            this.pathReturned = pathentity;
            this.waitingForThreadPath = false;
        } else {
            this.entInt.getAIAgent().setPathToEntityForce(pathentity);
        }
    }

    public ChunkCoordinates rayTraceBlocksInverted(Vec3 par1Vec3, Vec3 par2Vec3) {
        int maxAirBlocksIntoSolid = 3;
        int curAirBlocksIntoSolid = 0;
        int maxAirBlocksBeforeSolid = 4;
        int curAirBlocksBeforeSolid = 0;
        double var1 = par2Vec3.field_72450_a - par1Vec3.field_72450_a;
        double var3 = par2Vec3.field_72448_b - par1Vec3.field_72448_b;
        double var5 = par2Vec3.field_72449_c - par1Vec3.field_72449_c;
        double var7 = MathHelper.func_76133_a((double)(var1 * var1 + var3 * var3 + var5 * var5));
        float stepSize = 1.0f;
        double scanDirX = var1 / var7 * (double)stepSize;
        double scanDirY = var3 / var7 * (double)stepSize;
        double scanDirZ = var5 / var7 * (double)stepSize;
        int maxIterations = 800;
        int curIterations = 0;
        double curX = par1Vec3.field_72450_a;
        double curY = par1Vec3.field_72448_b;
        double curZ = par1Vec3.field_72449_c;
        boolean foundFirstSolid = false;
        while (curIterations++ < maxIterations) {
            Block id = this.ent.field_70170_p.func_147439_a((int)(curX += var1 / var7 * (double)stepSize), (int)(curY += var3 / var7 * (double)stepSize), (int)(curZ += var5 / var7 * (double)stepSize));
            if (this.isNoDigCoord((int)curX, (int)curY, (int)curZ)) {
                this.dbg("simudig fail: bukkit protected area");
                return null;
            }
            if (!CoroUtilBlock.isAir((Block)id)) {
                foundFirstSolid = true;
                curAirBlocksIntoSolid = 0;
                if (this.isNoDigBlock(id)) {
                    this.dbg("simudig fail: no dig block");
                    return null;
                }
                if (this.ent.field_70170_p.func_72976_f((int)curX, (int)curZ) > (int)curY) continue;
                this.dbg("simudig success: target coord is at surface");
                return new ChunkCoordinates((int)curX, (int)curY, (int)curZ);
            }
            if (foundFirstSolid) {
                if (++curAirBlocksIntoSolid <= maxAirBlocksIntoSolid) continue;
                int curIterations2 = 0;
                int maxIterations2 = 5;
                while (curIterations2++ < maxIterations2) {
                    id = this.ent.field_70170_p.func_147439_a((int)curX, (int)curY - curIterations2, (int)curZ);
                    if (CoroUtilBlock.isAir((Block)id)) continue;
                    this.dbg("simudig success: safe drop");
                    return new ChunkCoordinates((int)curX, (int)curY - curIterations2 + 1, (int)curZ);
                }
                this.dbg("simudig fail: bad drop");
                return null;
            }
            if (++curAirBlocksBeforeSolid <= maxAirBlocksBeforeSolid) continue;
            this.dbg("simudig fail: too much air at start");
            return null;
        }
        this.dbg("simudig fail: max iterations");
        return null;
    }

    public boolean isNoDigBlock(Block id) {
        if (this.isDangerBlock(id)) {
            return true;
        }
        return this.simuDigCount < 5 && id.func_149688_o() == Material.field_151586_h;
    }

    public boolean isNoDigCoord(int x, int y, int z) {
        return false;
    }

    public boolean isDangerBlock(Block id) {
        return id.func_149688_o() == Material.field_151587_i || id.func_149688_o() == Material.field_151570_A;
    }

    public boolean canJoinFormations() {
        return false;
    }
}

