/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.ai.jobs;

import CoroUtil.OldUtil;
import CoroUtil.componentAI.jobSystem.JobManager;
import CoroUtil.entity.EnumJobState;
import CoroUtil.util.CoroUtilBlock;
import hostileworlds.HostileWorlds;
import hostileworlds.ai.jobs.JobGroupHorde;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;

public class JobPathClawer
extends JobGroupHorde {
    public int pfReturnTimeout = 0;
    public boolean waitingForPath = false;
    public boolean waitingForThreadPath = false;
    public PathEntity pathReturned = null;
    public boolean tryPathToTarget = true;
    public boolean hasPathToTarget = false;
    public int simuDigCount;
    public int simuDigCooldownCur = 0;
    public int simuDigCooldownMax = 40;
    public ChunkCoordinates lastMinedCoord = null;
    public EnumJobState digState = EnumJobState.IDLE;
    public ChunkCoordinates bestDigCoord = null;
    public float curBlockDamage;
    public float tickBlockDamage = 0.1f;
    public int seesSkyTicks = 0;
    public int noMoveTicks = 0;
    public int noDigTicks = 0;
    public int noDigTicksMax = 300;
    public float yDiffMax = 2.0f;

    public JobPathClawer(JobManager jm) {
        super(jm);
    }

    @Override
    public boolean shouldExecute() {
        return true;
    }

    @Override
    public boolean shouldContinue() {
        return true;
    }

    public void onIdleTickAct() {
    }

    public void dbg(Object par) {
        HostileWorlds.dbg(par);
    }

    @Override
    public void tick() {
        boolean doMineTick = false;
        boolean tryDoorBreak = true;
        boolean doDoorBreak = true;
        if (this.ai.entityToAttack != null && this.ent.func_70032_d(this.ai.entityToAttack) >= 2.0f && Math.abs(this.ent.field_70163_u - this.ai.entityToAttack.field_70163_u) < 3.0) {
            doMineTick = true;
            this.ent.func_70605_aq().func_75642_a(this.ai.entityToAttack.field_70165_t, this.ai.entityToAttack.field_70163_u, this.ai.entityToAttack.field_70161_v, (double)OldUtil.getMoveSpeed((EntityLivingBase)this.ent));
            this.setPathToEntity(null);
        }
        if (this.lastMinedCoord != null && this.ent.func_70011_f((double)this.lastMinedCoord.field_71574_a, (double)this.lastMinedCoord.field_71572_b, (double)this.lastMinedCoord.field_71573_c) > 3.0) {
            this.lastMinedCoord = null;
        }
        if (doMineTick || this.lastMinedCoord != null) {
            if (tryDoorBreak && this.curBlockDamage == 0.0f) {
                this.trySetNextDigBlock(1);
                if (this.lastMinedCoord == null) {
                    this.trySetNextDigBlock(0);
                }
            }
            if (this.lastMinedCoord != null) {
                float strVsBlock = 0.0f;
                Block id = this.ent.field_70170_p.func_147439_a(this.lastMinedCoord.field_71574_a, this.lastMinedCoord.field_71572_b, this.lastMinedCoord.field_71573_c);
                if (!CoroUtilBlock.isAir((Block)id)) {
                    strVsBlock = id.func_149712_f(this.ent.field_70170_p, this.lastMinedCoord.field_71574_a, this.lastMinedCoord.field_71572_b, this.lastMinedCoord.field_71573_c);
                }
                if (strVsBlock == -1.0f) {
                    this.lastMinedCoord = null;
                    return;
                }
                this.curBlockDamage += 0.5f / strVsBlock / 20.0f;
                if (this.ent.field_70170_p.func_72820_D() % 4L == 0L && !CoroUtilBlock.isAir((Block)id)) {
                    this.ent.field_70170_p.func_72956_a((Entity)this.ent, "step.stone", 1.0f, 1.0f);
                }
                if (this.curBlockDamage > 1.0f) {
                    this.ent.field_70170_p.func_147443_d(this.ent.func_145782_y(), this.lastMinedCoord.field_71574_a, this.lastMinedCoord.field_71572_b, this.lastMinedCoord.field_71573_c, -1);
                    this.ent.field_70170_p.func_147449_b(this.lastMinedCoord.field_71574_a, this.lastMinedCoord.field_71572_b, this.lastMinedCoord.field_71573_c, Blocks.field_150350_a);
                    if (!CoroUtilBlock.isAir((Block)id) && id.field_149762_H != null) {
                        this.ent.field_70170_p.func_72956_a((Entity)this.ent, id.field_149762_H.func_150495_a(), 1.0f, 1.0f);
                    }
                    this.curBlockDamage = 0.0f;
                    this.noDigTicks = 0;
                    this.nextDigState();
                    this.lastMinedCoord = null;
                } else {
                    this.ent.field_70170_p.func_147443_d(this.ent.func_145782_y(), this.lastMinedCoord.field_71574_a, this.lastMinedCoord.field_71572_b, this.lastMinedCoord.field_71573_c, (int)(this.curBlockDamage * 10.0f));
                }
                this.ent.func_71038_i();
            } else {
                this.nextDigState();
                this.curBlockDamage = 0.0f;
            }
        }
        if (this.ent.field_70170_p.func_72820_D() % 20L == 0L && this.ent.field_70181_x < (double)0.05f) {
            if (this.lastMinedCoord != null && this.ent.field_70121_D.field_72338_b < (double)this.lastMinedCoord.field_71572_b) {
                OldUtil.jump((EntityLivingBase)this.ent);
            } else if (this.ai.entityToAttack != null && this.ent.field_70123_F) {
                OldUtil.jump((EntityLivingBase)this.ent);
            }
        }
        if (!doMineTick && this.lastMinedCoord == null) {
            this.noMoveTicks = Math.sqrt(this.ent.field_70159_w * this.ent.field_70159_w + this.ent.field_70179_y * this.ent.field_70179_y) < (double)0.02f ? ++this.noMoveTicks : 0;
        }
        if (this.noMoveTicks > 200) {
            if (this.state == EnumJobState.W1) {
                this.setJobState(EnumJobState.W2);
                this.noMoveTicks = 0;
                this.dbg("idle out set to W2");
            } else {
                this.dbg("idle out reset");
                this.fullReset();
            }
        }
    }

    public void nextDigState() {
        if (this.digState == EnumJobState.IDLE) {
            this.digState = EnumJobState.W1;
        } else if (this.digState == EnumJobState.W1) {
            this.digState = EnumJobState.W2;
        } else if (this.digState == EnumJobState.W2) {
            this.digState = EnumJobState.W3;
        } else if (this.digState == EnumJobState.W3) {
            this.digState = EnumJobState.IDLE;
        }
    }

    public boolean trySetNextDigBlock(int offset) {
        return this.trySetNextDigBlock(offset, false, 0);
    }

    public boolean trySetNextDigBlock(int offset, boolean usePosition, int afterTraceOffset) {
        ChunkCoordinates coords = null;
        if (usePosition) {
            coords = new ChunkCoordinates((int)this.ent.field_70165_t, (int)this.ent.field_70163_u + 1 + offset, (int)this.ent.field_70161_v);
        } else {
            MovingObjectPosition aim = null;
            int randSize = 30;
            this.ent.field_70125_A = 0.0f;
            this.ent.field_70177_z += (float)(this.ent.field_70170_p.field_73012_v.nextInt(randSize) - randSize / 2);
            aim = this.entInt.getAIAgent().rayTrace(1.0, (float)offset, null);
            if (aim != null || this.bestDigCoord == null || (double)this.bestDigCoord.field_71572_b < this.ent.field_70163_u) {
                // empty if block
            }
            if (aim != null) {
                coords = new ChunkCoordinates(aim.field_72311_b, aim.field_72312_c + afterTraceOffset, aim.field_72309_d);
            } else {
                for (int i = 0; i < 8; ++i) {
                    int l;
                    int k;
                    float f = ((float)((i >> 0) % 2) - 0.5f) * this.ent.field_70130_N * 0.8f;
                    float f1 = ((float)((i >> 1) % 2) - 0.5f) * 0.1f;
                    float f2 = ((float)((i >> 2) % 2) - 0.5f) * this.ent.field_70130_N * 0.8f;
                    int j = MathHelper.func_76128_c((double)(this.ent.field_70165_t + (double)f));
                    Block id = this.ent.field_70170_p.func_147439_a(j, k = MathHelper.func_76128_c((double)(this.ent.field_70163_u + (i % 2 == 0 ? (double)this.ent.func_70047_e() : 0.5) + (double)f1)), l = MathHelper.func_76128_c((double)(this.ent.field_70161_v + (double)f2)));
                    if (CoroUtilBlock.isAir((Block)id) || !id.func_149688_o().func_76220_a()) continue;
                    coords = new ChunkCoordinates(j, k, l);
                }
            }
        }
        if (coords != null) {
            Block id = this.ent.field_70170_p.func_147439_a(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c);
            if (!CoroUtilBlock.isAir((Block)id) && id.func_149688_o() == Material.field_151587_i) {
                this.fullReset();
                return false;
            }
            if (!CoroUtilBlock.isAir((Block)id) && id.func_149688_o() != Material.field_151586_h && this.ent.field_70170_p.func_147438_o(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c) == null) {
                this.lastMinedCoord = coords;
                return true;
            }
        }
        return false;
    }

    public void fullReset() {
        this.noMoveTicks = 0;
        this.seesSkyTicks = 0;
        this.simuDigCount = 0;
        this.pfReturnTimeout = 0;
        this.waitingForPath = false;
        this.waitingForThreadPath = false;
        this.pathReturned = null;
        this.tryPathToTarget = true;
        this.hasPathToTarget = false;
        if (this.lastMinedCoord != null) {
            this.ent.field_70170_p.func_147443_d(this.ent.func_145782_y(), this.lastMinedCoord.field_71574_a, this.lastMinedCoord.field_71572_b, this.lastMinedCoord.field_71573_c, -1);
        }
        this.lastMinedCoord = null;
        this.simuDigCooldownCur = 0;
        this.digState = EnumJobState.IDLE;
        this.setJobState(EnumJobState.IDLE);
    }

    public boolean isDiggableAngle(ChunkCoordinates coord) {
        if (this.ent.field_70163_u > (double)((JobGroupHorde)this.jm.getPrimaryJob()).attackCoord.field_71572_b) {
            return true;
        }
        return this.getVerticalAngle(coord) < this.yDiffMax;
    }

    public float getVerticalAngle(ChunkCoordinates coord) {
        double xDiff = (double)coord.field_71574_a - this.ent.field_70165_t;
        double zDiff = (double)coord.field_71573_c - this.ent.field_70161_v;
        double distHoriz = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        double distVert = (double)coord.field_71572_b - this.ent.field_70163_u;
        if (distHoriz == 0.0) {
            distHoriz = 1.0;
        }
        return (float)(distVert / distHoriz);
    }

    public void setPathToEntity(PathEntity pathentity) {
        if (this.waitingForThreadPath) {
            this.pathReturned = pathentity;
            this.waitingForThreadPath = false;
        } else {
            this.entInt.getAIAgent().setPathToEntityForce(pathentity);
        }
    }

    public ChunkCoordinates rayTraceBlocksInverted(Vec3 par1Vec3, Vec3 par2Vec3) {
        int maxAirBlocksIntoSolid = 3;
        int curAirBlocksIntoSolid = 0;
        int maxAirBlocksBeforeSolid = 4;
        int curAirBlocksBeforeSolid = 0;
        double var1 = par2Vec3.field_72450_a - par1Vec3.field_72450_a;
        double var3 = par2Vec3.field_72448_b - par1Vec3.field_72448_b;
        double var5 = par2Vec3.field_72449_c - par1Vec3.field_72449_c;
        double var7 = MathHelper.func_76133_a((double)(var1 * var1 + var3 * var3 + var5 * var5));
        float stepSize = 1.0f;
        double scanDirX = var1 / var7 * (double)stepSize;
        double scanDirY = var3 / var7 * (double)stepSize;
        double scanDirZ = var5 / var7 * (double)stepSize;
        int maxIterations = 800;
        int curIterations = 0;
        double curX = par1Vec3.field_72450_a;
        double curY = par1Vec3.field_72448_b;
        double curZ = par1Vec3.field_72449_c;
        boolean foundFirstSolid = false;
        while (curIterations++ < maxIterations) {
            Block id = this.ent.field_70170_p.func_147439_a((int)(curX += var1 / var7 * (double)stepSize), (int)(curY += var3 / var7 * (double)stepSize), (int)(curZ += var5 / var7 * (double)stepSize));
            if (this.isNoDigCoord((int)curX, (int)curY, (int)curZ)) {
                this.dbg("simudig fail: bukkit protected area");
                return null;
            }
            if (!CoroUtilBlock.isAir((Block)id)) {
                foundFirstSolid = true;
                curAirBlocksIntoSolid = 0;
                if (this.isNoDigBlock(id)) {
                    this.dbg("simudig fail: no dig block");
                    return null;
                }
                if (this.ent.field_70170_p.func_72976_f((int)curX, (int)curZ) > (int)curY) continue;
                this.dbg("simudig success: target coord is at surface");
                return new ChunkCoordinates((int)curX, (int)curY, (int)curZ);
            }
            if (foundFirstSolid) {
                if (++curAirBlocksIntoSolid <= maxAirBlocksIntoSolid) continue;
                int curIterations2 = 0;
                int maxIterations2 = 5;
                while (curIterations2++ < maxIterations2) {
                    id = this.ent.field_70170_p.func_147439_a((int)curX, (int)curY - curIterations2, (int)curZ);
                    if (CoroUtilBlock.isAir((Block)id)) continue;
                    this.dbg("simudig success: safe drop");
                    return new ChunkCoordinates((int)curX, (int)curY - curIterations2 + 1, (int)curZ);
                }
                this.dbg("simudig fail: bad drop");
                return null;
            }
            if (++curAirBlocksBeforeSolid <= maxAirBlocksBeforeSolid) continue;
            this.dbg("simudig fail: too much air at start");
            return null;
        }
        this.dbg("simudig fail: max iterations");
        return null;
    }

    public boolean isNoDigBlock(Block id) {
        if (this.isDangerBlock(id)) {
            return true;
        }
        return this.simuDigCount < 5 && id.func_149688_o() == Material.field_151586_h;
    }

    public boolean isNoDigCoord(int x, int y, int z) {
        return false;
    }

    public boolean isDangerBlock(Block id) {
        return id.func_149688_o() == Material.field_151587_i || id.func_149688_o() == Material.field_151570_A;
    }

    public boolean canJoinFormations() {
        return false;
    }
}

