/*
 * Decompiled with CFR 0.152.
 */
package hostileworlds.ai.invasion;

import CoroUtil.entity.EnumJobState;
import hostileworlds.HostileWorlds;
import hostileworlds.ServerTickHandler;
import hostileworlds.ai.WorldDirectorMultiDim;
import hostileworlds.ai.invasion.WorldEvent;
import hostileworlds.config.ModConfigFields;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class InvasionCaves
extends WorldEvent {
    public InvasionCaves() {
    }

    public InvasionCaves(int parDim, String parName, WorldEvent.EnumWorldEventType parType, ChunkCoordinates source, ChunkCoordinates dest) {
        super(parDim, parName, parType, source, dest);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.state == EnumJobState.IDLE) {
            this.updateCursedPlayersList(false);
            this.updatePlayerStates();
            this.calculatePlayerRatingData();
            this.currentWaveSpawnedInvaders = (int)((float)ModConfigFields.invasionBaseInvaderCount + this.currentWaveDifficultyRating / 3.0f);
            if (ServerTickHandler.wd.spawnGroup((World)DimensionManager.getWorld((int)this.dimensionID), this.coordDestination, this.coordSource, this, this.currentWaveSpawnedInvaders)) {
                HostileWorlds.dbg("spawned cave group!");
                if (!this.mainPlayerName.equals("")) {
                    NBTTagCompound nbt = WorldDirectorMultiDim.getPlayerNBT(this.mainPlayerName);
                    nbt.func_74768_a("numOfWavesSpawned", nbt.func_74762_e("numOfWavesSpawned") + 1);
                }
                this.setState(EnumJobState.W1);
            } else {
                HostileWorlds.dbg("failed to spawn cave group, trying another cave");
                if (WorldDirectorMultiDim.coordCaves.get(this.dimensionID).size() > 0) {
                    ArrayList<Object> invasionSources = new ArrayList();
                    invasionSources = ServerTickHandler.wd.getUnusedInvasionSourcesInRange(WorldDirectorMultiDim.coordCaves.get(this.dimensionID), this.coordDestination, this.dimensionID, ModConfigFields.meteorCrashDistFromPlayerMax);
                    if (invasionSources.size() > 0) {
                        Random rand = new Random(invasionSources.size());
                        this.coordSource = (ChunkCoordinates)invasionSources.get(rand.nextInt(invasionSources.size()));
                    } else {
                        this.invasionEnd();
                    }
                } else {
                    this.invasionEnd();
                }
            }
        } else if (this.state == EnumJobState.W1 && !this.checkForActiveInvadersCached()) {
            this.invasionEnd();
        }
    }

    @Override
    public boolean isComplete() {
        return super.isComplete();
    }
}

