/*
 * Decompiled with CFR 0.152.
 */
package highlands.worldgen.layer;

import cpw.mods.fml.common.eventhandler.Event;
import highlands.worldgen.layer.GenLayerBiomeHL;
import highlands.worldgen.layer.GenLayerIslandHL;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerAddIsland;
import net.minecraft.world.gen.layer.GenLayerAddMushroomIsland;
import net.minecraft.world.gen.layer.GenLayerAddSnow;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerRiver;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;

public abstract class GenLayerHL {
    private long worldGenSeed;
    protected GenLayer parent;
    private long chunkSeed;
    private long baseSeed;

    public static GenLayer[] initializeAllBiomeGenerators(long par0, WorldType par2WorldType) {
        GenLayerIslandHL var3 = new GenLayerIslandHL(1L);
        GenLayerFuzzyZoom var9 = new GenLayerFuzzyZoom(2000L, (GenLayer)var3);
        GenLayerAddIsland var10 = new GenLayerAddIsland(1L, (GenLayer)var9);
        GenLayerZoom var11 = new GenLayerZoom(2001L, (GenLayer)var10);
        var10 = new GenLayerAddIsland(2L, (GenLayer)var11);
        GenLayerAddSnow var12 = new GenLayerAddSnow(2L, (GenLayer)var10);
        var11 = new GenLayerZoom(2002L, (GenLayer)var12);
        var10 = new GenLayerAddIsland(3L, (GenLayer)var11);
        var11 = new GenLayerZoom(2003L, (GenLayer)var10);
        var10 = new GenLayerAddIsland(4L, (GenLayer)var11);
        GenLayerAddMushroomIsland var16 = new GenLayerAddMushroomIsland(5L, (GenLayer)var10);
        int var4 = 4;
        if (par2WorldType == WorldType.field_77135_d) {
            var4 = 6;
        }
        var4 = GenLayerHL.getModdedBiomeSize(par2WorldType, (byte)var4);
        GenLayer var5 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)var16, (int)0);
        GenLayerRiverInit var13 = new GenLayerRiverInit(100L, var5);
        var5 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)var13, (int)(var4 + 2));
        GenLayerRiver var14 = new GenLayerRiver(1L, var5);
        GenLayerSmooth var15 = new GenLayerSmooth(1000L, (GenLayer)var14);
        GenLayer var6 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)var16, (int)0);
        GenLayerBiomeHL var17 = new GenLayerBiomeHL(200L, var6, par2WorldType);
        GenLayer var18 = var6 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)var17, (int)2);
        for (int var7 = 0; var7 < var4; ++var7) {
            var18 = new GenLayerZoom((long)(1000 + var7), var18);
            if (var7 != 0) continue;
            var18 = new GenLayerAddIsland(3L, var18);
        }
        GenLayerSmooth smooth = new GenLayerSmooth(1000L, var18);
        GenLayerRiverMix riverMix = new GenLayerRiverMix(100L, (GenLayer)smooth, (GenLayer)var15);
        GenLayerVoronoiZoom var8 = new GenLayerVoronoiZoom(10L, (GenLayer)riverMix);
        riverMix.func_75905_a(par0);
        var8.func_75905_a(par0);
        return new GenLayer[]{riverMix, var8, riverMix};
    }

    public GenLayerHL(long par1) {
        this.baseSeed = par1;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += par1;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += par1;
        this.baseSeed *= this.baseSeed * 6364136223846793005L + 1442695040888963407L;
        this.baseSeed += par1;
    }

    public void initWorldGenSeed(long par1) {
        this.worldGenSeed = par1;
        if (this.parent != null) {
            this.parent.func_75905_a(par1);
        }
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
        this.worldGenSeed *= this.worldGenSeed * 6364136223846793005L + 1442695040888963407L;
        this.worldGenSeed += this.baseSeed;
    }

    public void initChunkSeed(long par1, long par3) {
        this.chunkSeed = this.worldGenSeed;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += par1;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += par3;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += par1;
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += par3;
    }

    protected int nextInt(int par1) {
        int var2 = (int)((this.chunkSeed >> 24) % (long)par1);
        if (var2 < 0) {
            var2 += par1;
        }
        this.chunkSeed *= this.chunkSeed * 6364136223846793005L + 1442695040888963407L;
        this.chunkSeed += this.worldGenSeed;
        return var2;
    }

    public abstract int[] getInts(int var1, int var2, int var3, int var4);

    public static byte getModdedBiomeSize(WorldType worldType, byte original) {
        WorldTypeEvent.BiomeSize event = new WorldTypeEvent.BiomeSize(worldType, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.newSize;
    }
}

