/*
 * Decompiled with CFR 0.152.
 */
package highlands.worldgen;

import highlands.Highlands;
import highlands.api.HighlandsBlocks;
import highlands.worldgen.WorldGenHighlandsTreeBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WorldGenTreeAsh
extends WorldGenHighlandsTreeBase {
    public WorldGenTreeAsh(int lmd, int wmd, Block wb, Block lb, int minH, int maxH, boolean notify) {
        super(lmd, wmd, wb, lb, notify);
        this.minHeight = minH;
        this.maxHeight = maxH;
    }

    public WorldGenTreeAsh(int minH, int maxH, boolean notify) {
        this(0, 0, HighlandsBlocks.ashWood, HighlandsBlocks.ashLeaves, minH, maxH, notify);
        if (Highlands.vanillaBlocksFlag) {
            this.wood = Blocks.field_150364_r;
            this.leaves = Blocks.field_150362_t;
        }
    }

    @Override
    public boolean func_76484_a(World world, Random random, int locX, int locY, int locZ) {
        int h;
        this.world = world;
        this.random = random;
        if (!this.isLegalTreePosition(world, locX, locY, locZ)) {
            return false;
        }
        if (!this.isCubeClear(locX, locY + 3, locZ, 3, 15)) {
            return false;
        }
        int treeHeight = this.minHeight + random.nextInt(this.maxHeight);
        for (int i = 0; i < treeHeight; ++i) {
            this.setBlockInWorld(locX, locY + i, locZ, this.wood, this.woodMeta);
            this.setBlockInWorld(locX + 1, locY + i, locZ, this.wood, this.woodMeta);
            this.setBlockInWorld(locX + 1, locY + i, locZ + 1, this.wood, this.woodMeta);
            this.setBlockInWorld(locX, locY + i, locZ + 1, this.wood, this.woodMeta);
        }
        for (h = locY + treeHeight - 3; h < locY + treeHeight; ++h) {
            this.generateLeafLayerCircleNoise(world, random, 3.5, locX + random.nextInt(2), locZ + random.nextInt(2), h);
        }
        this.generateLeafLayerCircleNoise(world, random, 3.8, locX + random.nextInt(2), locZ + random.nextInt(2), h);
        this.generateLeafLayerCircleNoise(world, random, 2.5, locX + random.nextInt(2), locZ + random.nextInt(2), ++h);
        this.generateLeafLayerCircleNoise(world, random, 2.0, locX + random.nextInt(2), locZ + random.nextInt(2), ++h);
        this.generateLeafLayerCircleNoise(world, random, 1.0, locX + random.nextInt(2), locZ + random.nextInt(2), ++h);
        h -= 16;
        int firstDir = random.nextInt(4);
        for (int i = 0; i < 8; ++i) {
            int[] xyz = this.generateStraightBranch(world, random, 5, locX + random.nextInt(2), h + i, locZ + random.nextInt(2), (firstDir + i) % 4);
            this.generateLeafLayerCircleNoise(world, random, 1.8, xyz[0], xyz[2], xyz[1] - 1);
            this.generateLeafLayerCircleNoise(world, random, 2.5, xyz[0], xyz[2], xyz[1]);
            this.generateLeafLayerCircleNoise(world, random, 1.8, xyz[0], xyz[2], xyz[1] + 1);
        }
        return true;
    }
}

