/*
 * Decompiled with CFR 0.152.
 */
package highlands.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMountain
extends WorldGenerator {
    private int minHeight;
    private int maxHeight;
    private int snowrocksand;
    private boolean notifyFlag;
    private World world;
    private Random random;

    public WorldGenMountain(int minH, int maxH, boolean notify, int type) {
        this.minHeight = minH;
        this.maxHeight = maxH;
        this.notifyFlag = notify;
        this.snowrocksand = type;
    }

    public boolean func_76484_a(World world, Random random, int locX, int locY, int locZ) {
        int height;
        this.world = world;
        this.random = random;
        int radius = height = this.minHeight + random.nextInt(this.maxHeight);
        for (int x = (int)Math.ceil(locX - radius); x <= (int)Math.ceil(locX + radius); ++x) {
            for (int z = (int)Math.ceil(locZ - radius); z <= (int)Math.ceil(locZ + radius); ++z) {
                Block block;
                double xfr = z - locZ;
                double zfr = x - locX;
                int dist = (int)Math.sqrt(xfr * xfr + zfr * zfr);
                if (dist > radius) continue;
                for (locY = world.func_72825_h(x, z); locY > 0 && ((block = world.func_147439_a(x, locY, z)) == null || !block.func_149662_c() || block.isWood((IBlockAccess)world, x, locY, z) || block.isLeaves((IBlockAccess)world, x, locY, z)); --locY) {
                }
                int h = locY + height - dist;
                for (int i = locY; i < h; ++i) {
                    if (this.snowrocksand == 0 && h - i < 4) {
                        this.setBlockInWorld(x, i, z, Blocks.field_150433_aE, 0);
                        continue;
                    }
                    if (this.snowrocksand == 2 && h - i < 4) {
                        this.setBlockInWorld(x, i, z, Blocks.field_150322_A, 0);
                        continue;
                    }
                    if (random.nextInt(3) == 0) {
                        this.setBlockInWorld(x, i, z, Blocks.field_150347_e, 0);
                        continue;
                    }
                    this.setBlockInWorld(x, i, z, Blocks.field_150348_b, 0);
                }
                if (this.snowrocksand != 0 || h <= 62) continue;
                this.setBlockInWorld(x, h, z, Blocks.field_150433_aE, 0);
            }
        }
        return true;
    }

    private void setBlockInWorld(int x, int y, int z, Block sandstone, int meta) {
        block4: {
            try {
                if (this.notifyFlag) {
                    this.world.func_147465_d(x, y, z, sandstone, meta, 3);
                } else {
                    this.world.func_147465_d(x, y, z, sandstone, meta, 2);
                }
            }
            catch (RuntimeException e) {
                if (!e.getMessage().equals("Already decorating!!")) break block4;
                System.out.println("Error: Highlands Mountain block couldn't generate!");
            }
        }
    }
}

