/*
 * Decompiled with CFR 0.152.
 */
package highlands;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import highlands.CommonProxy;
import highlands.Config;
import highlands.HighlandsEventManager;
import highlands.HighlandsFuelHandler;
import highlands.Initializer;
import highlands.MapGenStructureConfig;
import highlands.WorldTypeHighlands;
import highlands.api.HighlandsBiomes;
import highlands.integration.HighlandsCompatibilityManager;
import java.io.File;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="Highlands", name="Highlands", version="2.2.0", dependencies="after:Forestry;after:MineFactoryReloaded;after:Thaumcraft;after:BuildCraft|Transport")
public class Highlands {
    public static String modid = "Highlands";
    @Mod.Instance(value="Highlands")
    public static Highlands instance;
    @SidedProxy(clientSide="highlands.CommonProxy", serverSide="highlands.CommonProxy")
    public static CommonProxy proxy;
    public static WorldType HL;
    public static WorldType HLLB;
    public static int HighlandsBiomeSizeDefault;
    public static int HighlandsBiomeSizeLB;
    public static boolean mocreaturescomp;
    public static boolean improvedOceans;
    public static boolean borderBiomeFlag;
    public static boolean skyColorFlag;
    public static boolean vanillaBlocksFlag;
    public static boolean plantsFlag;
    public static int islandRarity;
    public static boolean highlandsInDefaultFlag;
    public static boolean useOreGens;
    public static boolean useGenLayers;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(new File(event.getModConfigurationDirectory() + File.separator + "Highlands" + File.separator + "General.cfg"));
        config.load();
        Config.setUpConfig(config);
        config.save();
        Initializer.constructBlocks();
        Initializer.initRecipes();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        HighlandsBiomes.initBiomeArrays();
        Initializer.constructBiomes();
        Initializer.constructSettings();
        HL = new WorldTypeHighlands("Highlands");
        HLLB = new WorldTypeHighlands("HighlandsLB");
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new HighlandsEventManager());
        MinecraftForge.EVENT_BUS.register((Object)new HighlandsEventManager());
        for (BiomeGenBase i : HighlandsBiomes.biomesForDefault) {
            WorldChunkManager.allowedBiomes.add(i);
        }
        if (WorldChunkManager.allowedBiomes.size() == 0) {
            WorldChunkManager.allowedBiomes.add(HighlandsBiomes.ocean2);
        }
        Initializer.setUpAllSubBiomes();
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        MapGenStructureConfig.postInit();
        HighlandsCompatibilityManager.registerBiomesForgeBiomeDict();
        GameRegistry.registerFuelHandler((IFuelHandler)new HighlandsFuelHandler());
        if (Loader.isModLoaded((String)"Forestry")) {
            try {
                HighlandsCompatibilityManager.registerBlocksForestry();
                HighlandsCompatibilityManager.registerRecipesForestry();
            }
            catch (Exception e) {
                System.err.println("[Highlands] Failed to enable Forestry compatibility because: ");
                e.printStackTrace();
            }
        }
    }

    static {
        mocreaturescomp = false;
        improvedOceans = true;
        borderBiomeFlag = true;
        skyColorFlag = false;
        vanillaBlocksFlag = false;
        plantsFlag = true;
        islandRarity = 14;
        highlandsInDefaultFlag = false;
        useOreGens = true;
        useGenLayers = true;
    }
}

