/*
 * Decompiled with CFR 0.152.
 */
package highlands.worldgen;

import highlands.Highlands;
import highlands.api.HighlandsBlocks;
import highlands.worldgen.WorldGenHighlandsTreeBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WorldGenTreeDiamondheart
extends WorldGenHighlandsTreeBase {
    public WorldGenTreeDiamondheart(int lmd, int wmd, Block wb, Block lb, int minH, int maxH, boolean notify) {
        super(lmd, wmd, wb, lb, notify);
        this.minHeight = minH;
        this.maxHeight = maxH;
    }

    public WorldGenTreeDiamondheart(int minH, int maxH, boolean notify) {
        this(0, 0, HighlandsBlocks.ironWood, HighlandsBlocks.acaciaLeaves, minH, maxH, notify);
        if (Highlands.vanillaBlocksFlag) {
            this.wood = Blocks.field_150364_r;
            this.leaves = Blocks.field_150362_t;
        }
    }

    @Override
    public boolean func_76484_a(World world, Random random, int locX, int locY, int locZ) {
        this.world = world;
        this.random = random;
        if (!this.isLegalTreePosition(world, locX, locY, locZ)) {
            return false;
        }
        if (!this.isCubeClear(locX, locY + 3, locZ, 8, 60)) {
            return false;
        }
        int treeHeight = this.minHeight + random.nextInt(this.maxHeight);
        double primaryRadius = 16.0;
        double finalRadius = 5.0;
        double secondaryRadius = 3.5;
        double finalRadius2 = 2.0;
        double angleRad = 0.0;
        for (int i = 0; i < treeHeight; ++i) {
            this.setBlockInWorld(locX, locY + i, locZ, this.wood, this.woodMeta);
            for (double j = angleRad; j < angleRad + Math.PI * 2; j += 0.7853981633974483) {
                int x = (int)(primaryRadius * Math.cos(j));
                int z = (int)(primaryRadius * Math.sin(j));
                this.generateWoodLayerCircle(world, random, secondaryRadius, x + locX, z + locZ, i + locY);
            }
            angleRad += 0.07853981633974483;
            primaryRadius -= (primaryRadius - finalRadius) / 15.0;
            secondaryRadius -= (secondaryRadius - finalRadius2) / 15.0;
        }
        return true;
    }
}

