/*
 * Decompiled with CFR 0.152.
 */
package highlands.worldgen;

import highlands.block.BlockHighlandsSapling;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public abstract class WorldGenHighlandsTreeBase
extends WorldGenAbstractTree {
    protected Block wood;
    protected Block leaves;
    protected int woodMeta;
    protected int leavesMeta;
    protected int type;
    protected int minHeight;
    protected int maxHeight;
    protected boolean notifyFlag;
    protected World world;
    protected Random random;
    protected int[][] directions = new int[][]{{1, 1}, {1, 0}, {1, -1}, {0, -1}, {-1, -1}, {-1, 0}, {-1, 1}, {0, 1}};

    public WorldGenHighlandsTreeBase(int lmd, int wmd, Block log, Block leaves, boolean notify) {
        super(true);
        this.wood = log;
        this.leaves = leaves;
        this.woodMeta = wmd;
        this.leavesMeta = lmd;
        this.notifyFlag = notify;
    }

    public abstract boolean func_76484_a(World var1, Random var2, int var3, int var4, int var5);

    public boolean isLegalTreePosition(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z) == Blocks.field_150349_c || world.func_147439_a(x, y - 1, z) == Blocks.field_150346_d;
    }

    public boolean generateReplaceSapling(World world, Random random, int locX, int locY, int locZ) {
        Block id = world.func_147439_a(locX, locY, locZ);
        int meta = world.func_72805_g(locX, locY, locZ);
        boolean flag = this.func_76484_a(world, random, locX, locY, locZ);
        if (!flag) {
            world.func_147465_d(locX, locY, locZ, id, meta, 3);
        }
        return flag;
    }

    protected void generateLeafLayerCircle(World world, Random random, double radius, int xo, int zo, int h) {
        for (int x = (int)Math.ceil((double)xo - radius); x <= (int)Math.ceil((double)xo + radius); ++x) {
            for (int z = (int)Math.ceil((double)zo - radius); z <= (int)Math.ceil((double)zo + radius); ++z) {
                double xfr = z - zo;
                double zfr = x - xo;
                if (!(xfr * xfr + zfr * zfr <= radius * radius)) continue;
                this.setBlockInWorld(x, h, z, this.leaves, this.leavesMeta);
            }
        }
    }

    protected void generateLeafLayerCircleNoise(World world, Random random, double radius, int xo, int zo, int h) {
        for (int x = (int)Math.ceil((double)xo - radius); x <= (int)Math.ceil((double)xo + radius); ++x) {
            for (int z = (int)Math.ceil((double)zo - radius); z <= (int)Math.ceil((double)zo + radius); ++z) {
                double xfr = z - zo;
                double zfr = x - xo;
                if (!(xfr * xfr + zfr * zfr <= radius * radius) || !(xfr * xfr + zfr * zfr <= (radius - 1.0) * (radius - 1.0)) && random.nextInt(2) != 0) continue;
                this.setBlockInWorld(x, h, z, this.leaves, this.leavesMeta);
            }
        }
    }

    protected void generateWoodLayerCircle(World world, Random random, double radius, int xo, int zo, int h) {
        for (int x = (int)Math.ceil((double)xo - radius); x <= (int)Math.ceil((double)xo + radius); ++x) {
            for (int z = (int)Math.ceil((double)zo - radius); z <= (int)Math.ceil((double)zo + radius); ++z) {
                double xfr = z - zo;
                double zfr = x - xo;
                if (!(xfr * xfr + zfr * zfr <= radius * radius)) continue;
                this.setBlockInWorld(x, h, z, this.wood, this.woodMeta);
            }
        }
    }

    protected int[] generateStraightBranch(World world, Random random, int length, int locX, int locY, int locZ, int dir) {
        int direction = -1;
        if (dir < 2) {
            direction = 1;
        }
        if (dir % 2 == 0) {
            for (int i = 1; i <= length; ++i) {
                this.setBlockInWorld(locX + i * direction, locY + i, locZ, this.wood, this.woodMeta + 4);
            }
            return new int[]{locX + length * direction, locY + length, locZ};
        }
        for (int i = 1; i <= length; ++i) {
            this.setBlockInWorld(locX, locY + i, locZ + i * direction, this.wood, this.woodMeta + 8);
        }
        return new int[]{locX, locY + length, locZ + length * direction};
    }

    protected int[] generateStraightBranchDown(World world, Random random, int length, int locX, int locY, int locZ, int dir) {
        int direction = -1;
        if (dir < 2) {
            direction = 1;
        }
        if (dir % 2 == 0) {
            for (int i = 1; i <= length; ++i) {
                this.setBlockInWorld(locX + i * direction, locY + i, locZ, this.wood, this.woodMeta + 4);
            }
            return new int[]{locX + length * direction, locY - length, locZ};
        }
        for (int i = 1; i <= length; ++i) {
            this.setBlockInWorld(locX, locY + i, locZ + i * direction, this.wood, this.woodMeta + 8);
        }
        return new int[]{locX, locY - length, locZ + length * direction};
    }

    protected void generateSequoiaBranch(World world, Random random, double length, int xo, int zo, int h) {
        int i = 0;
        while ((double)i < length) {
            int j = i - 3;
            this.setBlockInWorld(xo + i, h, zo, this.wood, this.woodMeta + 4);
            if (length > 3.0 && j > 0 && (double)i < length - 1.0) {
                this.setBlockInWorld(xo + i, h, zo + j, this.wood, this.woodMeta + 8);
                this.setBlockInWorld(xo + i, h, zo - j, this.wood, this.woodMeta + 8);
            }
            this.setBlockInWorld(xo, h, zo + i, this.wood, this.woodMeta + 8);
            if (length > 3.0 && j > 0 && (double)i < length - 1.0) {
                this.setBlockInWorld(xo + j, h, zo + i, this.wood, this.woodMeta + 4);
                this.setBlockInWorld(xo - j, h, zo + i, this.wood, this.woodMeta + 4);
            }
            this.setBlockInWorld(xo - i, h, zo, this.wood, this.woodMeta + 4);
            if (length > 3.0 && j > 0 && (double)i < length - 1.0) {
                this.setBlockInWorld(xo - i, h, zo + j, this.wood, this.woodMeta + 8);
                this.setBlockInWorld(xo - i, h, zo - j, this.wood, this.woodMeta + 8);
            }
            this.setBlockInWorld(xo, h, zo - i, this.wood, this.woodMeta + 8);
            if (length > 3.0 && j > 0 && (double)i < length - 1.0) {
                this.setBlockInWorld(xo + j, h, zo - i, this.wood, this.woodMeta + 4);
                this.setBlockInWorld(xo - j, h, zo - i, this.wood, this.woodMeta + 4);
            }
            if ((double)i == length - 2.0) {
                double lr = 3.5;
                this.generateLeafLayerCircleNoise(world, random, lr, xo + i, zo, h + 1);
                this.generateLeafLayerCircleNoise(world, random, lr, xo - i, zo, h + 1);
                this.generateLeafLayerCircleNoise(world, random, lr, xo, zo + i, h + 1);
                this.generateLeafLayerCircleNoise(world, random, lr, xo, zo - i, h + 1);
                this.generateLeafLayerCircleNoise(world, random, lr -= 1.0, xo + i, zo, h + 2);
                this.generateLeafLayerCircleNoise(world, random, lr, xo - i, zo, h + 2);
                this.generateLeafLayerCircleNoise(world, random, lr, xo, zo + i, h + 2);
                this.generateLeafLayerCircleNoise(world, random, lr, xo, zo - i, h + 2);
            }
            ++i;
        }
    }

    protected void setBlockInWorld(int x, int y, int z, Block block, int meta) {
        block9: {
            try {
                Block bl = this.world.func_147439_a(x, y, z);
                if (block == this.wood && (this.world.func_147437_c(x, y, z) || bl.isReplaceable((IBlockAccess)this.world, x, y, z) || bl.isLeaves((IBlockAccess)this.world, x, y, z) || bl instanceof BlockHighlandsSapling)) {
                    if (this.notifyFlag) {
                        this.world.func_147465_d(x, y, z, block, meta, 3);
                    } else {
                        this.world.func_147465_d(x, y, z, block, meta, 2);
                    }
                } else if (block == this.leaves && this.world.func_147437_c(x, y, z)) {
                    if (this.notifyFlag) {
                        this.world.func_147465_d(x, y, z, block, meta, 3);
                    } else {
                        this.world.func_147465_d(x, y, z, block, meta, 2);
                    }
                }
            }
            catch (RuntimeException e) {
                if (!e.getMessage().equals("Already decorating!!")) break block9;
                System.out.println("Error: Tree block couldn't generate!");
            }
        }
    }

    protected boolean isCubeClear(int x, int y, int z, int radius, int height) {
        for (int i = x - radius; i <= x + radius; ++i) {
            for (int j = z - radius; j <= z + radius; ++j) {
                for (int k = y; k <= y + height; ++k) {
                    if (this.world.func_147439_a(i, k, j) == Blocks.field_150350_a || this.world.func_147439_a(i, k, j).isLeaves((IBlockAccess)this.world, i, k, j)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected int findTopBlock(int x, int z) {
        int y;
        boolean var6 = false;
        for (y = 256; (this.world.func_147439_a(x, y, z) == Blocks.field_150350_a || this.world.func_147439_a(x, y, z).isLeaves((IBlockAccess)this.world, x, y, z)) && y > 0; --y) {
        }
        return y;
    }
}

