/*
 * Decompiled with CFR 0.152.
 */
package gravestone.structures.memorials;

import gravestone.GraveStoneLogger;
import gravestone.config.GraveStoneConfig;
import gravestone.structures.GSStructureGenerator;
import gravestone.structures.catacombs.CatacombsGenerator;
import gravestone.structures.memorials.ComponentGSMemorial;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class MemorialGenerator
implements GSStructureGenerator {
    private static MemorialGenerator instance;
    public static final double CHANCE = 0.05;
    public static final short RANGE = 400;
    private static LinkedList<ChunkCoordIntPair> structuresList;

    private MemorialGenerator() {
        instance = this;
    }

    public static MemorialGenerator getInstance() {
        if (instance == null) {
            return new MemorialGenerator();
        }
        return instance;
    }

    @Override
    public boolean generate(World world, Random rand, int x, int z, double chance, boolean isCommand) {
        if (!isCommand) {
            x += 6;
            z += 6;
        }
        if (isCommand || GraveStoneConfig.generateMemorials && MemorialGenerator.canSpawnStructureAtCoords(world, x, z, chance) && MemorialGenerator.isNoWarterUnder(world, x, z)) {
            new ComponentGSMemorial(rand.nextInt(4), rand, x, z).addComponentParts(world, rand);
            GraveStoneLogger.logInfo("Generate memorial at " + x + "x" + z);
            structuresList.add(new ChunkCoordIntPair(x, z));
            return true;
        }
        return false;
    }

    protected static boolean canSpawnStructureAtCoords(World world, int x, int z, double chance) {
        return chance < 0.05 && MemorialGenerator.isBiomeAllowed(world, x, z) && MemorialGenerator.noAnyInRange(x, z);
    }

    protected static boolean isBiomeAllowed(World world, int x, int z) {
        LinkedList<BiomeDictionary.Type> biomeTypesList = new LinkedList<BiomeDictionary.Type>(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)world.func_72807_a(x, z))));
        return !biomeTypesList.contains(BiomeDictionary.Type.WATER);
    }

    protected static boolean noAnyInRange(int x, int z) {
        for (ChunkCoordIntPair position : structuresList) {
            if (position.field_77276_a <= x - 400 || position.field_77276_a >= x + 400 || position.field_77275_b <= z - 400 || position.field_77275_b >= z + 400) continue;
            return false;
        }
        for (ChunkCoordIntPair position : CatacombsGenerator.getStructuresList()) {
            if (position.field_77276_a <= x - 100 || position.field_77276_a >= x + 100 || position.field_77275_b <= z - 100 || position.field_77275_b >= z + 100) continue;
            return false;
        }
        return true;
    }

    public static LinkedList<ChunkCoordIntPair> getStructuresList() {
        return structuresList;
    }

    private static boolean isNoWarterUnder(World world, int x, int z) {
        int y = world.func_72825_h(x, z);
        return !world.func_147439_a(x, y, z).func_149688_o().equals(Material.field_151586_h);
    }

    static {
        structuresList = new LinkedList();
    }
}

