/*
 * Decompiled with CFR 0.152.
 */
package gravestone.structures.graves;

import gravestone.config.GraveStoneConfig;
import gravestone.structures.GSStructureGenerator;
import gravestone.structures.catacombs.CatacombsGenerator;
import gravestone.structures.graves.ComponentGSSingleGrave;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class SingleGraveGenerator
implements GSStructureGenerator {
    private static SingleGraveGenerator instance;
    public static final double CHANCE = 0.1;
    public static final byte RANGE = 100;
    private static LinkedList<ChunkCoordIntPair> structuresList;

    private SingleGraveGenerator() {
        instance = this;
    }

    public static SingleGraveGenerator getInstance() {
        if (instance == null) {
            return new SingleGraveGenerator();
        }
        return instance;
    }

    @Override
    public boolean generate(World world, Random rand, int x, int z, double chance, boolean isCommand) {
        if (isCommand || GraveStoneConfig.generateSingleGraves && SingleGraveGenerator.canSpawnStructureAtCoords(world, x, z, chance)) {
            if (!isCommand) {
                x += 7;
                z += 7;
            }
            new ComponentGSSingleGrave(rand.nextInt(4), rand, x, z).addComponentParts(world, rand);
            structuresList.add(new ChunkCoordIntPair(x, z));
            return true;
        }
        return false;
    }

    protected static boolean canSpawnStructureAtCoords(World world, int x, int z, double chance) {
        return chance < 0.1 && SingleGraveGenerator.isBiomeAllowed(world, x, z) && SingleGraveGenerator.noAnyInRange(x, z);
    }

    protected static boolean isBiomeAllowed(World world, int x, int z) {
        LinkedList<BiomeDictionary.Type> biomeTypesList = new LinkedList<BiomeDictionary.Type>(Arrays.asList(BiomeDictionary.getTypesForBiome((BiomeGenBase)world.func_72807_a(x, z))));
        return !biomeTypesList.contains(BiomeDictionary.Type.WATER);
    }

    protected static boolean noAnyInRange(int x, int z) {
        for (ChunkCoordIntPair position : structuresList) {
            if (position.field_77276_a <= x - 100 || position.field_77276_a >= x + 100 || position.field_77275_b <= z - 100 || position.field_77275_b >= z + 100) continue;
            return false;
        }
        for (ChunkCoordIntPair position : CatacombsGenerator.getStructuresList()) {
            if (position.field_77276_a <= x - 100 || position.field_77276_a >= x + 100 || position.field_77275_b <= z - 100 || position.field_77275_b >= z + 100) continue;
            return false;
        }
        return true;
    }

    public static LinkedList<ChunkCoordIntPair> getStructuresList() {
        return structuresList;
    }

    static {
        structuresList = new LinkedList();
    }
}

