/*
 * Decompiled with CFR 0.152.
 */
package gravestone.core.compatibility;

import gravestone.GraveStoneLogger;
import gravestone.config.GraveStoneConfig;
import gravestone.core.GSMobSpawn;
import java.lang.reflect.Constructor;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.World;

public class GSCompatibilityMoCreatures {
    protected static boolean isInstalled = false;
    public static final String MO_CREATURES_S_SKELETON = "drzhark.mocreatures.entity.monster.MoCEntitySilverSkeleton";
    public static final String MO_CREATURES_WRAITH = "drzhark.mocreatures.entity.monster.MoCEntityWraith";
    public static final String MO_CREATURES_F_WRAITH = "drzhark.mocreatures.entity.monster.MoCEntityFlameWraith";
    public static final String MO_CREATURES_SCORPIONS = "drzhark.mocreatures.entity.monster.MoCEntityScorpion";

    private GSCompatibilityMoCreatures() {
    }

    public static void addMobs() {
        if (GraveStoneConfig.spawnMoCreaturesMobs) {
            GraveStoneLogger.logInfo("start Mo'Creatures mobs loading");
            GSCompatibilityMoCreatures.addMobToList(GSMobSpawn.MOB_ID, "SilverSkeleton", GSCompatibilityMoCreatures.getForeinMobConstructor(MO_CREATURES_S_SKELETON));
            GSCompatibilityMoCreatures.addMobToList(GSMobSpawn.MOB_ID, "Wraith", GSCompatibilityMoCreatures.getForeinMobConstructor(MO_CREATURES_WRAITH));
            GSCompatibilityMoCreatures.addMobToList(GSMobSpawn.HELL_MOB_ID, "FlameWraith", GSCompatibilityMoCreatures.getForeinMobConstructor(MO_CREATURES_F_WRAITH));
            GSCompatibilityMoCreatures.addMobToList(GSMobSpawn.skeletonSpawnerMobs, "SilverSkeleton", GSCompatibilityMoCreatures.getForeinMobConstructor(MO_CREATURES_S_SKELETON));
            GraveStoneLogger.logInfo("end Mo'Creatures mobs loading");
        }
    }

    private static Constructor getForeinMobConstructor(String path) {
        Constructor<?> constructor = null;
        try {
            Class<?> mobClass = Class.forName(path);
            constructor = mobClass.getConstructor(World.class);
        }
        catch (ClassNotFoundException e) {
            GraveStoneLogger.logError("getForeinMobConstructor ClassNotFoundException. class path " + path);
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            GraveStoneLogger.logError("getForeinMobConstructor NoSuchMethodException. class path " + path);
            e.printStackTrace();
        }
        return constructor;
    }

    private static void addMobToList(List<String> MOB_ID, String mobName, Constructor<EntityLiving> constructor) {
        if (constructor != null) {
            MOB_ID.add(mobName);
            GSMobSpawn.mobNameToClassMapping.put(mobName, constructor);
        }
    }

    public static boolean isLoaded() {
        return isInstalled;
    }
}

