/*
 * Decompiled with CFR 0.152.
 */
package gravestone.core;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.LanguageRegistry;
import gravestone.block.BlockGSAltar;
import gravestone.block.BlockGSBoneBlock;
import gravestone.block.BlockGSBoneSlab;
import gravestone.block.BlockGSBoneStairs;
import gravestone.block.BlockGSCandle;
import gravestone.block.BlockGSGraveStone;
import gravestone.block.BlockGSHauntedChest;
import gravestone.block.BlockGSMemorial;
import gravestone.block.BlockGSSkullCandle;
import gravestone.block.BlockGSSpawner;
import gravestone.block.BlockGSTrap;
import gravestone.block.GraveStoneHelper;
import gravestone.block.enums.EnumBoneBlock;
import gravestone.block.enums.EnumGraves;
import gravestone.block.enums.EnumHauntedChest;
import gravestone.block.enums.EnumMemorials;
import gravestone.block.enums.EnumSkullCandle;
import gravestone.block.enums.EnumSpawner;
import gravestone.block.enums.EnumTrap;
import gravestone.block.enums.IBlockEnum;
import gravestone.item.ItemBlockGSBoneBlock;
import gravestone.item.ItemBlockGSCandle;
import gravestone.item.ItemBlockGSGraveStone;
import gravestone.item.ItemBlockGSHauntedChest;
import gravestone.item.ItemBlockGSMemorial;
import gravestone.item.ItemBlockGSSkullCandle;
import gravestone.item.ItemBlockGSSpawner;
import gravestone.item.ItemBlockGSTrap;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GSBlock {
    public static BlockGSGraveStone graveStone;
    public static BlockGSSpawner spawner;
    public static BlockGSTrap trap;
    public static BlockGSMemorial memorial;
    public static BlockGSBoneBlock boneBlock;
    public static BlockGSBoneSlab boneSlab;
    public static BlockGSBoneStairs boneStairs;
    public static BlockGSHauntedChest hauntedChest;
    public static BlockGSCandle candle;
    public static BlockGSSkullCandle skullCandle;
    public static BlockGSAltar altar;

    private GSBlock() {
    }

    public static void registration() {
        graveStone = new BlockGSGraveStone();
        GameRegistry.registerBlock((Block)graveStone, ItemBlockGSGraveStone.class, (String)"GSGraveStone");
        for (byte i = 0; i < EnumGraves.values().length; i = (byte)(i + 1)) {
            ItemStack graveStoneStack = new ItemStack((Block)graveStone, 1, 0);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("GraveType", i);
            if (GraveStoneHelper.isSwordGrave(i)) {
                nbt.func_74774_a("SwordType", GraveStoneHelper.oldGraveTypeToSwordType(i));
            }
            graveStoneStack.func_77982_d(nbt);
            LanguageRegistry.addName((Object)graveStoneStack, (String)EnumGraves.values()[i].getName());
        }
        memorial = new BlockGSMemorial();
        GSBlock.advancedNTBBlockRegistration((Block)memorial, "GSMemorial", "Memorial", EnumMemorials.values(), "GraveType", ItemBlockGSMemorial.class);
        spawner = new BlockGSSpawner();
        GSBlock.advancedMetaBlockRegistration((Block)spawner, ItemBlockGSSpawner.class, "GSSpawner", EnumSpawner.values());
        trap = new BlockGSTrap();
        GSBlock.advancedMetaBlockRegistration(trap, ItemBlockGSTrap.class, "GSTrap", EnumTrap.values());
        boneBlock = new BlockGSBoneBlock();
        GSBlock.advancedMetaBlockRegistration(boneBlock, ItemBlockGSBoneBlock.class, "GSBoneBlock", EnumBoneBlock.values());
        boneSlab = new BlockGSBoneSlab();
        GSBlock.simpleBlockRegistration((Block)boneSlab, "GSBoneSlab", "Bone slab");
        boneStairs = new BlockGSBoneStairs();
        GSBlock.simpleBlockRegistration((Block)boneStairs, "GSBoneStairs", "Bone stairs");
        hauntedChest = new BlockGSHauntedChest();
        GSBlock.advancedNTBBlockRegistration((Block)hauntedChest, "GSHauntedChest", "Haunted chest", EnumHauntedChest.values(), "ChestType", ItemBlockGSHauntedChest.class);
        candle = new BlockGSCandle();
        GSBlock.simpleBlockRegistration((Block)candle, "Candle", ItemBlockGSCandle.class, "GSCandle");
        skullCandle = new BlockGSSkullCandle();
        GSBlock.advancedMetaBlockRegistration((Block)skullCandle, ItemBlockGSSkullCandle.class, "GSSkullCandle", EnumSkullCandle.values());
        altar = new BlockGSAltar();
        GSBlock.simpleBlockRegistration(altar, "GSAltar", "Altar");
    }

    private static void simpleBlockRegistration(Block block, String name, Class itemClass, String registerName) {
        GameRegistry.registerBlock((Block)block, (Class)itemClass, (String)registerName);
        LanguageRegistry.addName((Object)block, (String)name);
    }

    private static void simpleBlockRegistration(Block block, String registerName, String name) {
        GameRegistry.registerBlock((Block)block, (String)registerName);
        LanguageRegistry.addName((Object)block, (String)name);
    }

    private static void advancedMetaBlockRegistration(Block block, Class itemClass, String registerName, IBlockEnum[] blockEnums) {
        GameRegistry.registerBlock((Block)block, (Class)itemClass, (String)registerName);
        GSBlock.subMetaBlocksRegistration(block, blockEnums);
    }

    private static void advancedNTBBlockRegistration(Block block, String registerName, String name, IBlockEnum[] blockEnums, String nbtName) {
        GSBlock.simpleBlockRegistration(block, registerName, name);
        GSBlock.subNTBBlocksRegistration(block, blockEnums, nbtName);
    }

    private static void advancedNTBBlockRegistration(Block block, String registerName, String name, IBlockEnum[] blockEnums, String nbtName, Class itemClass) {
        GameRegistry.registerBlock((Block)block, (Class)itemClass, (String)registerName);
        LanguageRegistry.addName((Object)block, (String)name);
        GSBlock.subNTBBlocksRegistration(block, blockEnums, nbtName);
    }

    private static void subMetaBlocksRegistration(Block block, IBlockEnum[] blockEnums) {
        for (int meta = 0; meta < blockEnums.length; meta = (int)((byte)(meta + 1))) {
            LanguageRegistry.addName((Object)new ItemStack(block, 1, meta), (String)blockEnums[meta].getName());
        }
    }

    private static void subNTBBlocksRegistration(Block block, IBlockEnum[] blockEnums, String nbtName) {
        for (byte i = 0; i < blockEnums.length; i = (byte)(i + 1)) {
            ItemStack stack = new ItemStack(block, 1, 0);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a(nbtName, i);
            stack.func_77982_d(nbt);
            LanguageRegistry.addName((Object)stack, (String)blockEnums[i].getName());
        }
    }
}

