/*
 * Decompiled with CFR 0.152.
 */
package gravestone.config;

import cpw.mods.fml.client.registry.RenderingRegistry;
import gravestone.config.GravesDefaultText;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class GraveStoneConfig {
    private static Configuration config;
    private static GraveStoneConfig instance;
    private static String path;
    public static int graveRenderID;
    public static int memorialRenderID;
    public static int spawnerRenderID;
    public static int skullCandleRenderID;
    public static int candleRenderID;
    public static boolean generateCatacombs;
    public static boolean generateSingleGraves;
    public static boolean generateMemorials;
    public static int maxCatacombsHeight;
    public static boolean generateCemeteries;
    public static boolean generateVillageMemorials;
    public static boolean generateUndertaker;
    public static boolean generatePlayerGraves;
    public static boolean generateVillagerGraves;
    public static boolean generatePetGraves;
    public static boolean generateGravesInLava;
    public static int graveItemsCount;
    public static int graveSpawnRate;
    public static boolean silkTouchForGraves;
    public static boolean canPlaceGravesEveryWhere;
    public static boolean enableNightStone;
    public static boolean enableThunderStone;
    public static boolean showNightStoneMessage;
    public static boolean enableBossSpawnerCraftingRecipe;
    public static boolean enableSpawnerCraftingRecipe;
    public static boolean replaceHauntedChest;
    public static ArrayList<String> graveNames;
    public static ArrayList<String> graveDogsNames;
    public static ArrayList<String> graveCatsNames;
    public static ArrayList<String> graveDeathMessages;
    public static ArrayList<String> memorialText;
    public static ArrayList<String> dogsMemorialText;
    public static ArrayList<String> catsMemorialText;
    public static boolean spawnZombieDogs;
    public static boolean spawnZombieCats;
    public static boolean spawnSkeletonDogs;
    public static boolean spawnSkeletonCats;
    public static boolean spawnSkullCrawlersAtMobsDeath;
    public static boolean spawnSkullCrawlersAtBoneBlockDestruction;
    public static boolean spawnMoCreaturesMobs;
    public static boolean generateSwordGraves;
    public static int spawnChance;
    public static boolean removeEmptyGraves;
    public static boolean showGravesRemovingMessages;

    private GraveStoneConfig(String path, File configFile) {
        config = new Configuration(configFile);
        GraveStoneConfig.path = path;
        this.getConfigs();
    }

    public static GraveStoneConfig getInstance(String path, String configFile) {
        if (instance == null) {
            return new GraveStoneConfig(path, new File(path + configFile));
        }
        return instance;
    }

    public final void getConfigs() {
        config.load();
        GraveStoneConfig.structures();
        GraveStoneConfig.gravesConfig();
        GraveStoneConfig.entityConfig();
        config.save();
        this.getGravesText();
    }

    private static void structures() {
        generateCatacombs = config.get("general", "GenerateCatacombs", true).getBoolean(true);
        maxCatacombsHeight = config.get("general", "MaximumCatacombsGenerationHeight", 75).getInt();
        generateMemorials = config.get("general", "GenerateMemorials", true).getBoolean(true);
        generateSingleGraves = config.get("general", "GenerateSingleGraves", true).getBoolean(true);
        generateCemeteries = config.get("general", "GenerateCemeteries", true).getBoolean(true);
        generateVillageMemorials = config.get("general", "GenerateVillageMemorials", true).getBoolean(true);
        generateUndertaker = config.get("general", "GenerateUndertaker", true).getBoolean(true);
    }

    private static void gravesConfig() {
        silkTouchForGraves = config.get("general", "SilkTouchForGraves", true).getBoolean(true);
        canPlaceGravesEveryWhere = config.get("general", "CanPlaceGravesEveryWhere", false).getBoolean(false);
        generatePlayerGraves = config.get("general", "GeneratePlayerGraves", true).getBoolean(true);
        generateVillagerGraves = config.get("general", "GenerateVillagerGraves", true).getBoolean(true);
        generatePetGraves = config.get("general", "GeneratePetGraves", true).getBoolean(true);
        generateGravesInLava = config.get("general", "GenerateGravesInLava", true).getBoolean(true);
        generateSwordGraves = config.get("general", "GenerateSwordGraves", true).getBoolean(true);
        Property graveItemsCountProperty = config.get("general", "SavedItemsCount", 40);
        graveItemsCountProperty.comment = "This value must be between 0 an 40(in this case all items will be stored)!";
        graveItemsCount = graveItemsCountProperty.getInt();
        if (graveItemsCount > 40 || graveItemsCount < 0) {
            graveItemsCount = 40;
        }
        Property graveSpawnRateProperty = config.get("general", "SpawnRate", 1000);
        graveSpawnRateProperty.comment = "This value must be bigger than 600!";
        graveSpawnRate = graveSpawnRateProperty.getInt();
        if (graveSpawnRate < 600) {
            graveSpawnRate = 600;
        }
        spawnChance = config.get("general", "SpawnChance", 80).getInt();
        spawnMoCreaturesMobs = config.get("general", "SpawnMoCreaturesMobsByGraves", true).getBoolean(true);
        enableNightStone = config.get("general", "EnableNightStone", true).getBoolean(true);
        enableThunderStone = config.get("general", "EnableThunderStone", true).getBoolean(true);
        showNightStoneMessage = config.get("general", "ShowNightStoneMessage", true).getBoolean(true);
        enableBossSpawnerCraftingRecipe = config.get("general", "EnableBossSpawnerCraftingRecipe", true).getBoolean(true);
        enableSpawnerCraftingRecipe = config.get("general", "EnableMonsterSpawnerCraftingRecipe", true).getBoolean(true);
        replaceHauntedChest = config.get("general", "ReplaceHauntedChest", false).getBoolean(false);
        removeEmptyGraves = config.get("general", "RemoveEmptyGraves", false).getBoolean(false);
        showGravesRemovingMessages = config.get("general", "ShowGravesRemovingMessages", true).getBoolean(true);
    }

    private static void entityConfig() {
        spawnZombieDogs = config.get("general", "SpawnZombieDogs", true).getBoolean(true);
        spawnZombieCats = config.get("general", "SpawnZombieCats", true).getBoolean(true);
        spawnSkeletonDogs = config.get("general", "SpawnSkeletonDogs", true).getBoolean(true);
        spawnSkeletonCats = config.get("general", "SpawnSkeletonCats", true).getBoolean(true);
        spawnSkullCrawlersAtMobsDeath = config.get("general", "SpawnSkullCrawlersAtMobsDeath", true).getBoolean(true);
        spawnSkullCrawlersAtBoneBlockDestruction = config.get("general", "SpawnSkullCrawlersOnBoneBlockDestruction", true).getBoolean(true);
    }

    private void getGravesText() {
        graveNames = GraveStoneConfig.readStringsFromFile(path + "graveNames.txt", GravesDefaultText.NAMES);
        graveDogsNames = GraveStoneConfig.readStringsFromFile(path + "graveDogsNames.txt", GravesDefaultText.DOG_NAMES);
        graveCatsNames = GraveStoneConfig.readStringsFromFile(path + "graveCatsNames.txt", GravesDefaultText.CAT_NAMES);
        graveDeathMessages = GraveStoneConfig.readStringsFromFile(path + "graveDeathMessages.txt", GravesDefaultText.DEATH_TEXT);
        memorialText = GraveStoneConfig.readStringsFromFile(path + "memorialText.txt", GravesDefaultText.MEMORIAL_TEXT);
        dogsMemorialText = GraveStoneConfig.readStringsFromFile(path + "dogsMemorialText.txt", GravesDefaultText.DOGS_MEMORIAL_TEXT);
        catsMemorialText = GraveStoneConfig.readStringsFromFile(path + "catsMemorialText.txt", GravesDefaultText.CATS_MEMORIAL_TEXT);
    }

    private static ArrayList<String> readStringsFromFile(String fileName, String[] defaultValues) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(defaultValues));
        return list;
    }

    static {
        graveRenderID = RenderingRegistry.getNextAvailableRenderId();
        memorialRenderID = RenderingRegistry.getNextAvailableRenderId();
        spawnerRenderID = RenderingRegistry.getNextAvailableRenderId();
        skullCandleRenderID = RenderingRegistry.getNextAvailableRenderId();
        candleRenderID = RenderingRegistry.getNextAvailableRenderId();
    }
}

