/*
 * Decompiled with CFR 0.152.
 */
package gravestone.tileentity;

import gravestone.block.enums.EnumHauntedChest;
import gravestone.config.GraveStoneConfig;
import gravestone.core.GSMobSpawn;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityGSHauntedChest
extends TileEntity {
    private int openTicks = 0;
    private boolean isOpen = false;
    public float lidAngle;
    public float prevLidAngle;
    private EnumHauntedChest chestType = EnumHauntedChest.BATS_CHEST;

    public void func_145845_h() {
        super.func_145845_h();
        if (this.openTicks > 0) {
            --this.openTicks;
        }
        if (this.field_145850_b.field_72995_K) {
            double d0;
            this.prevLidAngle = this.lidAngle;
            float f = 0.1f;
            if (this.openTicks > 0 && this.lidAngle == 0.0f) {
                double d1 = (double)this.field_145851_c + 0.5;
                d0 = (double)this.field_145849_e + 0.5;
                this.field_145850_b.func_72908_a(d1, (double)this.field_145848_d + 0.5, d0, "random.chestopen", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.openTicks == 0 && this.lidAngle > 0.0f || this.openTicks > 0 && this.lidAngle < 1.0f) {
                float f2;
                float f1 = this.lidAngle;
                this.lidAngle = this.openTicks > 0 ? (this.lidAngle += f) : (this.lidAngle -= f);
                if (this.lidAngle > 1.0f) {
                    this.lidAngle = 1.0f;
                }
                if (this.lidAngle < (f2 = 0.5f) && f1 >= f2) {
                    d0 = (double)this.field_145851_c + 0.5;
                    double d2 = (double)this.field_145849_e + 0.5;
                    this.field_145850_b.func_72908_a(d0, (double)this.field_145848_d + 0.5, d2, "random.chestclosed", 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
                if (this.lidAngle < 0.0f) {
                    this.lidAngle = 0.0f;
                }
            }
        } else if (this.openTicks == 45) {
            this.spawnMobs(this.field_145850_b);
        }
        if (this.openTicks == 0) {
            if (this.isOpen && GraveStoneConfig.replaceHauntedChest) {
                int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.func_145831_w().func_147475_p(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.func_145831_w().func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150486_ae);
                this.func_145831_w().func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, 2);
            }
            this.isOpen = false;
        }
    }

    public void openChest() {
        if (this.openTicks == 0) {
            this.openTicks = 50;
            this.isOpen = true;
        }
    }

    public EnumHauntedChest getChestType() {
        return this.chestType;
    }

    public void setChestType(EnumHauntedChest chestType) {
        this.chestType = chestType;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.chestType = EnumHauntedChest.getById(nbt.func_74771_c("ChestType"));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("ChestType", (byte)this.chestType.ordinal());
    }

    public void spawnMobs(World world) {
        switch (this.getChestType()) {
            case SKELETON_CHEST: {
                EntitySkeleton skeleton = GSMobSpawn.getSkeleton(world, (byte)1);
                skeleton.func_70012_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5, 0.0f, 0.0f);
                world.func_72838_d((Entity)skeleton);
                break;
            }
            default: {
                int batsCount = 15;
                for (int i = 0; i < batsCount; i = (int)((byte)(i + 1))) {
                    EntityBat bat = new EntityBat(world);
                    bat.func_70012_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.7, (double)this.field_145849_e + 0.5, 0.0f, 0.0f);
                    world.func_72838_d((Entity)bat);
                }
            }
        }
    }
}

