/*
 * Decompiled with CFR 0.152.
 */
package gravestone.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravestone.tileentity.GSGraveStoneDeathText;
import gravestone.tileentity.GSGraveStoneItems;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public abstract class TileEntityGSGrave
extends TileEntity {
    protected GSGraveStoneItems gSItems;
    protected GSGraveStoneDeathText gSDeathText = new GSGraveStoneDeathText(this);
    protected boolean isEditable = true;
    protected boolean isEnchanted = false;
    protected byte graveType = 0;
    protected int age = -1;

    public void setGraveType(byte graveType) {
        this.graveType = graveType;
    }

    public byte getGraveTypeNum() {
        return this.graveType;
    }

    protected void readType(NBTTagCompound nbtTag) {
        this.graveType = nbtTag.func_74771_c("GraveType");
    }

    protected void saveType(NBTTagCompound nbtTag) {
        nbtTag.func_74774_a("GraveType", this.graveType);
    }

    public void setGraveContent(Random random, boolean isPetGrave, boolean allLoot) {
        this.gSDeathText.setRandomDeathTextAndName(random, this.graveType, false);
        this.gSItems.setRandomGraveContent(random, isPetGrave, allLoot);
        this.setRandomAge();
    }

    public String getInvName() {
        return "container.gravestone";
    }

    public void setItems(List<ItemStack> items) {
        this.gSItems.setItems(items);
    }

    public void setAdditionalItems(ItemStack[] items) {
        this.gSItems.setAdditionalItems(items);
    }

    public void dropAllItems() {
        this.gSItems.dropAllItems();
    }

    public void clearInventory() {
        this.gSItems.graveContents.clear();
    }

    public GSGraveStoneDeathText getDeathTextComponent() {
        return this.gSDeathText;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    protected void setRandomAge() {
        this.age = 10 + new Random().nextInt(100);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public boolean isEnchanted() {
        return this.isEnchanted;
    }

    public void setEnchanted(boolean isEnchanted) {
        this.isEnchanted = isEnchanted;
    }

    @SideOnly(value=Side.CLIENT)
    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public void func_145839_a(NBTTagCompound nbtTag) {
        super.func_145839_a(nbtTag);
        if (nbtTag.func_74764_b("Enchanted")) {
            this.isEnchanted = nbtTag.func_74767_n("Enchanted");
        }
    }

    public void func_145841_b(NBTTagCompound nbtTag) {
        super.func_145841_b(nbtTag);
        nbtTag.func_74757_a("Enchanted", this.isEnchanted);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }
}

