/*
 * Decompiled with CFR 0.152.
 */
package gravestone.structures.catacombs.components;

import gravestone.structures.BoundingBoxHelper;
import gravestone.structures.catacombs.components.CatacombsBaseComponent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class Fence
extends CatacombsBaseComponent {
    private final boolean haveEntrance;
    private final boolean haveCorners;

    public Fence(int direction, Random random, StructureBoundingBox structureBoundingBox, boolean haveEntrance, boolean haveCorners) {
        super(direction);
        this.field_74887_e = structureBoundingBox;
        this.haveEntrance = haveEntrance;
        this.haveCorners = haveCorners;
    }

    @Override
    public boolean addComponentParts(World world, Random random) {
        if (this.haveEntrance) {
            this.createEntrance(world, random);
        } else {
            this.createCenterFence(world, random);
        }
        for (int i = 0; i < 10; ++i) {
            this.createPartOfFence(world, random, FENCE_DIRECTION.RIGHT, i * 4 + 48);
            this.createPartOfFence(world, random, FENCE_DIRECTION.LEFT, 41 - i * 4);
        }
        this.createGrate(world, 1);
        this.createGrate(world, 88);
        if (this.haveCorners) {
            this.createCornerFence(world, random, true);
            this.createCornerFence(world, random, false);
        }
        return true;
    }

    private void createPartOfFence(World world, Random random, FENCE_DIRECTION direction, int x) {
        switch (direction) {
            case LEFT: {
                this.createGrate(world, x);
                this.createGrate(world, x - 1);
                this.createGrate(world, x - 2);
                int y = this.getGroundY(world, x - 3);
                if (!this.checkGround(world, x - 3, y)) break;
                this.func_74882_a(world, this.field_74887_e, x - 3, y, 0, x - 3, y + 3, 0, false, random, this.getCemeteryCatacombsStones());
                break;
            }
            case RIGHT: {
                this.createGrate(world, x);
                this.createGrate(world, x + 1);
                this.createGrate(world, x + 2);
                int y = this.getGroundY(world, x + 3);
                if (!this.checkGround(world, x + 3, y)) break;
                this.func_74882_a(world, this.field_74887_e, x + 3, y, 0, x + 3, y + 3, 0, false, random, this.getCemeteryCatacombsStones());
            }
        }
    }

    private void createCenterFence(World world, Random random) {
        int y = this.getGroundY(world, 42);
        if (this.checkGround(world, 42, y)) {
            this.func_74882_a(world, this.field_74887_e, 42, y, 0, 42, y + 3, 0, false, random, this.getCemeteryCatacombsStones());
        }
        this.createGrate(world, 43);
        this.createGrate(world, 44);
        this.createGrate(world, 45);
        this.createGrate(world, 46);
        y = this.getGroundY(world, 47);
        if (this.checkGround(world, 47, y)) {
            this.func_74882_a(world, this.field_74887_e, 47, y, 0, 47, y + 3, 0, false, random, this.getCemeteryCatacombsStones());
        }
    }

    private void createCornerFence(World world, Random random, boolean left) {
        int y;
        int x = left ? 89 : 0;
        if (this.checkGround(world, x, y = this.getGroundY(world, x))) {
            this.func_74882_a(world, this.field_74887_e, x, y, 0, x, y + 3, 0, false, random, this.getCemeteryCatacombsStones());
        }
    }

    private int getGroundY(World world, int x) {
        return world.func_72825_h(this.func_74865_a(x, 0), this.func_74873_b(x, 0));
    }

    private boolean checkGround(World world, int x, int y) {
        Block block = world.func_147439_a(this.func_74865_a(x, 0), y, this.func_74873_b(x, 0));
        if (block != null) {
            return !block.equals(Blocks.field_150355_j) && !block.equals(Blocks.field_150353_l);
        }
        return true;
    }

    private boolean checkGround(World world, int startX, int endX, int y) {
        for (int x = startX; x <= endX; ++x) {
            Block block = world.func_147439_a(this.func_74865_a(x, 0), y, this.func_74873_b(x, 0));
            if (block == null || !block.equals(Blocks.field_150355_j) && !block.equals(Blocks.field_150353_l)) continue;
            return false;
        }
        return true;
    }

    private void createGrate(World world, int x) {
        int y = this.getGroundY(world, x);
        if (this.checkGround(world, x, y)) {
            this.func_151549_a(world, this.field_74887_e, x, y, 0, x, y + 3, 0, Blocks.field_150411_aY, Blocks.field_150411_aY, false);
        }
    }

    private void createEntrance(World world, Random random) {
        int y = this.getAverageGroundLevel(world, BoundingBoxHelper.getCorrectBox(this.field_74885_f, this.func_74865_a(42, 0), 0, this.func_74873_b(42, 0), 5, 7, 0, this.xShift));
        if (this.checkGround(world, 42, 47, y)) {
            this.func_74882_a(world, this.field_74887_e, 42, y, 0, 42, y + 3, 0, false, random, this.getCemeteryCatacombsStones());
            this.func_74882_a(world, this.field_74887_e, 47, y, 0, 47, y + 3, 0, false, random, this.getCemeteryCatacombsStones());
            this.func_74882_a(world, this.field_74887_e, 43, y + 4, 0, 43, y + 4, 0, false, random, this.getCemeteryCatacombsStones());
            this.func_74882_a(world, this.field_74887_e, 46, y + 4, 0, 46, y + 4, 0, false, random, this.getCemeteryCatacombsStones());
            this.func_151549_a(world, this.field_74887_e, 43, y, 0, 43, y + 3, 0, Blocks.field_150411_aY, Blocks.field_150411_aY, false);
            this.func_151549_a(world, this.field_74887_e, 46, y, 0, 46, y + 3, 0, Blocks.field_150411_aY, Blocks.field_150411_aY, false);
            this.func_151549_a(world, this.field_74887_e, 44, y + 3, 0, 45, y + 4, 0, Blocks.field_150411_aY, Blocks.field_150411_aY, false);
            this.func_151556_a(world, this.field_74887_e, 44, y + 5, 0, 45, y + 5, 0, (Block)Blocks.field_150333_U, 5, (Block)Blocks.field_150333_U, 5, false);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 42, y + 4, 0, this.field_74887_e);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 47, y + 4, 0, this.field_74887_e);
        }
    }

    protected int getMinimumGroundLevel(World world, StructureBoundingBox structureBoundingBox) {
        int height = 250;
        int curHeight = 0;
        for (int x = this.field_74887_e.field_78897_a; x <= this.field_74887_e.field_78893_d; ++x) {
            if ((curHeight += Math.max(world.func_72825_h(x, 0), world.field_73011_w.func_76557_i())) >= height) continue;
            height = curHeight;
        }
        return height;
    }

    protected int getAverageGroundLevel(World world, StructureBoundingBox structureBoundingBox) {
        int height = 0;
        int count = 0;
        for (int x = this.field_74887_e.field_78897_a; x <= this.field_74887_e.field_78893_d; ++x) {
            height += Math.max(world.func_72825_h(x, 0), world.field_73011_w.func_76557_i());
            ++count;
        }
        if (count == 0) {
            return -1;
        }
        return height / count;
    }

    private static enum FENCE_DIRECTION {
        LEFT,
        RIGHT;

    }
}

