/*
 * Decompiled with CFR 0.152.
 */
package gravestone.structures.catacombs;

import gravestone.structures.catacombs.CatacombsLevel;
import gravestone.structures.catacombs.components.CatacombsBaseComponent;
import gravestone.structures.catacombs.components.Entrance;
import java.util.LinkedList;
import java.util.Random;
import net.minecraft.world.World;

public class CatacombsUnderground {
    private final int direction;
    private CatacombsBaseComponent entrance;

    public CatacombsUnderground(World world, Random rand, int direction, int x, int y, int z) {
        this.direction = direction;
        this.prepareStructurePieces(rand, x, y, z);
        this.build(world, rand);
    }

    private void prepareStructurePieces(Random rand, int x, int y, int z) {
        this.entrance = new Entrance(this.direction, rand, x, y, z);
    }

    public final void build(World world, Random rand) {
        this.entrance.addComponentParts(world, rand);
        LinkedList<CatacombsBaseComponent> startComponents = new LinkedList<CatacombsBaseComponent>();
        startComponents.add(this.entrance);
        CatacombsLevel level = new CatacombsLevel(startComponents, 1, world, rand);
        level = new CatacombsLevel(level.getEndParts(), 2, world, rand);
        level = new CatacombsLevel(level.getEndParts(), 3, world, rand);
        new CatacombsLevel(level.getEndParts(), 4, world, rand);
    }
}

