/*
 * Decompiled with CFR 0.152.
 */
package gravestone.structures.catacombs;

import gravestone.structures.catacombs.CatacombsLevel;
import gravestone.structures.catacombs.components.Bridge;
import gravestone.structures.catacombs.components.CatacombsBaseComponent;
import gravestone.structures.catacombs.components.Corridor;
import gravestone.structures.catacombs.components.CreeperRoom;
import gravestone.structures.catacombs.components.Crossing;
import gravestone.structures.catacombs.components.EnderHall;
import gravestone.structures.catacombs.components.GraveCorridor;
import gravestone.structures.catacombs.components.GraveHall;
import gravestone.structures.catacombs.components.SpidersCorridor;
import gravestone.structures.catacombs.components.StatuesHall;
import gravestone.structures.catacombs.components.TrapCorridor;
import gravestone.structures.catacombs.components.Treasury;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;

public class CatacombsComponentsFactory {
    private CatacombsComponentsFactory() {
    }

    public static Class getNextComponentForLevel(Class componentClass, Random random, int level) {
        int chance = random.nextInt(100);
        switch (level) {
            case 1: {
                if (chance >= 25) {
                    return CatacombsComponentsFactory.getCorridorType(random);
                }
                if (chance >= 10) {
                    if (componentClass == Crossing.class) {
                        return CatacombsComponentsFactory.getCorridorType(random);
                    }
                    return CatacombsComponentsFactory.getCrossingType(random);
                }
                if (chance >= 5) {
                    if (componentClass == SpidersCorridor.class) {
                        return CatacombsComponentsFactory.getCorridorType(random);
                    }
                    return SpidersCorridor.class;
                }
                if (componentClass == EnderHall.class) {
                    return CatacombsComponentsFactory.getCorridorType(random);
                }
                return EnderHall.class;
            }
        }
        if (chance >= 55) {
            return CatacombsComponentsFactory.getCorridorType(random);
        }
        if (chance >= 40) {
            if (componentClass == Crossing.class) {
                return CatacombsComponentsFactory.getCorridorType(random);
            }
            return CatacombsComponentsFactory.getCrossingType(random);
        }
        if (chance >= 30) {
            if (componentClass == SpidersCorridor.class) {
                return CatacombsComponentsFactory.getCorridorType(random);
            }
            return SpidersCorridor.class;
        }
        if (chance >= 20) {
            if (componentClass == EnderHall.class) {
                return CatacombsComponentsFactory.getCorridorType(random);
            }
            return EnderHall.class;
        }
        if (chance >= 10) {
            return CatacombsComponentsFactory.getHallType(random);
        }
        if (chance >= 5) {
            if (componentClass == Bridge.class) {
                return CatacombsComponentsFactory.getCorridorType(random);
            }
            return Bridge.class;
        }
        return Treasury.class;
    }

    public static Class getNextComponent(Class componentClass, CatacombsLevel.COMPONENT_SIDE componentSide, Random random, int level) {
        if (componentSide == CatacombsLevel.COMPONENT_SIDE.TOP) {
            return CatacombsComponentsFactory.getNextComponentForLevel(componentClass, random, level);
        }
        if (level == 1 || random.nextInt(100) >= 5) {
            return Corridor.class;
        }
        return Treasury.class;
    }

    public static Class getCorridorType(Random random) {
        int corridorChance = random.nextInt(100);
        if (corridorChance >= 65) {
            return Corridor.class;
        }
        if (corridorChance >= 10) {
            return GraveCorridor.class;
        }
        return TrapCorridor.class;
    }

    private static Class getCrossingType(Random random) {
        if (random.nextInt(100) >= 10) {
            return Crossing.class;
        }
        return CreeperRoom.class;
    }

    private static Class getHallType(Random random) {
        int hallChance = random.nextInt(10);
        if (hallChance >= 2) {
            return GraveHall.class;
        }
        return StatuesHall.class;
    }

    public static CatacombsBaseComponent createComponent(CatacombsBaseComponent component, Random random, int direction, int level, Class buildComponent, CatacombsLevel.COMPONENT_SIDE componentSide) {
        if (component != null) {
            int z;
            int x;
            int y = component.getYEnd();
            if (componentSide == CatacombsLevel.COMPONENT_SIDE.TOP) {
                x = component.getTopXEnd();
                z = component.getTopZEnd();
            } else if (componentSide == CatacombsLevel.COMPONENT_SIDE.LEFT) {
                x = component.getLeftXEnd();
                z = component.getLeftZEnd();
            } else {
                x = component.getRightXEnd();
                z = component.getRightZEnd();
            }
            try {
                Constructor constructor = buildComponent.getConstructor(Integer.TYPE, Integer.TYPE, Random.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                component = (CatacombsBaseComponent)((Object)constructor.newInstance(direction, level, random, x, y, z));
                return component;
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

