/*
 * Decompiled with CFR 0.152.
 */
package gravestone.models.block.memorials;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gravestone.block.enums.EnumMemorials;
import gravestone.core.Resources;
import gravestone.models.block.ModelMemorial;
import gravestone.models.block.memorials.ModelBigPedestal;
import gravestone.renderer.tileentity.TileEntityGSMemorialRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelSteveStatueMemorial
extends ModelMemorial {
    public ModelRenderer bipedHead;
    public ModelRenderer bipedBody;
    public ModelRenderer bipedRightArm;
    public ModelRenderer bipedLeftArm;
    public ModelRenderer bipedRightLeg;
    public ModelRenderer bipedLeftLeg;
    public int heldItemLeft;
    public int heldItemRight;
    ModelBigPedestal pedestal;

    public ModelSteveStatueMemorial() {
        float par1 = 0.0f;
        float par2 = 0.0f;
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.heldItemLeft = 0;
        this.heldItemRight = 0;
        this.bipedHead = new ModelRenderer((ModelBase)this, 0, 0);
        this.bipedHead.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, par1);
        this.bipedHead.func_78793_a(0.0f, 0.0f + par2, 0.0f);
        this.bipedBody = new ModelRenderer((ModelBase)this, 16, 16);
        this.bipedBody.func_78790_a(-4.0f, 0.0f, -2.0f, 8, 12, 4, par1);
        this.bipedBody.func_78793_a(0.0f, 0.0f + par2, 0.0f);
        this.bipedRightArm = new ModelRenderer((ModelBase)this, 40, 16);
        this.bipedRightArm.func_78790_a(-3.0f, -2.0f, -2.0f, 4, 12, 4, par1);
        this.bipedRightArm.func_78793_a(-5.0f, 2.0f + par2, 0.0f);
        this.bipedLeftArm = new ModelRenderer((ModelBase)this, 40, 16);
        this.bipedLeftArm.field_78809_i = true;
        this.bipedLeftArm.func_78790_a(-1.0f, -2.0f, -2.0f, 4, 12, 4, par1);
        this.bipedLeftArm.func_78793_a(5.0f, 2.0f + par2, 0.0f);
        this.bipedRightLeg = new ModelRenderer((ModelBase)this, 0, 16);
        this.bipedRightLeg.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, par1);
        this.bipedRightLeg.func_78793_a(-1.9f, 12.0f + par2, 0.0f);
        this.bipedLeftLeg = new ModelRenderer((ModelBase)this, 0, 16);
        this.bipedLeftLeg.field_78809_i = true;
        this.bipedLeftLeg.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, par1);
        this.bipedLeftLeg.func_78793_a(1.9f, 12.0f + par2, 0.0f);
        this.pedestal = new ModelBigPedestal();
    }

    public void setRotationAngles(float par1, float par2, float par3, float par4, float par5, float par6) {
        this.bipedHead.field_78796_g = par4 / 57.295776f;
        this.bipedHead.field_78795_f = par5 / 57.295776f;
        this.bipedRightArm.field_78795_f = MathHelper.func_76134_b((float)(par1 * 0.6662f + (float)Math.PI)) * 2.0f * par2 * 0.5f;
        this.bipedLeftArm.field_78795_f = MathHelper.func_76134_b((float)(par1 * 0.6662f)) * 2.0f * par2 * 0.5f;
        this.bipedRightArm.field_78808_h = 0.0f;
        this.bipedLeftArm.field_78808_h = 0.0f;
        this.bipedRightLeg.field_78795_f = MathHelper.func_76134_b((float)(par1 * 0.6662f)) * 1.4f * par2;
        this.bipedLeftLeg.field_78795_f = MathHelper.func_76134_b((float)(par1 * 0.6662f + (float)Math.PI)) * 1.4f * par2;
        this.bipedRightLeg.field_78796_g = 0.0f;
        this.bipedLeftLeg.field_78796_g = 0.0f;
        this.bipedRightArm.field_78796_g = 0.0f;
        this.bipedLeftArm.field_78796_g = 0.0f;
        this.bipedBody.field_78795_f = 0.0f;
        this.bipedRightLeg.field_78798_e = 0.1f;
        this.bipedLeftLeg.field_78798_e = 0.1f;
        this.bipedRightLeg.field_78797_d = 12.0f;
        this.bipedLeftLeg.field_78797_d = 12.0f;
        this.bipedHead.field_78797_d = 0.0f;
        this.bipedRightArm.field_78808_h += MathHelper.func_76134_b((float)(par3 * 0.09f)) * 0.05f + 0.05f;
        this.bipedLeftArm.field_78808_h -= MathHelper.func_76134_b((float)(par3 * 0.09f)) * 0.05f + 0.05f;
        this.bipedRightArm.field_78795_f += MathHelper.func_76126_a((float)(par3 * 0.067f)) * 0.05f;
        this.bipedLeftArm.field_78795_f -= MathHelper.func_76126_a((float)(par3 * 0.067f)) * 0.05f;
    }

    @Override
    public void renderAll() {
        this.setRotationAngles(0.0625f, 0.0625f, 0.0625f, 0.0625f, 0.0625f, 0.0625f);
        ModelSteveStatueMemorial modelSteveStatueMemorial = this;
        modelSteveStatueMemorial.pedestal.shiftModel();
        this.renderSteve();
        this.renderSteveLegs();
        this.pedestal.renderAll();
    }

    private void renderSteve() {
        float par7 = 0.0625f;
        this.bipedHead.func_78785_a(par7);
        this.bipedBody.func_78785_a(par7);
        this.bipedRightArm.func_78785_a(par7);
        this.bipedLeftArm.func_78785_a(par7);
    }

    private void renderSteveLegs() {
        float par7 = 0.0625f;
        this.bipedRightLeg.func_78785_a(par7);
        this.bipedLeftLeg.func_78785_a(par7);
    }

    @Override
    public void customRender(EnumMemorials memorialType, boolean enchanted) {
        if (enchanted) {
            this.renderEnchanted();
        } else {
            this.renderAll();
        }
        this.renderArmor(memorialType);
    }

    private void renderArmor(EnumMemorials memorialType) {
        ModelSteveStatueMemorial modelSteveStatueMemorial = this;
        modelSteveStatueMemorial.pedestal.shiftModel();
        ResourceLocation texture = null;
        switch (memorialType) {
            case WOODEN_STEVE_STATUE: {
                texture = Resources.WOODEN_ARMOR;
                break;
            }
            case SANDSTONE_STEVE_STATUE: {
                texture = Resources.SANDSTONE_ARMOR;
                break;
            }
            case STONE_STEVE_STATUE: {
                texture = Resources.STONE_ARMOR;
                break;
            }
            case MOSSY_STEVE_STATUE: {
                texture = Resources.MOSSY_ARMOR;
                break;
            }
            case IRON_STEVE_STATUE: {
                texture = Resources.IRON_ARMOR;
                break;
            }
            case GOLDEN_STEVE_STATUE: {
                texture = Resources.GOLDEN_ARMOR;
                break;
            }
            case DIAMOND_STEVE_STATUE: {
                texture = Resources.DIAMOND_ARMOR;
                break;
            }
            case EMERALD_STEVE_STATUE: {
                texture = Resources.EMERALD_ARMOR;
                break;
            }
            case LAPIS_STEVE_STATUE: {
                texture = Resources.LAPIS_ARMOR;
                break;
            }
            case REDSTONE_STEVE_STATUE: {
                texture = Resources.REDSTONE_ARMOR;
                break;
            }
            case OBSIDIAN_STEVE_STATUE: {
                texture = Resources.OBSIDIAN_ARMOR;
                break;
            }
            case QUARTZ_STEVE_STATUE: {
                texture = Resources.QUARTZ_ARMOR;
                break;
            }
            case ICE_STEVE_STATUE: {
                texture = Resources.ICE_ARMOR;
            }
        }
        if (texture != null) {
            float scale = 1.1f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            TileEntityGSMemorialRenderer.instance.bindTextureByName(texture);
            this.renderSteve();
        }
    }

    @Override
    public void setPedestalTexture(ResourceLocation texture) {
        this.pedestal.setTexture(texture);
    }
}

